<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1>
            <?= $this->config->item('icons')['contracts']; ?>
            <?php echo html_entity_decode($title); ?>
        </h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body _buttons">
                        <?php if (has_permission('contracts', '', 'create')) { ?>
                            <a href="<?php echo admin_url('contracts/contract'); ?>" class="btn btn-info pull-left display-block">
                                <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE: echo _l('new_contract'); ?>
                            </a>
                        <?php } ?>
                        <?php $this->load->view('admin/contracts/filters'); ?>
                        <div class="clearfix" style="margin-bottom: 20px;"></div>

                        <div class="x-panel_s">
                            <?php echo form_hidden('custom_view'); ?>
                            <div class="x-panel-body">
                                <?php $this->load->view('admin/contracts/table_html'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php init_tail(); ?>
        <script>
            $(function () {

                var ContractsServerParams = {};
                $.each($('._hidden_inputs._filters input'), function () {
                    ContractsServerParams[$(this).attr('name')] = '[name="' + $(this).attr('name') + '"]';
                });

                initDataTable('.table-contracts', admin_url + 'contracts/table', undefined, undefined, ContractsServerParams,<?php echo hooks()->apply_filters('contracts_table_default_order', json_encode(array(6, 'asc'))); ?>);

                <?php /* Charts moved do Dashboard / legal */ ?>
            });
        </script>
        </body>
        </html>
