<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script>
    var currencies = <?php echo json_encode($currencies); ?>;
    var doc_type = 'credit_note';
    var settings = <?= json_encode($settings); ?>;
    var invoice_settings = <?= json_encode($credit_note_settings); ?>;
    var doc_rates = {};
</script>


<div id="wrapper">
    <div class="breadcrumb"><a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;
        <a href="<?php echo admin_url(" credit_notes "); ?>">
            <?php echo _l('credit_notes'); ?>
        </a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;
        <?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['invoices']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <?php
            echo form_open($this->uri->uri_string(), array('id' => 'credit-note-form', 'class' => '_transaction_form credit-note-form'));
            if (isset($credit_note)) {
                echo form_hidden('isedit');
            }
            ?>
            <div class="col-md-12">
                <div class="panel_s credit_note accounting-template">
                    <div class="additional"></div>
                    <div class="panel-body">
                        <?php if (isset($credit_note)) { ?>
                            <?php echo format_credit_note_status($credit_note->status); ?>
                            <hr class="hr-panel-heading"/>
                        <?php } ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="f_client_id">
                                    <div class="form-group select-placeholder">
                                        <label for="clientid" class="control-label">
                                            <?php echo _l('client'); ?>
                                        </label>
                                        <select disabled id="clientid" name="clientid" data-live-search="true" data-width="100%" class="ajax-search<?php if (isset($credit_note) && empty($credit_note->clientid)) {
                                            echo ' customer-removed';
                                        } ?>" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                            <?php $selected = (isset($credit_note) ? $credit_note->clientid : '');
                                            if ($selected == '') {
                                                $selected = (isset($customer_id) ? $customer_id : '');
                                            }
                                            if ($selected != '') {
                                                $rel_data = get_relation_data('customer', $selected);
                                                $rel_val = get_relation_values($rel_data, 'customer');
                                                echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
                                            } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group projects-wrapper<?php if ((!isset($credit_note)) || (isset($credit_note) && !customer_has_projects($credit_note->clientid))) {
                                    echo ' hide';
                                } ?>">
                                    <label for="project_id">
                                        <?php echo _l('project'); ?>
                                    </label>
                                    <div id="project_ajax_search_wrapper">
                                        <select name="project_id" id="project_id" class="projects ajax-search" data-live-search="true" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                            <?php
                                            if (isset($credit_note) && $credit_note->project_id != 0) {
                                                echo '<option value="' . $credit_note->project_id . '" selected>' . get_project_name_by_id($credit_note->project_id) . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <hr class="hr-10"/>
                                        <a href="#" class="edit_shipping_billing_info" data-toggle="modal" data-target="#billing_and_shipping_details"><i class="fal fa-pencil-square-o"></i></a>
                                        <?php include_once(APPPATH . 'views/admin/credit_notes/billing_and_shipping_template.php'); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="bold">
                                            <?php echo _l('credit_note_bill_to'); ?>
                                        </p>
                                        <address>
     <span class="billing_street">
       <?php $billing_street = (isset($credit_note) ? $credit_note->billing_street : '--'); ?>
       <?php $billing_street = ($billing_street == '' ? '--' : $billing_street); ?>
       <?php echo $billing_street; ?></span><br>
                                            <span class="billing_city">
         <?php $billing_city = (isset($credit_note) ? $credit_note->billing_city : '--'); ?>
         <?php $billing_city = ($billing_city == '' ? '--' : $billing_city); ?>
         <?php echo $billing_city; ?></span>,
                                            <span class="billing_state">
           <?php $billing_state = (isset($credit_note) ? get_state_name($credit_note->billing_state) : '--'); ?>
           <?php $billing_state = ($billing_state == '' ? '--' : $billing_state); ?>
           <?php echo $billing_state; ?></span>
                                            <br/>
                                            <span class="billing_country">
             <?php $billing_country = (isset($credit_note) ? get_country_name($credit_note->billing_country) : '--'); ?>
             <?php $billing_country = ($billing_country == '' ? '--' : $billing_country); ?>
             <?php echo $billing_country; ?></span>,
                                            <span class="billing_zip">
               <?php $billing_zip = (isset($credit_note) ? $credit_note->billing_zip : '--'); ?>
               <?php $billing_zip = ($billing_zip == '' ? '--' : $billing_zip); ?>
               <?php echo $billing_zip; ?></span>
                                        </address>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="bold">
                                            <?php echo _l('ship_to'); ?>
                                        </p>
                                        <address>
             <span class="shipping_street">
               <?php $shipping_street = (isset($credit_note) ? $credit_note->shipping_street : '--'); ?>
               <?php $shipping_street = ($shipping_street == '' ? '--' : $shipping_street); ?>
               <?php echo $shipping_street; ?></span><br>
                                            <span class="shipping_city">
                 <?php $shipping_city = (isset($credit_note) ? $credit_note->shipping_city : '--'); ?>
                 <?php $shipping_city = ($shipping_city == '' ? '--' : $shipping_city); ?>
                 <?php echo $shipping_city; ?></span>,
                                            <span class="shipping_state">
                   <?php $shipping_state = (isset($credit_note) ? get_state_name($credit_note->shipping_state) : '--'); ?>
                   <?php $shipping_state = ($shipping_state == '' ? '--' : $shipping_state); ?>
                   <?php echo $shipping_state; ?></span>
                                            <br/>
                                            <span class="shipping_country">
                     <?php $shipping_country = (isset($credit_note) ? get_country_name($credit_note->shipping_country) : '--'); ?>
                     <?php $shipping_country = ($shipping_country == '' ? '--' : $shipping_country); ?>
                     <?php echo $shipping_country; ?></span>,
                                            <span class="shipping_zip">
                       <?php $shipping_zip = (isset($credit_note) ? $credit_note->shipping_zip : '--'); ?>
                       <?php $shipping_zip = ($shipping_zip == '' ? '--' : $shipping_zip); ?>
                       <?php echo $shipping_zip; ?></span>
                                        </address>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php $value = (isset($credit_note) ? _d($credit_note->date) : _d(date('Y-m-d'))); ?>
                                        <?php echo render_date_input('date', 'credit_note_date', $value); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="number">
                                                <?php echo _l('credit_note_number'); ?>
                                            </label>
                                            <?php if (isset($credit_note)){ ?>
                                            <div class="form-group select-wrapper">
                                                <?php
                                                $isedit = isset($credit_note) ? 'true' : 'false';
                                                $series = $this->credit_notes_model->get_series();
                                                $default = $this->credit_notes_model->get_seria();

                                                if (!empty($series)) {
                                                    echo '<select disabled name="s_prefix" id="select_seria" class="form-control">';
                                                    foreach ($series as $key => $value) { ?>
                                                        <option value="<?= $value['name'] ?>" <?= $value['name'] == $credit_note->prefix ? "selected" : ""; ?>>
                                                            <?= strtoupper($value['name']) . '' . sales_number_format(($value['current_number'] === $credit_note->number ? (int)$value['current_number'] : (int)$value['current_number'] + 1), 1, null, null); ?>
                                                        </option>
                                                    <?php }
                                                    echo '</select></div>';
                                                } ?>
                                                <input type="hidden"
                                                        data-original-number="<?php echo $credit_note->number; ?>"
                                                        data-isedit="<?php echo $isedit; ?>"
                                                        name="number"
                                                        class="form-control"
                                                        value="<?php echo $credit_note->number ?>"
                                                        style="height: 30px !important; flex: 1;">
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="panel_s no-shadow">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <?php

                                                $credit_note_currency_attr = array('data-show-subtext' => true, 'disabled' => true); //'disabled'=>true,
                                                $credit_note_currency_attr = apply_filters_deprecated('credit_note_currency_disabled', [$credit_note_currency_attr], '2.3.0', 'credit_note_currency_attributes');

                                                foreach ($currencies as $currency) {
                                                    if ($currency['isdefault'] == 1) {
                                                        $credit_note_currency_attr['data-base'] = $currency['id'];
                                                    }
                                                    if (isset($credit_note)) {
                                                        if ($currency['id'] == $credit_note->currency) {
                                                            $selected = $currency['id'];
                                                        }
                                                    } else {
                                                        if ($currency['isdefault'] == 1) {
                                                            $selected = $currency['id'];
                                                        }
                                                    }
                                                }
                                                $credit_note_currency_attr = hooks()->apply_filters('credit_note_currency_attributes', $credit_note_currency_attr);
                                                ?>
                                                <?php echo render_select('currency', $currencies, array('id', 'name', 'symbol'), 'currency', $selected, $credit_note_currency_attr); ?>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group select-placeholder">
                                                    <label for="discount_type" class="control-label">
                                                        <?php echo _l('discount_type'); ?>
                                                    </label>
                                                    <select disabled name="discount_type" class="selectpicker" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                                        <option value="" selected>
                                                            <?php echo _l('no_discount'); ?>
                                                        </option>
                                                        <option value="before_tax" <?php if (isset($credit_note)) {
                                                            if ($credit_note->discount_type == 'before_tax') {
                                                                echo 'selected';
                                                            }
                                                        } ?>>
                                                            <?php echo _l('discount_type_before_tax'); ?>
                                                        </option>
                                                        <option value="after_tax" <?php if (isset($credit_note)) {
                                                            if ($credit_note->discount_type == 'after_tax') {
                                                                echo 'selected';
                                                            }
                                                        } ?>>
                                                            <?php echo _l('discount_type_after_tax'); ?>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <?php $value = (isset($credit_note) ? $credit_note->reference_no : ''); ?>
                                        <?php echo render_input('reference_no', 'reference_no', $value, null, array('disabled' => true)); ?>
                                        <?php $value = (isset($credit_note) ? $credit_note->adminnote : ''); ?>
                                        <?php echo render_textarea('adminnote', 'credit_note_admin_note', $value, array('disabled' => true)); ?>
                                        <?php $rel_id = (isset($credit_note) ? $credit_note->id : false); ?>
                                        <?php echo render_custom_fields('credit_note', $rel_id); ?>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="panel-body mtop10">
                            <div class="row">
                                <div class="col-md-4">

                                </div>
                                <div class="col-md-8 text-right show_quantity_as_wrapper">
                                    <?php /* <div class="mtop10"> <span><?php echo _l('show_quantity_as'); ?> </span>
												<div class="radio radio-primary radio-inline">
													<input type="radio" value="1" id="sq_1" name="show_quantity_as" data-text="<?php echo _l('credit_note_table_quantity_heading'); ?>" <?php if(isset($credit_note) && $credit_note->show_quantity_as == 1){echo 'checked';}else if(!isset($hours_quantity) && !isset($qty_hrs_quantity)){echo'checked';} ?>>
													<label for="sq_1">
														<?php echo _l('quantity_as_qty'); ?>
													</label>
												</div>
												<div class="radio radio-primary radio-inline">
													<input type="radio" value="2" id="sq_2" name="show_quantity_as" data-text="<?php echo _l('credit_note_table_hours_heading'); ?>" <?php if(isset($credit_note) && $credit_note->show_quantity_as == 2 || isset($hours_quantity)){echo 'checked';} ?>>
													<label for="sq_2">
														<?php echo _l('quantity_as_hours'); ?>
													</label>
												</div>
												<div class="radio radio-primary radio-inline">
													<input type="radio" value="3" id="sq_3" name="show_quantity_as" data-text="<?php echo _l('credit_note_table_quantity_heading'); ?>/<?php echo _l('credit_note_table_hours_heading'); ?>" <?php if(isset($credit_note) && $credit_note->show_quantity_as == 3 || isset($qty_hrs_quantity)){echo 'checked';} ?>>
													<label for="sq_3">
														<?php echo _l('credit_note_table_quantity_heading'); ?>/
															<?php echo _l('credit_note_table_hours_heading'); ?>
													</label>
												</div>
											</div> */ ?>
                                </div>
                            </div>


                            <?php
                            $this->load->view('admin/invoice_items/item_table_editable_crn');
                            ?>


                            <div class="col-md-8 col-md-offset-4">
                                <table class="table text-right">
                                    <tbody>
                                    <tr id="subtotal">
                                        <td><span class="bold"><?php echo _l('credit_note_subtotal'); ?> :</span></td>
                                        <td class="subtotal"></td>
                                    </tr>
                                    <tr id="discount_area">
                                        <td>
                                            <div class="row">
                                                <div class="col-md-7">
                                                    <span class="bold"><?php echo _l('credit_note_discount'); ?></span>
                                                </div>
                                                <div class="col-md-5">
                                                    <div class="input-group" id="discount-total">
                                                        <input readonly type="number" value="<?php echo(isset($credit_note) ? $credit_note->discount_percent : 0); ?>" class="form-control pull-left input-discount-percent<?php if (isset($credit_note) && !is_sale_discount($credit_note, 'percent') && is_sale_discount_applied($credit_note)) {
                                                            echo ' hide';
                                                        } ?>" min="0" max="100" name="discount_percent">
                                                        <input readonly type="number" data-toggle="tooltip" data-title="<?php echo _l('numbers_not_formatted_while_editing'); ?>" value="<?php echo(isset($credit_note) ? $credit_note->discount_total : 0); ?>" class="form-control pull-left input-discount-fixed<?php if (!isset($credit_note) || (isset($credit_note) && !is_sale_discount($credit_note, 'fixed'))) {
                                                            echo ' hide';
                                                        } ?>"  name="discount_total">
                                                        <div class="input-group-addon">
                                                            <div class="dropdown">
                                                                <a disabled class="dropdown-toggle" id="dropdown_menu_tax_total_type" aria-haspopup="true" aria-expanded="true"> <span class="discount-total-type-selected">
            <?php if (!isset($credit_note) || isset($credit_note) && (is_sale_discount($credit_note, 'percent') || !is_sale_discount_applied($credit_note))) {
                echo '%';
            } else {
                echo _l('discount_fixed_amount');
            }
            ?>
          </span> <span class="caret"></span> </a>
                                                                <ul class="dropdown-menu" id="discount-total-type-dropdown" aria-labelledby="dropdown_menu_tax_total_type">
                                                                    <li>
                                                                        <a class="discount-total-type discount-type-percent<?php if (!isset($credit_note) || (isset($credit_note) && is_sale_discount($credit_note, 'percent')) || (isset($credit_note) && !is_sale_discount_applied($credit_note))) {
                                                                            echo ' selected';
                                                                        } ?>">%</a></li>
                                                                    <li>
                                                                        <a disabled class="discount-total-type discount-type-fixed<?php if (isset($credit_note) && is_sale_discount($credit_note, 'fixed')) {
                                                                            echo ' selected';
                                                                        } ?>">
                                                                            <?php echo _l('discount_fixed_amount'); ?>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="discount-total"></td>
                                    </tr>
                                    <!--<tr>
													<td>
														<div class="row">
															<div class="col-md-7"> <span class="bold"><?php echo _l('credit_note_adjustment'); ?></span> </div>
															<div class="col-md-5">
																<input type="number" data-toggle="tooltip" data-title="<?php echo _l('numbers_not_formatted_while_editing'); ?>" value="<?php if (isset($credit_note)) {
                                        echo $credit_note->adjustment;
                                    } else {
                                        echo 0;
                                    } ?>" class="form-control pull-left" name="adjustment"> </div>
														</div>
													</td>
													<td class="adjustment"></td>
												</tr>-->
                                    <tr>
                                        <td><span class="bold"><?php echo _l('credit_note_total'); ?> :</span></td>
                                        <td class="total"></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div id="removed-items"></div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 mtop15">
                                <div class="panel-body bottom-transaction">
                                    <?php $value = (isset($credit_note) ? $credit_note->clientnote : get_option('predefined_clientnote_credit_note')); ?>
                                    <?php echo render_textarea('clientnote', 'credit_note_add_edit_client_note', $value, array(), array(), 'mtop15'); ?>
                                    <?php $value = (isset($credit_note) ? $credit_note->terms : get_option('predefined_terms_credit_note')); ?>
                                    <?php echo render_textarea('terms', 'terms_and_conditions', $value, array(), array(), 'mtop15'); ?>
                                    <div class="btn-bottom-toolbar text-right">
                                        <button type="button" class="btn-tr btn btn-info mleft10 credit-note-form-submit save-and-send transaction-submit invoiceSave">
                                            <?php echo _l('save_and_send'); ?>
                                        </button>
                                        <button class="btn-tr btn btn-info mleft10 text-right credit-note-form-submit transaction-submit invoiceSave">
                                            <?php echo _l('submit'); ?>
                                        </button>
                                    </div>
                                </div>
                                <div class="btn-bottom-pusher"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
                <?php $this->load->view('admin/invoice_items/item'); ?>
            </div>
        </div>

    </div>
    <?php show_footer(); ?><?php init_tail(); ?>
    <script>
        $(function () {
            validate_credit_note_form();
            // Init accountacy currency symbol
            init_currency();
            init_ajax_project_search_by_customer_id();
            // Maybe items ajax search
            init_ajax_search('items', '#item_select.ajax-search', undefined, admin_url + 'items/search');
        });

        function get_bcountry_states(el, state_id_selected = false) {
            $.post(admin_url + 'misc/get_country_states/' + $(el).val()).done(function (response) {
                response = JSON.parse(response);
                if (response.success == true) {
                    $('select[name="billing_state"]').html(response.html);
                    if (state_id_selected) {
                        $('select[name=billing_state]').val(state_id_selected);
                    }
                    $('select[name="billing_state"]').selectpicker('refresh');

                }
            });
        }

        function get_scountry_states(el, state_id_selected = false) {
            $.post(admin_url + 'misc/get_country_states/' + $(el).val()).done(function (response) {
                response = JSON.parse(response);
                if (response.success == true) {
                    $('select[name="shipping_state"]').html(response.html);
                    if (state_id_selected) {
                        $('select[name=shipping_state]').val(state_id_selected);
                    }
                    $('select[name="shipping_state"]').selectpicker('refresh');

                }
            });
        }

        $(document).ready(function () {
            var billing_country = $('#billing_country');
            var state_id_selected = $('#billing_state').val();
            get_bcountry_states(billing_country, state_id_selected);

            var shipping_country = $('#shipping_country');
            var state_id_selected = $('#shipping_state').val();
            get_scountry_states(shipping_country, state_id_selected);
        });
    </script>
    </body>

    </html>
