<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<h4 class="no-mtop mbot15">
   <?php echo _l('gdpr_right_to_erasure'); ?>
</h4>
<ul class="nav nav-tabs " role="tablist">
    <li role="presentation" class="active">
       <a href="#forgotten_options" aria-controls="forgotten_options" role="tab" data-toggle="tab">
          <?= _l('gdpr_config'); ?>
      </a>
  </li>
  <li role="presentation">
   <a href="#removal_requests" aria-controls="removal_requests" role="tab" data-toggle="tab">
       <?= _l('removal_requests'); ?>
       <?php if($not_pending_requests > 0){ ?>
       <span class="badge"><?php echo $not_pending_requests; ?></span>
       <?php } ?>
   </a>
</li>
</ul>
<div class="tab-content">
    <div role="tabpanel" class="tab-pane active" id="forgotten_options">
        <h4 class="no-mtop"><?= ucfirst(_l('customer_contacts')); ?></h4>
        <hr class="hr-panel-heading">
        <?php render_yes_no_option('gdpr_contact_enable_right_to_be_forgotten', _l('enable_contact_to_request_data_removal')); ?>
        <hr />
        <?php render_yes_no_option('gdpr_on_forgotten_remove_invoices_credit_notes', _l('gdpr_on_forgotten_remove_invoices_credit_notes')); ?>
        <hr />
        <?php render_yes_no_option('gdpr_on_forgotten_remove_estimates', _l('gdpr_on_forgotten_remove_estimates')); ?>
        <hr class="hr-panel-heading">
        <h4><?= ucfirst(_l('profile')); ?></h4>
        <hr class="hr-panel-heading">
        <?php render_yes_no_option('gdpr_lead_enable_right_to_be_forgotten', _l('gdpr_lead_enable_right_to_be_forgotten')); ?>
        <hr />
        <?php render_yes_no_option('gdpr_after_lead_converted_delete', _l('gdpr_after_lead_converted_delete')); ?>
        <hr />
    </div>
    <div role="tabpanel" class="tab-pane" id="removal_requests">
        <table class="table dt-table scroll-responsive" data-order-type="desc" data-order-col="4">
            <thead>
                <tr>
                    <th><?= _l('gdpr_column_requiest_id'); ?></th>
                    <th><?= _l('gdpr_column_request_from'); ?></th>
                    <th><?= _l('gdpr_column_request_description'); ?></th>
                    <th><?= _l('gdpr_column_request_status'); ?></th>
                    <th><?= _l('gdpr_column_request_date'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                foreach($requests as $request) { ?>
                <tr>
                    <td data-order="<?php echo $request['id']; ?>"><?php echo $request['id']; ?></td>
                    <td><?php echo $request['request_from']; ?>
                        <?php if(!empty($request['contact_id'])) {
                            echo '<span class="label label-info pull-right">'.ucfirst(_l('contact')).'</span>';
                        } else if(!empty($request['lead_id'])) {
                            echo '<span class="label label-info pull-right">'.ucfirst(_l('lead')).'</span>';
                        }
                        ?>
                    </td>
                    <td><?php echo $request['description']; ?></td>
                    <td data-order="<?php echo $request['status']; ?>">
                        <select class="selectpicker removalStatus" name="status" data-id="<?php echo $request['id']; ?>"  width="100%">
                            <option value="pending"<?php if($request['status'] == 'pending'){echo ' selected';} ?>><?= _l('gdpr_status_pending'); ?></option>
                            <option value="removed"<?php if($request['status'] == 'removed'){echo ' selected';} ?>><?= _l('gdpr_status_removed'); ?></option>
                            <option value="refused"<?php if($request['status'] == 'refused'){echo ' selected';} ?>><?= _l('gdpr_status_refused'); ?></option>
                        </select>
                    </td>
                    <td data-order="<?php echo $request['request_date']; ?>"><?php echo _dt($request['request_date']); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

</div>
