<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<h4 class="no-mtop">
  <?php echo _l('gdpr_right_to_data_portability'); ?>
  <small>
    <a href="https://gdpr.eu/" target="_blank"><?php echo _l('learn_more'); ?></a>
  </small>
</h4>
<hr class="hr-panel-heading" />
<h4><?= ucfirst(_l('customer_contacts')); ?></h4>
<hr class="hr-panel-heading" />
<?php render_yes_no_option('gdpr_data_portability_contacts',_l('label_gdpr_data_portability_contacts')); ?>
<div class="row">
  <div class="col-md-6">
    <div class="form-group">
      <?php
      $valAllowed = get_option('gdpr_contact_data_portability_allowed');
      if(empty($valAllowed)) {
        $valAllowed = array();
      } else {
        $valAllowed = unserialize($valAllowed);
      }
      ?>
      <label for="gdpr_contact_data_portability_allowed"><?= _l('label_gdpr_contact_data_portability_allowed'); ?></label>
      <div class="select-placeholder">
       <select name="settings[gdpr_contact_data_portability_allowed][]" data-actions-box="true" multiple title="<?= _l('none'); ?>" id="gdpr_contact_data_portability_allowed" class="selectpicker" data-width="100%">
        <option value="profile_data"<?php if(in_array('profile_data', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_profile_data'); ?></option>
        <option value="consent"<?php if(in_array('consent', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_consent'); ?></option>
        <option value="tickets"<?php if(in_array('tickets', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_tickets'); ?></option>
          <option data-divider="true"></option>
          <option value="" disabled="true"><?= _l('gdpr_portability_allow_on_primary_contacts'); ?></option>

         <optgroup label="Customer">
          <option value="customer_profile_data"<?php if(in_array('customer_profile_data', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_customer_profile_data'); ?></option>
          <option value="profile_notes"<?php if(in_array('profile_notes', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_customer_profile_notes'); ?></option>
          <option value="contacts"<?php if(in_array('contacts', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_customer_contacts'); ?></option>
        </optgroup>
        <optgroup label="Invoices">
          <option value="invoices"<?php if(in_array('invoices', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_invoice_data'); ?></option>
          <option value="invoices_notes"<?php if(in_array('invoices_notes', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_invoices_notes'); ?></option>
          <option value="invoices_activity_log"<?php if(in_array('invoices_activity_log', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_invoices_activity_log'); ?></option>
        </optgroup>
        <optgroup label="Estimates">
          <option value="estimates"<?php if(in_array('estimates', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_estimates_data'); ?></option>
          <option value="estimates_notes"<?php if(in_array('invoices_notes', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_estimates_notes'); ?></option>
          <option value="estimates_activity_log"<?php if(in_array('estimates_activity_log', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_estimates_activity_log'); ?></option>
        </optgroup>
        <optgroup label="Projects">
            <option value="projects"<?php if(in_array('projects', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_projects_data'); ?></option>
            <option value="related_tasks"<?php if(in_array('related_tasks', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_related_tasks'); ?></option>
            <option value="related_discussions"<?php if(in_array('related_discussions', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_related_discussions'); ?></option>
            <option value="projects_activity_log"<?php if(in_array('projects_activity_log', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_projects_activity_log'); ?></option>
        </optgroup>

        <option value="credit_notes"<?php if(in_array('credit_notes', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_credit_notes'); ?></option>
        <option value="proposals"<?php if(in_array('proposals', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_proposals'); ?></option>
        <option value="subscriptions"<?php if(in_array('subscriptions', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_subscriptions'); ?></option>
        <option value="expenses"<?php if(in_array('expenses', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_expenses'); ?></option>
        <option value="contracts"<?php if(in_array('contracts', $valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_contracts'); ?></option>


    </select>
  </div>
</div>

</div>
</div>
<hr class="hr-panel-heading" />
<h4><?= ucfirst(_l('leads')); ?></h4>
<hr class="hr-panel-heading" />
<?php render_yes_no_option('gdpr_data_portability_leads','gdpr_enable_leads_export_json'); ?>
<hr />
<div class="row">
  <div class="col-md-6">
    <div class="form-group">
      <?php
      $valAllowed = get_option('gdpr_lead_data_portability_allowed');
      if(empty($valAllowed)) {
        $valAllowed = array();
      } else {
        $valAllowed = unserialize($valAllowed);
      }
      ?>
      <label for="gdpr_lead_data_portability_allowed"><?= _l('gdpr_label_gdpr_lead_data_portability_allowed'); ?></label>
      <div class="select-placeholder">
       <select name="settings[gdpr_lead_data_portability_allowed][]" data-actions-box="true" multiple title="None" id="gdpr_lead_data_portability_allowed" class="selectpicker" data-width="100%">
        <option value=""></option>
        <option value="profile_data"<?php if(in_array('profile_data',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_profile_data'); ?></option>
        <option value="custom_fields"<?php if(in_array('custom_fields',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_custom_fields'); ?></option>
        <option value="notes"<?php if(in_array('notes',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_notes'); ?></option>
        <option value="activity_log"<?php if(in_array('activity_log',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_activity_log'); ?></option>
        <option value="proposals"<?php if(in_array('proposals',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_proposals'); ?></option>
        <option value="integration_emails"<?php if(in_array('integration_emails',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_integration_emails'); ?></option>
        <option value="consent"<?php if(in_array('consent',$valAllowed)){echo ' selected';} ?>><?= _l('gdpr_portability_allow_leads_consent'); ?></option>
      </select>
    </div>
  </div>

</div>
</div>
