<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="<?php echo $locale; ?>">
<head>
    <?php $isRTL = (is_rtl() ? 'true' : 'false'); ?>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="user-scalable=no, width=device-width, initial-scale=1, maximum-scale=1"/>

    <title><?php echo isset($title) ? $title : get_option('companyname'); ?></title>


    <link rel="apple-touch-icon" sizes="180x180" href="<?= base_url(); ?>/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= base_url(); ?>/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= base_url(); ?>/favicon-16x16.png">
    <link rel="manifest" href="<?= base_url(); ?>/site.webmanifest">
    <link rel="mask-icon" href="<?= base_url(); ?>/safari-pinned-tab.svg" color="#a1a1a1">
    <meta name="msapplication-TileColor" content="#17a2b8">
    <meta name="msapplication-TileImage" content="<?= base_url(); ?>/mstile-144x144.png">
    <meta name="theme-color" content="#17a2b8">

    <?php echo app_compile_css(); ?>
    <?php render_admin_js_variables(); ?>

    <script>
        var totalUnreadNotifications = <?php echo $current_user->total_unread_notifications; ?>,
            proposalsTemplates = <?php echo json_encode(get_proposal_templates()); ?>,
            contractsTemplates = <?php echo json_encode(get_contract_templates()); ?>,
            billingAndShippingFields = ['billing_street', 'billing_city', 'billing_state', 'billing_zip', 'billing_country', 'shipping_street', 'shipping_city', 'shipping_state', 'shipping_zip', 'shipping_country'],
            isRTL = '<?php echo $isRTL; ?>',
            taskid, taskTrackingStatsData, taskAttachmentDropzone, taskCommentAttachmentDropzone, newsFeedDropzone,
            expensePreviewDropzone, taskTrackingChart, cfh_popover_templates = {}, _table_api;
        var user_chat_status = 'offline';
        var chat_status = 'offline';
    </script>

    <!--<script type="text/javascript" id="custom" src="https://happydev.ro/connectcrm3/assets/js/custom.js"></script>-->
    <script type="text/javascript" id="custom" src="<?= base_url(); ?>/assets/js/custom.js"></script>
    <?php /*  <script type="text/javascript" id="asbind" src="<?= base_url(); ?>/assets/plugins/as24bind/jquery.as24bind.js"></script>
*/ ?>


    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Fira+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
          rel="stylesheet">
    <link rel="stylesheet" href="<?= base_url('assets/themes/bracket/lib/ionicons/css/ionicons.min.css') ?>"/>
    <link rel="stylesheet" href="<?= base_url('assets/plugins/fontawesome6/css/all.css') ?>"/>

    <!-- <link href="<?= site_url() ?>assets/themes/bracket/lib/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="<?= site_url() ?>assets/themes/bracket/lib/ionicons/css/ionicons.min.css" rel="stylesheet"> -->
    <link rel="stylesheet" href="<?= base_url('assets/css/cards.min.css') ?>"/>
    <link rel="stylesheet" href="<?= base_url('assets/css/crmcon.css') ?>"/>


    <?php app_admin_head(); ?>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-HTJJ6P1GZK"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());

        gtag('config', 'G-HTJJ6P1GZK');
    </script>


    <script>
        window.markerConfig = {
            destination: '631889dd48ee680defb28edd',
            source: 'snippet'
        };

        var binder = [];
    </script>


    <script>
        !function (e, r, a) {
            if (!e.__Marker) {
                e.__Marker = {};
                var t = [], n = {__cs: t};
                ["show", "hide", "isVisible", "capture", "cancelCapture", "unload", "reload", "isExtensionInstalled", "setReporter", "setCustomData", "on", "off"].forEach(function (e) {
                    n[e] = function () {
                        var r = Array.prototype.slice.call(arguments);
                        r.unshift(e), t.push(r)
                    }
                }), e.Marker = n;
                var s = r.createElement("script");
                s.async = 1, s.src = "https://edge.marker.io/latest/shim.js";
                var i = r.getElementsByTagName("script")[0];
                i.parentNode.insertBefore(s, i)
            }
        }(window, document);
    </script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>
<body <?php echo admin_body_class(isset($bodyclass) ? $bodyclass : ''); ?><?php if ($isRTL === 'true') {
    echo 'dir="rtl"';
}; ?>>
<?php
if(isset($active_menu)){
    echo '<input type="hidden" id="active_menu" value="'.admin_url($active_menu).'">';
}
?>
<?php hooks()->do_action('after_body_start'); ?>
