<?php defined('BASEPATH') or exit('No direct script access allowed');
ob_start();
?>
<nav>
    <ul class="nav navbar-nav navbar-left top-search-nav">
        <li id="top_search" class="dropdown" data-toggle="tooltip" data-placement="bottom"
                data-title="<?php echo _l('search_by_tags'); ?>">
            <div class="lupa"><i class="fal fa-search content-lupa"></i></div>
            <input type="search" id="search_input" class="form-control"
                    placeholder="<?php echo _l('top_search_placeholder'); ?>">
            <div id="search_results">
            </div>
            <ul class="dropdown-menu search-results animated fadeIn no-mtop search-history" id="search-history">
            </ul>
        </li>
        <?php /*<li id="top_search_button">
            <button class="btn"><i class="fal fa-search"></i></button>
        </li>*/ ?>
    </ul>
</nav>
<?php
$top_search_area = ob_get_contents();
ob_end_clean();
?>
<div id="header" class="menu-flex">
    <div id="logo">
        <a href="<?= admin_url(); ?>" class="logo img-responsive">
            <img src="<?= site_url('uploads/company/logo-default.png'); ?>" class="img-responsive" alt="">
        </a>
        <?php //get_company_logo(get_admin_uri() . '/') ?>
    </div>
    <div class="hide-menu"><i class="fal fa-align-left"></i></div>
    <?php
    if (!is_mobile()) {
        echo $top_search_area;
    } ?>
    <nav class="header-nav-top">
        <div class="small-logo">
         <span class="text-primary">
           <a href="<?= admin_url(); ?>" class="logo img-responsive">
             <img src="<?= site_url('uploads/company/logo-default.png'); ?>" class="img-responsive" alt="">
          </a>
            <?php //get_company_logo(get_admin_uri() . '/') ?>
         </span>
        </div>
        <div class="mobile-menu">
            <button type="button" class="navbar-toggle visible-md visible-sm visible-xs mobile-menu-toggle collapsed"
                    data-toggle="collapse" data-target="#mobile-collapse" aria-expanded="false">
                <i class="fal fa-chevron-down"></i>
            </button>
            <ul class="mobile-icon-menu">
                <?php
                // To prevent not loading the timers twice
                if (is_mobile()) { ?>
                    <li class="dropdown notifications-wrapper header-notifications">
                        <?php $this->load->view('admin/includes/notifications'); ?>
                    </li>
                    <li class="header-timers">
                        <a href="#" id="top-timers" class="dropdown-toggle top-timers" data-toggle="dropdown"><i
                                    class="icon ion-ios-time-outline tx-24 icon-nou"></i>
                            <span class="label bg-success icon-total-indicator icon-started-timers<?php if ($totalTimers = count($startedTimers) == 0) {
                                echo ' hide';
                            } ?>"><?php echo count($startedTimers); ?></span>
                        </a>
                        <ul class="dropdown-menu animated fadeIn started-timers-top width300" id="started-timers-top">
                            <?php $this->load->view('admin/tasks/started_timers', array('startedTimers' => $startedTimers)); ?>
                        </ul>
                    </li>
                <?php } ?>
            </ul>
            <div class="mobile-navbar collapse" id="mobile-collapse" aria-expanded="false" style="height: 0px;"
                    role="navigation">
                <ul class="nav navbar-nav">

                    <li class="header-my-profile"><a
                                href="<?php echo admin_url('profile'); ?>"><?php echo _l('nav_my_profile'); ?></a></li>


                    <?php if ($this->app_acl->component_loaded('project_management')) { ?>
                        <li class="header-my-timesheets"><a
                                    href="<?php echo admin_url('staff/timesheets'); ?>"><?php echo _l('my_timesheets'); ?></a>
                        </li>
                    <?php } ?>

                    <li class="header-edit-profile"><a
                                href="<?php echo admin_url('staff/edit_profile'); ?>"><?php echo _l('nav_edit_profile'); ?></a>
                    </li>
                    <?php if (is_staff_member()) { ?>
                        <li class="header-newsfeed">
                            <a href="#" class="open_newsfeed mobile">
                                <?php echo _l('whats_on_your_mind'); ?>
                            </a>
                        </li>
                    <?php } ?>
                    <li class="header-logout"><a href="#"
                                onclick="logout(); return false;"><?php echo _l('nav_logout'); ?></a>
                    </li>
                </ul>
            </div>
        </div>
        <ul class="nav navbar-nav navbar-right">
            <?php hooks()->do_action('after_render_top_search'); ?>
            <?php /* <li class="icon icon-email"><a href="<?php echo admin_url('mailbox'); ?>" class="emailicon"><i class="icon ion-ios-email-outline tx-24 icon-nou"></i></a></li> */ ?>
            <?php if (is_admin()) { ?>
                <li class="icon header-todo">
                    <a href="<?php echo admin_url('dashboard/onboarding'); ?>" data-placement="bottom">
                        <?php echo _l('menu_onboarding'); ?>
                    </a>
                </li>
            <?php } ?>

            <?php if ($this->cards) { ?>
                <li class="icon header-todo " data-toggle="tooltip" title="<?php echo _l('assist_mode'); ?>" data-placement="bottom">
                    <a href="" data-toggle="modal" data-target="#asistmode"><i class="fal fa-lightbulb-exclamation-on tx-24 fa-beat" style="--fa-animation-duration: 2s;"></i></a>
                </li>
            <?php } ?>

            <!-- <?php if (is_staff_member()) { ?>
      <li class="icon header-newsfeed">
         <a href="#" class="open_newsfeed desktop" data-toggle="tooltip" title="<?php echo _l('whats_on_your_mind'); ?>" data-placement="bottom"><i class="fal fa-share fa-fw fa-lg" aria-hidden="true"></i></a>
      </li>
            <?php } ?> -->


            <?php if ($this->app_acl->is_zone_available('todo')) { ?>
                <li class="icon header-todo">
                    <a href="<?php echo admin_url('todo'); ?>" data-toggle="tooltip"
                            title="<?php echo _l('nav_todo_items'); ?>" data-placement="bottom"><i
                                class="fas fa-tasks-alt tx-24" aria-hidden="true"></i>
                        <span class="label bg-warning icon-total-indicator nav-total-todos<?php if ($current_user->total_unfinished_todos == 0) {
                            echo ' hide';
                        } ?>"><?php echo $current_user->total_unfinished_todos; ?></span>
                    </a>
                </li>
            <?php } ?>


            <?php if ($this->app_acl->component_loaded('project_management')) { ?>
                <li class="icon header-timers timer-button" data-placement="bottom" data-toggle="tooltip"
                        data-title="<?php echo _l('my_timesheets'); ?>">
                    <a href="#" id="top-timers" class="dropdown-toggle top-timers" data-toggle="dropdown">
                        <i class="fal fa-hourglass tx-24"></i>
                        <span class="label bg-success icon-total-indicator icon-started-timers<?php if ($totalTimers = count($startedTimers) == 0) {
                            echo ' hide';
                        } ?>">
                      <?php echo count($startedTimers); ?>
                   </span>
                    </a>
                    <ul class="dropdown-menu animated fadeIn started-timers-top width350" id="started-timers-top">
                        <?php $this->load->view('admin/tasks/started_timers', array('startedTimers' => $startedTimers)); ?>
                    </ul>
                </li>
            <?php } ?>


            <li class="dropdown notifications-wrapper header-notifications" data-toggle="tooltip"
                    title="<?php echo _l('nav_notifications'); ?>" data-placement="bottom">
                <?php $this->load->view('admin/includes/notifications'); ?>
            </li>
            <li class="icon header-user-profile" data-toggle="tooltip" title="<?php echo get_staff_full_name(); ?>"
                    data-placement="bottom">
                <a href="#" class="dropdown-toggle profile" data-toggle="dropdown"
                        aria-expanded="false"><?php echo get_staff_full_name(); ?>&nbsp;&nbsp;
                    <?php echo staff_profile_image($current_user->staffid, array('img', 'img-responsive', 'staff-profile-image-small', 'pull-right')); ?>
                </a>
                <ul class="dropdown-menu animated fadeIn meniu-my-profile">
                    <div class="img-header">
                        <a href="#" class="dropdown-toggle profile" data-toggle="dropdown"
                                aria-expanded="false">
                            <?php echo staff_profile_image($current_user->staffid, array('img', 'img-responsive', 'text-center', 'imagine-profil-header', 'X-staff-profile-image-big')); ?>
                        </a>
                    </div>
                    <div class="clearfix"></div>
                    <div class="text-center nume-header">
                        <?php echo $current_user->firstname; ?><?php echo $current_user->lastname; ?>
                    </div>
                    <div class="text-center email-header">
                        <?php echo $current_user->email; ?>
                    </div>


                    <div class="col-md-12">
                        <hr/>
                    </div>
                    <li class="header-my-profile li-margin-20"><a
                                href="<?php echo admin_url('profile'); ?>" class="li-header"><i
                                    class="icon ion-ios-person icon-color"></i> <?php echo _l('nav_my_profile'); ?></a>
                    </li>


                    <?php if ($this->app_acl->component_loaded('project_management')) { ?>
                        <li class="header-my-timesheets li-margin-20"><a
                                    href="<?php echo admin_url('staff/timesheets'); ?>" class="li-header"><i
                                        class="icon ion-power icon-color"></i> <?php echo _l('my_timesheets'); ?></a>
                        </li>
                    <?php } ?>

                    <li class="header-edit-profil li-margin-20"><a
                                href="<?php echo admin_url('staff/edit_profile'); ?>" class="li-header"><i
                                    class="icon ion-ios-download icon-color"></i> <?php echo _l('nav_edit_profile'); ?>
                        </a>
                    </li>
                    <!-- <?php if (!is_language_disabled()) { ?>
                        <li class="dropdown-submenu pull-left header-languages">
                            <a href="#" tabindex="-1"><?php echo _l('language'); ?></a>
                            <ul class="dropdown-menu dropdown-menu">
                                <li class="<?php if ($current_user->default_language == "") {
                        echo 'active';
                    } ?>">
                                    <a href="<?php echo admin_url('staff/change_language'); ?>"><i class="icon ion-ios-star"></i> <?php echo _l('system_default_string'); ?></a>
                                </li>
                                <?php foreach ($this->app->get_available_languages() as $user_lang) { ?>
                                <li<?php if ($current_user->default_language == $user_lang) {
                        echo ' class="active"';
                    } ?>>
                                     <a href="<?php echo admin_url('staff/change_language/' . $user_lang); ?>"><i class="icon ion-ios-navigate-outline"></i> <?php echo ucfirst($user_lang); ?></a>
                                    <?php } ?>
                            </ul>
                        </li>
                    <?php } ?> -->
                    <li class="header-logout li-header li-margin-20 li-margin-last-20">
                        <a href="#" onclick="logout(); return false;" class="li-header"><i
                                    class="icon ion-power icon-color"></i> <?php echo _l('nav_logout'); ?></a>
                    </li>
                    <li>

                    </li>
                </ul>
            </li>
            <?php if ($this->app_acl->component_loaded('utilities') or $this->module_model->is_active('prchat') or $this->module_model->is_active('goals')) { ?>
                <li class="icon right-btn">
                    <a id="btnRightMenu" href="#" class="">
                        <i class="fal fa-comments icon-nou"></i>
                    </a>
                </li>
            <?php } ?>

        </ul>
    </nav>
</div>
<div id="mobile-search" class="<?php if (!is_mobile()) {
    echo 'hide';
} ?>">
    <?php
    if (is_mobile()) {
        echo $top_search_area;
    }
    $this->load->model('module_model');
    ?>
</div>
<div class="br-sideright">
    <ul class="nav nav-tabs sidebar-tabs ul-nav-dreapta" role="tablist">
        <?php if ($this->app_acl->component_loaded('utilities')) { ?>
            <li class="nav-item nav-dreapta" id="firstTag">
                <a class="nav-link link-dreapta" data-toggle="tab" role="tab" href="#side_events"><i
                            class="fal fa-calendar-o fa-lg"></i></a>
            </li>
        <?php } ?>
        <?php if ($this->module_model->is_active('prchat')) { ?>
            <li class="nav-item nav-dreapta">
                <a class="nav-link link-dreapta" data-toggle="tab" role="tab" href="#side_ch_i"><i
                            class="fal fa-users fa-lg"></i></a>
            </li>


            <li class="nav-item nav-dreapta">
                <a class="nav-link link-dreapta" data-toggle="tab" role="tab" href="#side_ch_p"><i
                            class="fal fa-users fa-lg"></i></a>
            </li>

        <?php } ?>
        <?php if ($this->module_model->is_active('goals')) { ?>
            <li class="nav-item nav-dreapta">
                <a class="nav-link link-dreapta" data-toggle="tab" role="tab" href="#side_objectives"><i
                            class="fal fa-tasks-alt"></i></a>
            </li>
        <?php } ?>
    </ul><!-- sidebar-tabs -->

    <!-- Tab panes -->
    <div class="tab-content">
        <?php if ($this->app_acl->component_loaded('utilities')) { ?>
            <div class="tab-pane pos-absolute a-0 schedule-scrollbar rsidebar-scroll active" id="side_events"
                    role="tabpanel">

                <?php

                if ($this->module_model->is_active('prchat')) {

                    if ($this->db->table_exists(db_prefix() . 'chatsettings')) {
                        $this->db->where('user_id', get_staff_user_id());
                        $this->db->where('name', 'chat_status');
                        $status_data = $this->db->get(db_prefix() . 'chatsettings')->row_array();
                        if ($status_data) {
                            ?>
                            <div class="pd-x-25">
                                <a href="#" id="chat-status-action"
                                        class="btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2 btn-sidebar-status <?= $status_data['value'] ?>"><?= $status_data['value'] ?></a>

                                <div id="chat-status-options" class="">
                                    <ul>
                                        <li id="status-online"
                                                class="active link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_online'); ?></p>
                                        </li>
                                        <li id="status-away"
                                                class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_away'); ?></p>
                                        </li>
                                        <li id="status-busy"
                                                class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_busy'); ?></p>
                                        </li>
                                        <li id="status-offline"
                                                class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_offline'); ?></p>
                                        </li>
                                    </ul>
                                </div>

                            </div>
                            <?php
                        } else { ?>
                            <div class="pd-x-25">
                                <a href="#" id="chat-status-action"
                                        class="btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2 btn-sidebar-status offline">Offline</a>

                                <div id="chat-status-options" class="">
                                    <ul>

                                        <li id="status-online"
                                                class="active link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_online'); ?></p>
                                        </li>


                                        <li id="status-away"
                                                class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_away'); ?></p>
                                        </li>
                                        <li id="status-busy"
                                                class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_busy'); ?></p>
                                        </li>

                                        <li id="status-offline"
                                                class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">
                                            <span class="status-circle"></span>
                                            <p><?= _l('chat_status_offline'); ?></p>
                                        </li>

                                    </ul>
                                </div>

                            </div>
                        <?php }


                    }//check if module chat exists


                } else { ?>

                <?php }
                ?>


                <label class="sidebar-label pd-x-25 mg-t-25">Event Today</label>
                <div class="sidebar-datepicker"></div>


                <div class="pd-x-25">
                    <?php /*<div class="list-group sidebar-event-list mg-b-20">
                    <?php foreach ($sideEvents as $item){?>
                    <div class="list-group-item">
                        <div>
                            <h6><?=$item['name']?> <i class="fal fa-square" style="color:#<?=$item['color']?>"></i> </h6>

                        </div>
                        <a href="<?=admin_url("hpyevents/view/{$item['id']}")?>" class="more"><i class="fal fa-ellipsis-v tx-18"></i></a>
                    </div>
                    <?php } ?>
                </div> */ ?>

                    <a href="<?= admin_url('utilities/calendar/?create_event_on=' . date('Y-m-d')) ?>"
                            class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">+ <?= _l('rightbar.add_event'); ?></a>
                    <a href="<?= admin_url('todo?create=yes') ?>"
                            class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">+ <?= _l('rightbar.add_todo'); ?></a>
                    <?php /*<a href="<?=admin_url('hpyevents/event?color=00F')?>" class="link-sec-dreapta btn btn-block btn-outline-secondary tx-uppercase tx-12 tx-spacing-2">+ Add Phone Call</a>*/ ?>
                    <br>
                </div>


            </div>
        <?php } ?>
        <?php if ($this->module_model->is_active('prchat')) { ?>
            <div class="tab-pane pos-absolute a-0 contact-scrollbar rsidebar-scroll" id="side_ch_i" role="tabpanel">
                <?php if (!empty($onlineStaffs) > 0) { ?>
                    <label class="sidebar-label pd-x-25 mg-t-25">Online Staff</label>
                    <div class="contact-list pd-x-10">
                        <?php foreach ($onlineStaffs as $item) { ?>
                            <a href="<?= admin_url('prchat/Prchat_Controller/chat_full_view#' . $item['staffid']) ?>"
                                    class="contact-list-link">
                                <div class="d-flex">
                                    <div class="pos-relative">
                                        <?= staff_profile_image($item['staffid'], [
                                            'X-staff-profile-image-small mright5',
                                        ], 'small') ?>
                                        <div class="contact-status-indicator bg-success"></div>
                                    </div>
                                    <div class="contact-person">
                                        <p><?= $item['firstname'] ?> <?= $item['lastname'] ?></p>
                                        <!--<span>Clemson, CA</span>-->
                                    </div>
                                    <!--    <span class="tx-info tx-12 nbr"><span class="square-8 nbr bg-info rounded-circle"></span> 1 new</span>
                                    -->
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php if (!empty($offlineStaffs) > 0) { ?>
                    <label class="sidebar-label pd-x-25 mg-t-25">Offline Staff</label>
                    <div class="contact-list pd-x-10">
                        <?php foreach ($offlineStaffs as $item) { ?>
                            <a href="<?= admin_url('prchat/Prchat_Controller/chat_full_view#' . $item['staffid']) ?>"
                                    class="contact-list-link">
                                <div class="d-flex">
                                    <div class="pos-relative">
                                        <?= staff_profile_image($item['staffid'], [
                                            'X-staff-profile-image-small mright5',
                                        ], 'small') ?>
                                        <div class="contact-status-indicator bg-gray-500"></div>
                                    </div>
                                    <div class="contact-person">
                                        <p><?= $item['firstname'] ?> <?= $item['lastname'] ?></p>
                                        <!--                            <span>Clemson, CA</span>-->
                                    </div>
                                    <span class="tx-info tx-12"><span
                                                class="square-8 bg-info rounded-circle"></span></span>
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
            <div class="tab-pane pos-absolute a-0 contact-scrollbar rsidebar-scroll" id="side_ch_p" role="tabpanel">
                <?php if (!empty($onlineClients) > 0) { ?>
                    <label class="sidebar-label pd-x-25 mg-t-25">Online Clients</label>
                    <div class="contact-list pd-x-10">
                        <?php foreach ($onlineClients as $item) { ?>
                            <a href="<?= admin_url('prchat/Prchat_Controller/chat_full_view?contact_id=' . $item['id']) ?>"
                                    class="contact-list-link">
                                <div class="d-flex">
                                    <div class="pos-relative">
                                        <img src="<?= contact_profile_image_url($item['id'], 'small') ?>"/>
                                        <div class="contact-status-indicator bg-success"></div>
                                    </div>
                                    <div class="contact-person">
                                        <p><?= $item['firstname'] ?> <?= $item['lastname'] ?></p>
                                        <span><?= $item['company'] ?></span>
                                    </div>
                                    <?php /*<span class="tx-info tx-12"><span class="square-8 bg-info rounded-circle"></span></span>*/ ?>
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <?php if (!empty($offlineClients) > 0) { ?>
                    <label class="sidebar-label pd-x-25 mg-t-25">Offline Clients</label>
                    <div class="contact-list pd-x-10">
                        <?php foreach ($offlineClients as $item) { ?>
                            <a href="<?= admin_url('prchat/Prchat_Controller/chat_full_view?contact_id=' . $item['id']) ?>"
                                    class="contact-list-link">
                                <div class="d-flex">
                                    <div class="pos-relative">
                                        <img src="<?= contact_profile_image_url($item['id'], 'small') ?>"/>
                                        <div class="contact-status-indicator bg-gray-500"></div>
                                    </div>
                                    <div class="contact-person">
                                        <p><?= $item['firstname'] ?> <?= $item['lastname'] ?></p>
                                        <span><?= $item['company'] ?></span>
                                    </div>
                                    <?php /* <span class="tx-info tx-12"><span class="square-8 bg-info rounded-circle"></span></span>*/ ?>
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <?php if (!empty($onlineVendors) > 0) { ?>
                    <label class="sidebar-label pd-x-25 mg-t-25">Online Vendors</label>
                    <div class="contact-list pd-x-10">
                        <?php foreach ($onlineVendors as $item) { ?>
                            <a href="<?= admin_url('prchat/Prchat_Controller/chat_full_view?contact_id=' . $item['id']) ?>"
                                    class="contact-list-link">
                                <div class="d-flex">
                                    <div class="pos-relative">
                                        <img src="<?= contact_profile_image_url($item['id'], 'small') ?>"/>
                                        <div class="contact-status-indicator bg-success"></div>
                                    </div>
                                    <div class="contact-person">
                                        <p><?= $item['firstname'] ?> <?= $item['lastname'] ?></p>
                                        <!--                            <span>Clemson, CA</span>-->
                                    </div>
                                    <span class="tx-info tx-12"><span
                                                class="square-8 bg-info rounded-circle"></span></span>
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <?php if (!empty($offlineVendors) > 0) { ?>
                    <label class="sidebar-label pd-x-25 mg-t-25">Offline Vendors</label>
                    <div class="contact-list pd-x-10">
                        <?php foreach ($offlineVendors as $item) { ?>
                            <a href="<?= admin_url('prchat/Prchat_Controller/chat_full_view?contact_id=' . $item['id']) ?>"
                                    class="contact-list-link">
                                <div class="d-flex">
                                    <div class="pos-relative">
                                        <img src="<?= contact_profile_image_url($item['id'], 'small') ?>"/>
                                        <div class="contact-status-indicator bg-gray-500"></div>
                                    </div>
                                    <div class="contact-person">
                                        <p><?= $item['firstname'] ?> <?= $item['lastname'] ?></p>
                                        <!--                            <span>Clemson, CA</span>-->
                                    </div>
                                    <span class="tx-info tx-12"><span
                                                class="square-8 bg-info rounded-circle"></span></span>
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
        <?php if ($this->module_model->is_active('goals')) { ?>
            <div class="tab-pane pos-absolute a-0 settings-scrollbar" id="side_objectives" role="tabpanel">
                <label class="sidebar-label pd-x-25 mg-t-25">Obiective</label>
                <div class="pd-x-25">
                    <div class="list-group sidebar-event-list mg-b-20">
                        <?php foreach ($sideOkrs as $item) { ?>
                            <div class="list-group-item">
                                <div>
                                    <h6><?= $item['your_target'] ?></h6>
                                </div>
                                <a href="<?= admin_url("okr/new_object_main/{$item['id']}") ?>" class="more"><i
                                            class="fal fa-ellipsis-v tx-18"></i></a>
                            </div><!-- list-group-item -->
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>


<?php $this->load->view('admin/utilities/calendar_template'); ?>

<script>
    window.addEventListener('load', function () {

        $('.sidebar-datepicker').datepicker({
            dateFormat: 'yy-mm-dd',
            onSelect: function (dateText, inst) {
                //window.location = site_url+'admin/utilities/calendar/?create_event_on=' + dateText;

                $('#start').val(dateText + ' 00:00');
                $("#newEventModal").modal('show');
            }
        });

        if ($('#firstTag').length) {
            document.getElementById('firstTag').classList.add('active');
            $('#btnRightMenu').on('click', function () {
                if ($('body').hasClass('show-right')) {
                    $('body').removeClass('show-right');
                } else {
                    $('body').addClass('show-right');
                }

                return false;
            });
        }

        /*$(document).on('click','.show-right', function(e){
          e.stopPropagation();
            $('body').removeClass('show-right');
            return false;
        });*/

        $(document).on('click touchstart', function (e) {
            e.stopPropagation();

            // closing left sidebar
            if ($('body').hasClass('show-left')) {
                var targ = $(e.target).closest('.br-sideleft').length;
                if (!targ) {
                    //$('body').removeClass('show-left');
                }
            }

            // closing right sidebar
            if ($('body').hasClass('show-right')) {
                var targ = $(e.target).closest('.br-sideright').length;
                if (!targ) {
                    //$('body').removeClass('show-right');
                }
            }
        });
        /*var interval = setInterval(function() {
            var momentNow = moment();
            $('#brDate').html(momentNow.format('MMMM DD, YYYY') + ' '
                + momentNow.format('dddd')
                    .substring(0,3).toUpperCase());
            $('#brTime').html(momentNow.format('hh:mm:ss A'));
        }, 100);*/

    });
</script>

<?php if ($this->cards) { ?>
    <div id="asistmode" class="modal fade">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?php echo _l('assist_mode'); ?></h4>
                </div>
                <div class="modal-body">
                    <?php
                        if (($this->cards)) {
                            echo '<div class="pb-0">';
                            $lang = (($GLOBALS['current_user']->default_language)) ? $GLOBALS['current_user']->default_language : get_option('active_language');
                            foreach ($this->cards as $c) {
                                echo '<div class="alert alert-' . $c['type_alert'] . '">' . $c[$lang] . '</div>';
                            }
                            echo '</div>';
                        }
                    ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo _l('close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php } ?>



