<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script>
var settings = {};
</script>
<script type="text/javascript">
    // Check if there are items left to process
    var itemsLeftToProcess = <?php echo $stats['itemsLeftToProcess']; ?>;

    // Wait for 5 seconds before triggering the page refresh
    setTimeout(function () {
        // Check if there are still items left to process
        if (itemsLeftToProcess > 0) {
            location.reload(true);
        }
    }, 5000);
</script>
<div id="wrapper">
	<div class="breadcrumb">
		<a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
	</div>
    <div class="admin-title">
		<h1><?= $this->config->item('icons')['invoices']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
	<div class="content">
		<div class="row">
            <div class="col-md-12">
                <div class="panel_s mbot10">
                    <div class="panel-body _buttons">
                        <?php if(has_permission('invoices','','create')){ ?>
                            <a href="<?php echo admin_url('invoices/import/upload'); ?>" class="btn btn-info pull-left new new-invoice-list mright5"> <?php echo _l('import'); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</div>
        <div class="flex flex-col flex-auto items-center p-6 sm:p-10 ">
            <div class="z-10 relative flex flex-col items-center w-full">
                <h2 class="text-xl font-semibold"><?php echo _l('processing_status'); ?></h2>
                <div class="max-w-4xl mt-8 sm:text-2xl text-center tracking-tight text-secondary">
                    <?php echo _l('processing_info'); ?>
                </div>
            </div>
        </div>
        <div class="flex flex-col w-full flex-auto items-center p-6  justify-center items-center">
                <div class="max-w-4xl mt-8 sm:text-2xl text-center tracking-tight text-secondary text-red-500">
                    <?php echo $progressInfo ?>
                </div>
            <!-- Import data -->
            <div class="flex flex-col gap-6 w-1/2 sm:mt-4">
                <!-- Overview -->
                <div class="flex flex-col">
                    <div class="flex-auto grid grid-cols-4 gap-4 mt-6">
                        
                        <div class="col-span-2 flex flex-col items-center justify-center py-8 px-1 rounded-2xl bg-indigo-50 text-indigo-800 dark:bg-white dark:bg-opacity-5 dark:text-indigo-400">
                            <div class="text-5xl sm:text-7xl font-semibold leading-none tracking-tight">
                                <?php echo $stats['notfound'] ?>
                            </div>
                            <div class="mt-1 text-sm sm:text-lg font-medium"><?php echo _l('import_total'); ?></div>
                        </div>
                        
                        <div class="col-span-2 flex flex-col items-center justify-center py-8 px-1 rounded-2xl bg-green-50 text-green-800 dark:bg-white dark:bg-opacity-5 dark:text-green-500">
                            <div class="text-5xl sm:text-7xl font-semibold leading-none tracking-tight">
                                <?php echo $stats['processed'] ?>
                            </div>
                            <div class="mt-1 text-sm sm:text-lg font-medium"><?php echo _l('import_total_processed'); ?></div>
                        </div>
                        
                        <div class="col-span-2 sm:col-span-1 flex flex-col items-center justify-center py-8 px-1 rounded-2xl bg-gray-100 text-secondary dark:bg-white dark:bg-opacity-5">
                            <div class="text-5xl font-semibold leading-none tracking-tight">
                                <?php echo $stats['processingNow'] ?>
                            </div>
                            <div class="mt-1 text-sm font-medium text-center"><?php echo _l('processing_now'); ?></div>
                        </div>
                        
                        <div class="col-span-2 sm:col-span-1 flex flex-col items-center justify-center py-8 px-1 rounded-2xl bg-gray-100 text-secondary dark:bg-white dark:bg-opacity-5">
                            <div class="text-5xl font-semibold leading-none tracking-tight">
                                <?php echo $stats['itemsLeftToProcess'] ?>
                            </div>
                            <div class="mt-1 text-sm font-medium text-center"><?php echo _l('processing_left'); ?></div>
                        </div>
                        
                        <div class="col-span-2 sm:col-span-1 flex flex-col items-center justify-center py-8 px-1 rounded-2xl bg-gray-100 text-secondary dark:bg-white dark:bg-opacity-5">
                            <div class="text-5xl font-semibold leading-none tracking-tight">
                                <?php echo $stats['totalBatches'] ?>
                            </div>
                            <div class="mt-1 text-sm font-medium text-center"><?php echo _l('total_cycles'); ?></div>
                        </div>
                        
                        <div class="col-span-2 sm:col-span-1 flex flex-col items-center justify-center py-8 px-1 rounded-2xl bg-gray-100 text-secondary dark:bg-white dark:bg-opacity-5">
                            <div class="text-5xl font-semibold leading-none tracking-tight">
                                <?php echo $stats['batchesLeft'] ?>
                            </div>
                            <div class="mt-1 text-sm font-medium text-center"><?php echo _l('cycles_left'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>