<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>=
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['invoices']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s mbot10">
                    <div class="panel-body _buttons">
                        <?php if (has_permission('invoices', '', 'create')) { ?>
                            <a href="<?php echo admin_url('invoices/import/upload'); ?>" class="btn btn-info pull-left new new-invoice-list mright5"> <?php echo _l('import'); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex flex-col flex-auto items-center p-6 sm:p-10 ">
            <div class="z-10 relative flex flex-col items-center w-full">
                <h2 class="text-xl font-semibold"><?php echo _l('import'); ?></h2>
                <div class="mt-5 text-4xl sm:text-7xl font-extrabold tracking-tight leading-tight text-center">
                    </span><?php echo _l('file_process_error'); ?>
                </div>
                <div class="max-w-4xl mt-8 sm:text-2xl text-center tracking-tight text-secondary">
                    <span class="text-red-400"><?php echo _l('acction_reason'); ?>: </span><?php echo _l($errorMessage); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>