<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script>
    var settings = {};
</script>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['invoices']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s mbot10">
                    <div class="panel-body _buttons">
                        <?php if (has_permission('invoices', '', 'create')) { ?>
                            <a href="<?php echo admin_url('invoices/import/upload'); ?>" class="btn btn-info pull-left new new-invoice-list mright5"> <?php echo _l('import'); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="flex flex-col flex-auto items-center p-6 sm:p-10 ">
            <div class="z-10 relative flex flex-col items-center w-full">
                <h2 class="text-xl font-semibold"><?php echo _l('import'); ?></h2>
                <div class="mt-5 text-4xl sm:text-7xl font-extrabold tracking-tight leading-tight text-center">
                    <?php echo _l('file_processed_successfully'); ?>
                </div>
                <div class="max-w-4xl mt-8 sm:text-2xl text-center tracking-tight text-secondary">
                    <?php echo _l('import_invoices_processed_data'); ?>
                </div>
                <div class="max-w-4xl mt-8 sm:text-2xl text-center tracking-tight text-primary">
                    <?php echo _l('import_invoices_processed_invocie_status_paid_info'); ?>
                </div>
            </div>
        </div>
        <div class="flex flex-col flex-auto items-center p-6 sm:p-10 ">
            <!-- Import data -->
            <div class="relative flex flex-col  p-6 pr-3 pb-3 bg-white rounded-2xl shadow overflow-hidden w-1/2">
                <div class="flex items-center">
                    <div class="flex flex-col items-center justify-items-center">
                        <div class="flex flex-row w-full">
                            <div class="text-lg font-normal tracking-tight leading-6 truncate">
                                <?php echo _l('import_type'); ?>
                            </div>
                            <div class="text-lg font-medium tracking-tight leading-6 truncate uppercase text-green-600 ml-2"><?php echo $importData['fileDataType'] ?></div>
                        </div>
                        
                        <div class="font-normal text-md mt-5" title="<?php echo $importData['fileName'] ?>">
                            <span class="truncate"><?php echo _l('file'); ?>: <?php
                                $maxLength = 30;
                                if (strlen($importData['fileName']) > $maxLength) {
                                    // Truncate the text and add an ellipsis
                                    $truncatedText = substr($importData['fileName'], 0, $maxLength) . '...';
                                } else {
                                    // Text doesn't need truncation
                                    $truncatedText = $importData['fileName'];
                                }
                                echo $truncatedText;
                                ?></span>
                        </div>
                    </div>
                    <div class="ml-auto mr-20">
                        <?php if ($importData['stats']['noFound'] > 0): ?>
                            <a href="<?= admin_url('invoices/batchprocess/' . $importId) ?>" class="flex rounded-md bg-cyan-600 p-3 justify-center text-center font-sans text-xs font-bold uppercase text-white transition-all hover:bg-cyan-700 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none">
                            <span class="text-2xl font-bold">
                                Import
                            </span>
                            </a>
                        <?php else: ?>
                            <a href="#"
                                    class="flex rounded-md bg-gray-300 p-3 justify-center text-center font-sans text-xs font-bold uppercase text-white transition-all" data-ripple-light="true"
                            >
                                <span class="text-2xl font-bold">
                                    <?php echo _l('nothing_to_import'); ?>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="grid grid-cols-4 my-5">
                    <div class="flex flex-col mx-6 my-3 items-center">
                        <div class="text-md leading-none text-secondary"><?php echo _l('date'); ?></div>
                        <div class="mt-4 font-medium text-3xl leading-none"><?php echo $importData['date'] ?></div>
                    </div>
                    <div class="flex flex-col mx-6 my-3 items-center">
                        <div class="text-md leading-none text-secondary text-green-600"><?php echo _l('found_in_file'); ?></div>
                        <div class="mt-4 font-medium text-3xl leading-none text-green-600"><?php echo $importData['stats']['items'] ?></div>
                    </div>
                    <div class="flex flex-col mx-6 my-3 items-center">
                        <div class="text-md leading-none text-secondary text-red-600"><?php echo _l('found_in_system'); ?></div>
                        <div class="mt-4 font-medium text-3xl leading-none text-red-600"><?php echo $importData['stats']['found'] ?></div>
                    </div>
                    <div class="flex flex-col mx-6 my-3 items-center">
                        <div class="text-md leading-none text-secondary text-cyan-600"><?php echo _l('ready_to_import'); ?></div>
                        <div class="mt-4 font-medium text-3xl leading-none text-cyan-600"><?php echo $importData['stats']['noFound'] ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>