<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!-- Main -->
<div class="flex flex-col flex-auto items-center p-6 sm:p-10 ">

    <!-- Title -->
    <div class="z-10 relative flex flex-col items-center w-full">
        <h2 class="text-xl font-semibold"><?php echo _l('import'); ?></h2>
        <div class="mt-5 text-4xl sm:text-7xl font-extrabold tracking-tight leading-tight text-center">
            <?php echo _l('upload_files_to_start_importing'); ?>
        </div>
        <div class="max-w-4xl mt-8 sm:text-2xl text-center tracking-tight text-secondary">
            <?php echo _l('import_invoices_accepted_files_type'); ?>
        </div>

        <!-- Show when we have imports -->
        <?php if (!empty($imports)): ?>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mt-8 md:mt-16 items-center justify-center mt-10">
                <div class="flex flex-col items-center justify-center w-56 h-56 rounded-lg cursor-pointer border-2 border-gray-300 border-dashed hover:bg-hover transition-colors duration-150 ease-in-out">
                    <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i>
                </div>
            </div>
        <?php else: ?>
            <!-- Show when we dont have any imports -->
            <div class="flex flex-col items-center justify-center mt-5">
                <div class="grid grid-cols-2 gap-10">
                    <div class="flex flex-col justify-center items-center">
                        <div class="flex flex-col justify-center p-2.5 px-5 rounded-md text-md font-semibold text-blue-800 bg-blue-100 dark:text-blue-50 dark:bg-blue-500">
                            <div>
                                <?php echo _l('step_one'); ?> <?php echo _l('import_clients'); ?>
                            </div>
                        </div>
                        <div class="text-center my-2">
                            <?php echo _l('step_one_description'); ?>
                        </div>
                        <div>
                            <form class="" id="uploadFormClient" action="<?= admin_url('invoices/uploadImport') ?>" method="post" enctype="multipart/form-data" onbeforeunload="window.onbeforeunload = null;">
                                <label for="fileInputClient" class="flex flex-col items-center justify-center w-56 h-56 rounded-lg cursor-pointer border-2 border-gray-300 border-dashed hover:bg-cyan-600 hover:bg-opacity-5 transition-colors duration-150 ease-in-out">
                                    <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i>
                                    <span class="mt-2 text-sm text-gray-600"><?php echo _l('click_to_upload'); ?></span>
                                </label>
                                <input id="fileInputClient" type="file" name="userfile" accept=".xml, .xls, .xlsx" style="display: none;">
                                <input type="hidden" name="selectedProviderId" value="<?= $selectedProviderId ?>">
                            </form>
                        </div>
                    </div>
                    <div class="flex flex-col justify-center items-center">
                        <div class="flex flex-col justify-center p-2.5 px-5 rounded-md text-md font-semibold text-blue-800 bg-blue-100 dark:text-blue-50 dark:bg-blue-500">
                            <div>
                                <?php echo _l('step_two'); ?> <?php echo _l('import_invoices'); ?>
                            </div>
                        </div>
                        <div class="text-center my-2">
                            <?php echo _l('step_two_description'); ?>
                        </div>
                        <div>
                            <form class="" id="uploadFormInvoice" action="<?= admin_url('invoices/uploadImport') ?>" method="post" enctype="multipart/form-data" onbeforeunload="window.onbeforeunload = null;">
                                <label for="fileInputInvoice" class="flex flex-col items-center justify-center w-56 h-56 rounded-lg cursor-pointer border-2 border-gray-300 border-dashed hover:bg-cyan-600 hover:bg-opacity-5 transition-colors duration-150 ease-in-out">
                                    <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i>
                                    <span class="mt-2 text-sm text-gray-600"><?php echo _l('click_to_upload'); ?></span>
                                </label>
                                <input id="fileInputInvoice" type="file" name="userfile" accept=".xml, .xls, .xlsx" style="display: none;">
                                <input type="hidden" name="selectedProviderId" value="<?= $selectedProviderId ?>">
                            </form>
                        </div>
                    </div>
                </div>


                <div id="selectedFileName"></div>

                <script>
                    // Function to handle file selection
                    document.getElementById('fileInputClient').addEventListener('change', function() {
                        var form = document.getElementById('uploadFormClient');
                        var selectedFileName = document.getElementById('selectedFileName');

                        if (this.files.length > 0) {
                            var fileName = this.files[0].name;
                            selectedFileName.textContent = '<?php echo _l('selected_file'); ?> ' + fileName;

                            // Submit the form when a file is selected
                            form.submit();
                        }
                    });
                </script>

                <script>
                    // Function to handle file selection
                    document.getElementById('fileInputInvoice').addEventListener('change', function() {
                        var form = document.getElementById('uploadFormInvoice');
                        var selectedFileName = document.getElementById('selectedFileName');

                        if (this.files.length > 0) {
                            var fileName = this.files[0].name;
                            selectedFileName.textContent = '<?php echo _l('selected_file'); ?> ' + fileName;

                            // Submit the form when a file is selected
                            form.submit();
                        }
                    });
                </script>
            </div>
        <?php endif; ?>
    </div>
<div>

