<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<!-- Providers -->
<div class="flex flex-col flex-auto w-full mx-auto border-t-4 border-color-red" >
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-20 mt-8 sm:mt-10">
        <!-- Iterate over providers -->
        <?php foreach ($providers as $provider): ?>
            <div class="flex flex-col shadow rounded-2xl overflow-hidden bg-white">
                <div class="flex flex-col px-16 py-8">
                    <div class="flex items-center justify-between">
                        <div class="p-2.5 px-5 rounded-full text-md font-semibold text-blue-800 bg-blue-100 dark:text-blue-50 dark:bg-blue-500">
                            <?= $provider['type']; ?>
                        </div>
                    </div>
                    <div class="mt-4 text-5xl font-bold"><?= $provider['name']; ?></div>
                    <div class="mt-2.5 line-clamp-2 text-secondary text-md font-normal"><?= $provider['name']; ?> <?php echo _l('import_info'); ?></div>
                    <div class="w-12 h-1 my-2 border-t-2"></div>
                    <div class="flex flex-col">
                        <!-- Iterate over services -->
                        <?php foreach ($provider['services'] as $service): ?>
                            <div class="flex py-2 items-center leading-5 text-md text-secondary">
                                <i class="fa-solid fa-circle-check text-green-500"></i>
                                <div class="ml-1.5 capitalize"><?php echo _l($service); ?></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <!-- Footer -->
                <div class="flex flex-col w-full mt-auto">
                    <a href="<?= admin_url('invoices/import/provider/' . $provider['id']); ?>"
                        class="middle none center rounded-b-lg bg-cyan-600 py-6 px-3 justify-center text-center font-sans text-xs font-bold uppercase text-white shadow-md shadow-pink-500/20 transition-all hover:bg-cyan-700 hover:shadow-lg hover:shadow-cyan-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none disabled:pointer-events-none disabled:opacity-50 disabled:shadow-none"
                        data-ripple-light="true"
                        >
                        <span class="text-2xl font-bold">
                            <?php echo _l('upload_files_to_start_importing') . ' ' . $provider['name']; ?>
                        </span>
                    </a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>