<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script>
    let invoiceID = '<?php if (isset($invoice->id)) {
        echo $invoice->id;
    } else {
        echo null;
    }; ?>';
</script>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url("invoices"); ?>"><?php echo _l('invoices'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['invoices']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <?php
            echo form_open($this->uri->uri_string(), array('id' => 'invoice-form', 'class' => '_transaction_form invoice-form'));
            if (isset($invoice)) {
                echo form_hidden('isedit');
            }
            ?>
            <div class="col-md-12">
                <?php $this->load->view('admin/invoices/invoice_template2'); ?>
            </div>
            <?php echo form_close(); ?>
            <?php $this->load->view('admin/invoice_items/item'); ?>
        </div>
    </div>

</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    $(function () {
        validate_invoice_form();
        // Init accountacy currency symbol
        init_currency();
        // Project ajax search
        init_ajax_project_search_by_customer_id();
        // Maybe items ajax search
        init_ajax_search('items', '#item_select.ajax-search', undefined, admin_url + 'items/search');

        //init_ajax_search2('clientid2','#clientid2',undefined,admin_url+'items/search');
        //ac('clientid3',admin_url+'misc/autocomplete/companies');
        ac_render('clientid3', admin_url + 'misc/autocomplete/companies_records');

    });

    function get_country_states(el, state_id_selected = false) {
        $.post(admin_url + 'misc/get_country_states/' + $(el).val()).done(function (response) {
            response = JSON.parse(response);
            if (response.success == true) {
                $('select[name="state"]').html(response.html);
                if (state_id_selected) {
                    $('select[name=state]').val(state_id_selected);
                }
                $('select[name="state"]').selectpicker('refresh');

            }
        });
    }

    function get_bcountry_states(el, state_id_selected = false) {
        $.post(admin_url + 'misc/get_country_states/' + $(el).val()).done(function (response) {
            response = JSON.parse(response);
            if (response.success == true) {
                $('select[name="billing_state"]').html(response.html);
                if (state_id_selected) {
                    $('select[name=billing_state]').val(state_id_selected);
                }
                $('select[name="billing_state"]').selectpicker('refresh');

            }
        });
    }

    function get_scountry_states(el, state_id_selected = false) {
        $.post(admin_url + 'misc/get_country_states/' + $(el).val()).done(function (response) {
            response = JSON.parse(response);
            if (response.success == true) {
                $('select[name="shipping_state"]').html(response.html);
                if (state_id_selected) {
                    $('select[name=shipping_state]').val(state_id_selected);
                }
                $('select[name="shipping_state"]').selectpicker('refresh');

            }
        });
    }

    $(document).ready(function () {
        var billing_country = $('#billing_country');
        var state_id_selected = $('#billing_state').val();
        get_bcountry_states(billing_country, state_id_selected);

        var shipping_country = $('#shipping_country');
        var state_id_selected = $('#shipping_state').val();
        get_scountry_states(shipping_country, state_id_selected);

        var country = $('#country');
        var state_id_selected = $('#state').val();
        get_country_states(country, state_id_selected);
    });


</script>

<div id="modals"></div>

<div class="modal fade" tabindex="-1" id="modal-add-client">
    <form id="add-client">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">Adauga Client</h4>
                </div>
                <div class="modal-body">
                    <div class="response alert-warning alert-warning-issue hidden">
                        <div class="alert-warning-issue-inner"></div>
                    </div>
                    <div class="response"></div>
                    <input type="hidden" id="userid" name="userid" autofocus="autofocus" value=""/>

                    <div class="row">
                        <div class="col-sm-4 col-md-4 col-lg-4">
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.tax_number'); ?></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="vat" id="vat" value=""/>
                                    <a href="javascript:;" onclick="get_anaf_company();" class="input-group-addon info-cif"><span class="glyphicon glyphicon-cloud-download"></span></a>
                                </div>
                            </div>
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.client_name'); ?>
                                    <span class="orange">*</span></label>
                                <input type="text" class="form-control" name="company" id="company" value=""/>
                            </div>
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.trade_number'); ?> </label>
                                <input type="text" class="form-control" name="trade_number" id="trade_number" value=""/>
                            </div>
                            <?php /*<div class="form-group">
							<label>Cod client</label>
							<input type="text" class="form-control" name="cod_client" id="cod_client" value="" />
						</div>*/ ?>
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.company_email'); ?></label>
                                <input type="text" class="form-control" name="organization_email" id="organization_email" value=""/>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4 col-lg-4">
                            <?php $countries = get_all_countries(); ?>
                            <?php $selected_country = (isset($client) ? $client->billing_country : ''); ?>
                            <?php echo render_select('country', $countries, array('country_id', array('short_name'), 'short_name'), 'billing_country', $selected_country, array('data-none-selected-text' => _l('dropdown_non_selected_tex'), 'onchange' => 'get_country_states(this);'));
                            ?>

                            <?php
                            $states = get_all_states($selected_country);
                            $selected = (isset($client) ? $client->state : 0);
                            echo render_select('state', $states, array('state_id', array('short_name'), 'short_name'), 'state', $selected, array('data-none-selected-text' => _l('dropdown_non_selected_tex')));
                            ?>
                            <?php $value = (isset($client) ? $client->city : ''); ?>
                            <?php echo render_input('city', 'city', $value); ?>
                            <?php $value = (isset($client) ? $client->street : ''); ?>
                            <?php echo render_textarea('address', 'address', $value); ?>


                            <?php /*
						<div class="form-group">
							<label>Adresa <span class="orange">*</span></label>
							<input type="text" class="form-control" name="address" id="address" value="" autocomplete="off" />
						</div>
						<div class="form-group">
							<label>Judet <span class="orange">*</span></label>
							<input type="text" class="form-control" name="state" id="state" value="" />
						</div>
						<div class="form-group">
							<label>Localitate <span class="orange">*</span></label>
							<input type="text" class="form-control" name="city" id="city" value="" />
						</div>
						<div class="form-group">
							<label>Tara <span class="orange">*</span></label>
							<input type="text" class="form-control" name="country" id="country" value="" />
						</div>*/ ?>


                            <div class="form-group">
                                <label style="margin-right: 15px;"><?= _l('invoice.add_client.tax_payer'); ?></label>
                                <input type="radio" name="is_vat" id="is_vat_yes" value="1"/>
                                <label for="is_vat_yes"><?= strtoupper(_l('yes')); ?></label>
                                <input type="radio" name="is_vat" id="is_vat_no" value="0" checked="checked" style="margin-left: 20px;"/>
                                <label for="is_vat_no"><?= strtoupper(_l('no')); ?></label>
                            </div>
                        </div>
                        <div class="col-sm-4 col-md-4 col-lg-4">
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.iban'); ?></label>
                                <input type="text" class="form-control" name="iban" id="iban" value=""/>
                            </div>
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.bank'); ?></label>
                                <input type="text" class="form-control" name="bank" id="bank" value=""/>
                            </div>

                            <?php /*<div class="form-group">
							<label>Persoana contact</label>
							<input type="text" class="form-control" name="persoana_contact" id="persoana_contact" value="" />
						</div>*/ ?>
                            <div class="form-group">
                                <label><?= _l('invoice.add_client.phone'); ?></label>
                                <input type="text" class="form-control" name="phonenumber" id="phonenumber" value=""/>
                            </div>

                            <?php $value = (isset($client) ? $client->zip : ''); ?>
                            <?php echo render_input('zip', 'zip', $value); ?>
                        </div>
                    </div>
                    <div class="text-right">
                        <button type="button" class="btn btn-primary add-cs-mb" data-type="submit" onclick="save_client();"><?= _l('invoice.add_client.btn_save'); ?></button>
                    </div>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </form>
</div><!-- /.modal -->


</body>
</html>
