<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="kb_category_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('knowledge_base/category'), array('id' => 'kb_category_form','enctype'=>"multipart/form-data")); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('edit_kb_category'); ?></span>
                    <span class="add-title"><?php echo _l('new_category'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?php echo render_input('category_name', 'kb_category_add_edit_name'); ?>
                        <div id="kb_category_slug" class="hide">
                            <?php echo render_input('category_slug', 'kb_article_slug'); ?>
                        </div>
                        <?php $fonts = [['value'=>'','name'=>''],['value'=>'font1','name'=>'font1'],['value'=>'font2','name'=>'font2'],['value'=>'font3','name'=>'font3'],['value'=>'font4','name'=>'font4']];
                        echo render_select('font', $fonts, array('value', 'name'), 'kb_category_add_edit_font', '', array('data-actions-box' => true), array(), '', '', false); ?>
                        <?php echo render_color_picker('color', _l('kb_category_color')); ?>
                        <?php echo render_input('image', 'Selecteaza imaginea', false, 'file');?>
                        <?php echo render_textarea('description', 'kb_category_add_edit_description'); ?>
                        <?php echo render_input('category_order', 'kb_category_order', total_rows('tblknowledgebasecategorys') + 1, 'number'); ?>
                        <div class="kb-category-disable-option">
                            <div class="checkbox checkbox-primary">
                                <input type="checkbox" name="disabled" id="disabled">
                                <label for="disabled"><?php echo _l('kb_category_add_edit_disabled'); ?></label>
                            </div>
                            <!--                            <p class="text-muted">-->
                            <?php //echo _l('kb_category_add_edit_note'); ?><!--</p>-->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div>
    <!-- /.modal-dialog -->
</div>
<script>
//    document.getElementById('kb_category_form').addEventListener('submit', function (e) {
//        var formData = new FormData(this);
//        formData.append('checker',1);
//        e.preventDefault();
//        $.ajax({
//            url: '<?php //echo admin_url('knowledge_base/category')?>//',
//            type: "post",
//            data: formData,
//            processData: false,
//            contentType: false,
//            cache: false,
//            async: false,
//        });
//        return false;
//    });
    window.addEventListener('load', function () {

        // Validating the knowledge category form
        _validate_form($('#kb_category_form'), {
            name: 'required'
        }, manage_kb_categorys);

        // On hidden modal reset the values
        $('#kb_category_modal').on("hidden.bs.modal", function (event) {
            $('#kb_category_slug').addClass('hide');
            $('#kb_category_slug input').rules('remove', 'required');
            $('#additional').html('');
            $('#kb_category_modal input').not('[type="hidden"]').val('');
            $('#kb_category_modal textarea').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
            $('#kb_category_modal input[name="category_order"]').val($('table tbody tr').length + 1);
        });
    });
    // Form handler function for knowledgebase category
    function manage_kb_categorys(form) {
        var url = form.action;
        var formData = new FormData(document.getElementById('kb_category_form'));
        $.ajax({
            url: url,
            type: "post",
            data: formData,
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success:function () {
                console.log('<?=site_url('admin/knowledge_base/manage_categorys')?>');
                window.location.href = '<?=site_url('admin/knowledge_base/manage_categorys')?>';
            }
        });
        return false;
    }

    // New knowledgebase category, opens modal
    function new_kb_category() {
        $('#kb_category_modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    // Edit KB category, 2 places categorys view or articles view directly click on kanban
    function edit_kb_category(invoker, id) {
        $('#additional').append(hidden_input('id', id));
        $('#kb_category_slug').removeClass('hide');
        $('#kb_category_slug input').rules('add', {required: true});
        $('#kb_category_slug input').val($(invoker).data('slug'));
        $('#kb_category_modal input[name="category_name"]').val($(invoker).data('category_name'));
        $('#kb_category_modal textarea[name="description"]').val($(invoker).data('description'));
        $('#kb_category_modal .colorpicker-input').colorpicker('setValue', $(invoker).data('color'));
        $('#kb_category_modal input[name="category_order"]').val($(invoker).data('order'));
        $('#kb_category_modal select[name="font"]').val($(invoker).data('font'));
        $('#kb_category_modal select[name="font"]').selectpicker('refresh');
        $('input[name="disabled"]').prop('checked', ($(invoker).data('active') == 0 ? true : false));
        $('#kb_category_modal').modal('show');
        $('.add-title').addClass('hide');
    }

</script>
