<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="kb_product_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('knowledge_base/product'), array('id' => 'kb_product_form','enctype'=>"multipart/form-data")); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('edit_kb_product'); ?></span>
                    <span class="add-title"><?php echo _l('new_product'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?php echo render_input('product_name', 'kb_product_add_edit_name'); ?>
                        <div id="kb_product_slug" class="hide">
                            <?php echo render_input('product_slug', 'kb_article_slug'); ?>
                        </div>
                        <?php $fonts = [['value'=>'','name'=>''],['value'=>'font1','name'=>'font1'],['value'=>'font2','name'=>'font2'],['value'=>'font3','name'=>'font3'],['value'=>'font4','name'=>'font4']];
                        echo render_select('font', $fonts, array('value', 'name'), 'kb_product_add_edit_font', '', array('data-actions-box' => true), array(), '', '', false); ?>
                        <?php echo render_color_picker('color', _l('kb_product_color')); ?>
                        <?php echo render_input('image', 'Selecteaza imaginea', false, 'file');?>
                        <?php echo render_textarea('description', 'kb_product_add_edit_description'); ?>
                        <?php echo render_input('product_order', 'kb_product_order', total_rows('tblknowledgebaseproducts') + 1, 'number'); ?>
                        <div class="kb-product-disable-option">
                            <div class="checkbox checkbox-primary">
                                <input type="checkbox" name="disabled" id="disabled">
                                <label for="disabled"><?php echo _l('kb_product_add_edit_disabled'); ?></label>
                            </div>
                            <!--                            <p class="text-muted">-->
                            <?php //echo _l('kb_product_add_edit_note'); ?><!--</p>-->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div>
    <!-- /.modal-dialog -->
</div>
<script>
//    document.getElementById('kb_product_form').addEventListener('submit', function (e) {
//        var formData = new FormData(this);
//        formData.append('checker',1);
//        e.preventDefault();
//        $.ajax({
//            url: '<?php //echo admin_url('knowledge_base/product')?>//',
//            type: "post",
//            data: formData,
//            processData: false,
//            contentType: false,
//            cache: false,
//            async: false,
//        });
//        return false;
//    });
    window.addEventListener('load', function () {

        // Validating the knowledge product form
        _validate_form($('#kb_product_form'), {
            name: 'required'
        }, manage_kb_products);

        // On hidden modal reset the values
        $('#kb_product_modal').on("hidden.bs.modal", function (event) {
            $('#kb_product_slug').addClass('hide');
            $('#kb_product_slug input').rules('remove', 'required');
            $('#additional').html('');
            $('#kb_product_modal input').not('[type="hidden"]').val('');
            $('#kb_product_modal textarea').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
            $('#kb_product_modal input[name="product_order"]').val($('table tbody tr').length + 1);
        });
    });
    // Form handler function for knowledgebase product
    function manage_kb_products(form) {
        var url = form.action;
        var formData = new FormData(document.getElementById('kb_product_form'));
        $.ajax({
            url: url,
            type: "post",
            data: formData,
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success:function () {
                console.log('<?=site_url('admin/knowledge_base/manage_products')?>');
                window.location.href = '<?=site_url('admin/knowledge_base/manage_products')?>';
            }
        });
        return false;
    }

    // New knowledgebase product, opens modal
    function new_kb_product() {
        $('#kb_product_modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    // Edit KB product, 2 places products view or articles view directly click on kanban
    function edit_kb_product(invoker, id) {
        $('#additional').append(hidden_input('id', id));
        $('#kb_product_slug').removeClass('hide');
        $('#kb_product_slug input').rules('add', {required: true});
        $('#kb_product_slug input').val($(invoker).data('slug'));
        $('#kb_product_modal input[name="product_name"]').val($(invoker).data('product_name'));
        $('#kb_product_modal textarea[name="description"]').val($(invoker).data('description'));
        $('#kb_product_modal .colorpicker-input').colorpicker('setValue', $(invoker).data('color'));
        $('#kb_product_modal input[name="product_order"]').val($(invoker).data('order'));
        $('#kb_product_modal select[name="font"]').val($(invoker).data('font'));
        $('#kb_product_modal select[name="font"]').selectpicker('refresh');
        $('input[name="disabled"]').prop('checked', ($(invoker).data('active') == 0 ? true : false));
        $('#kb_product_modal').modal('show');
        $('.add-title').addClass('hide');
    }

</script>
