<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="kb_service_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('knowledge_base/service'), array('id' => 'kb_service_form','enctype'=>"multipart/form-data")); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('edit_kb_service'); ?></span>
                    <span class="add-title"><?php echo _l('new_service'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <?php echo render_input('service_name', 'kb_service_add_edit_name'); ?>
                        <div id="kb_service_slug" class="hide">
                            <?php echo render_input('service_slug', 'kb_article_slug'); ?>
                        </div>
                        <?php $fonts = [['value'=>'','name'=>''],['value'=>'font1','name'=>'font1'],['value'=>'font2','name'=>'font2'],['value'=>'font3','name'=>'font3'],['value'=>'font4','name'=>'font4']];
                        echo render_select('font', $fonts, array('value', 'name'), 'kb_service_add_edit_font', '', array('data-actions-box' => true), array(), '', '', false); ?>
                        <?php echo render_color_picker('color', _l('kb_service_color')); ?>
                        <?php echo render_input('image', 'Selecteaza imaginea', false, 'file');?>
                        <?php echo render_textarea('description', 'kb_service_add_edit_description'); ?>
                        <?php echo render_input('service_order', 'kb_service_order', total_rows('tblknowledgebaseservices') + 1, 'number'); ?>
                        <div class="kb-service-disable-option">
                            <div class="checkbox checkbox-primary">
                                <input type="checkbox" name="disabled" id="disabled">
                                <label for="disabled"><?php echo _l('kb_service_add_edit_disabled'); ?></label>
                            </div>
                            <!--                            <p class="text-muted">-->
                            <?php //echo _l('kb_service_add_edit_note'); ?><!--</p>-->
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
            </div>
        </div>
        <!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div>
    <!-- /.modal-dialog -->
</div>
<script>
//    document.getElementById('kb_service_form').addEventListener('submit', function (e) {
//        var formData = new FormData(this);
//        formData.append('checker',1);
//        e.preventDefault();
//        $.ajax({
//            url: '<?php //echo admin_url('knowledge_base/service')?>//',
//            type: "post",
//            data: formData,
//            processData: false,
//            contentType: false,
//            cache: false,
//            async: false,
//        });
//        return false;
//    });
    window.addEventListener('load', function () {

        // Validating the knowledge service form
        _validate_form($('#kb_service_form'), {
            name: 'required'
        }, manage_kb_services);

        // On hidden modal reset the values
        $('#kb_service_modal').on("hidden.bs.modal", function (event) {
            $('#kb_service_slug').addClass('hide');
            $('#kb_service_slug input').rules('remove', 'required');
            $('#additional').html('');
            $('#kb_service_modal input').not('[type="hidden"]').val('');
            $('#kb_service_modal textarea').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
            $('#kb_service_modal input[name="service_order"]').val($('table tbody tr').length + 1);
        });
    });
    // Form handler function for knowledgebase service
    function manage_kb_services(form) {
        var url = form.action;
        var formData = new FormData(document.getElementById('kb_service_form'));
        $.ajax({
            url: url,
            type: "post",
            data: formData,
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            success:function () {
                console.log('<?=site_url('admin/knowledge_base/manage_services')?>');
                window.location.href = '<?=site_url('admin/knowledge_base/manage_services')?>';
            }
        });
        return false;
    }

    // New knowledgebase service, opens modal
    function new_kb_service() {
        $('#kb_service_modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    // Edit KB service, 2 places services view or articles view directly click on kanban
    function edit_kb_service(invoker, id) {
        $('#additional').append(hidden_input('id', id));
        $('#kb_service_slug').removeClass('hide');
        $('#kb_service_slug input').rules('add', {required: true});
        $('#kb_service_slug input').val($(invoker).data('slug'));
        $('#kb_service_modal input[name="service_name"]').val($(invoker).data('service_name'));
        $('#kb_service_modal textarea[name="description"]').val($(invoker).data('description'));
        $('#kb_service_modal .colorpicker-input').colorpicker('setValue', $(invoker).data('color'));
        $('#kb_service_modal input[name="service_order"]').val($(invoker).data('order'));
        $('#kb_service_modal select[name="font"]').val($(invoker).data('font'));
        $('#kb_service_modal select[name="font"]').selectpicker('refresh');
        $('input[name="disabled"]').prop('checked', ($(invoker).data('active') == 0 ? true : false));
        $('#kb_service_modal').modal('show');
        $('.add-title').addClass('hide');
    }

</script>
