<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="assigment" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?php echo form_open(admin_url('leads/assigment'), array('id'=>'leads-assigment-form')); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">
               <span class="edit-title"><?php echo _l('edit_assigment'); ?></span>
               <span class="add-title"><?php echo _l('lead_new_assigment'); ?></span>
            </h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div id="additional"></div>
                  <?php echo render_input('name', 'leads_assigment_add_edit_name'); ?>
                  <?php echo render_input('tag', 'leads_assigment_add_edit_tag'); ?>
                  <?php echo render_input('period', 'leads_assigment_add_edit_period'); ?>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
         </div>
      </div>
      <!-- /.modal-content -->
      <?php echo form_close(); ?>
   </div>
   <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<script>
  window.addEventListener('load', function () {
    appValidateForm($("body").find('#leads-assigment-form'), {
        name: 'required'
    }, manage_leads_assigments);
    $('#assigment').on("hidden.bs.modal", function (event) {
        $('#additional').html('');
        $('#assigment input[name="name"]').val('');
        $('#assigment input[name="tag"]').val('');
        $('#assigment input[name="period"]').val('');
        $('.add-title').removeClass('hide');
        $('.edit-title').removeClass('hide');
    });
});

// Create lead new assigment
function new_assigment() {
    $('#assigment').modal('show');
    $('.edit-title').addClass('hide');
}

// Edit assigment function which init the data to the modal
function edit_assigment(invoker, id) {
    $('#additional').append(hidden_input('id', id));
    $('#assigment input[name="name"]').val($(invoker).data('name'));
    $('#assigment input[name="tag"]').val($(invoker).data('tag'));
    $('#assigment input[name="period"]').val($(invoker).data('period'));
    $('#assigment').modal('show');
    $('.add-title').addClass('hide');
}

// Form handler function for leads assigment
function manage_leads_assigments(form) {
    var data = $(form).serialize();
    var url = form.action;
    $.post(url, data).done(function (response) {
        window.location.reload();
    });
    return false;
}
</script>
