<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo current_url(); ?>"><?php echo _l('menu_sales'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['manage-leads']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="_buttons">
                            <a href="#" onclick="init_lead(); return false;" class="btn mright5 btn-info pull-left display-block">
                                <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE: echo _l('new_lead'); ?>
                            </a>

                            <?php if (is_admin() || get_option('allow_non_admin_members_to_import_leads') == '1') { ?>
                                <a href="<?php echo admin_url('leads/import'); ?>" class="btn btn-info pull-left display-block hidden-xs">
                                    <?php echo _l('import_leads'); ?>
                                </a>
                            <?php } ?>
                            <div class="row">
                                <div class="col-md-5">
                                    <a href="#" class="btn btn-default btn-with-tooltip" data-toggle="tooltip" data-title="<?php echo _l('leads_summary'); ?>" data-placement="bottom" onclick="slideToggle('.leads-overview'); return false;"><i class="fal fa-bar-chart"></i></a>
                                    <a href="<?php echo admin_url('leads/switch_kanban/' . $switch_kanban); ?>" class="btn btn-default mleft10 hidden-xs">
                                        <?php if ($switch_kanban == 1) {
                                            echo _l('leads_switch_to_kanban');
                                        } else {
                                            echo _l('switch_to_list_view');
                                        }; ?>
                                    </a>
                                </div>
                                <div class="col-md-4 col-xs-12 pull-right leads-search">
                                    <?php if ($this->session->userdata('leads_kanban_view') == 'true') { ?>
                                        <div data-toggle="tooltip" data-placement="bottom" data-title="<?php echo _l('search_by_tags'); ?>">
                                            <?php echo render_input('search', '', '', 'search', array('data-name' => 'search', 'onkeyup' => 'leads_kanban();', 'placeholder' => _l('leads_search')), array(), 'no-margin') ?>
                                        </div>
                                    <?php } ?>
                                    <?php echo form_hidden('sort_type'); ?>
                                    <?php echo form_hidden('sort', (get_option('default_leads_kanban_sort') != '' ? get_option('default_leads_kanban_sort_type') : '')); ?>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row hide leads-overview">
                                <div class="col-md-12">
                                    <h4 class="no-margin"><?php echo _l('leads_summary'); ?></h4>
                                </div>
                                <?php
                                foreach ($summary as $k => $status) { ?>
                                    <div class="col-md-2 col-xs-6 border-right">
                                        <h3 class="bold">
                                            <?php
                                            if (isset($status['percent'])) {
                                                echo '<span data-toggle="tooltip" data-title="' . $status['total'] . '">' . $status['percent'] . '%</span>';
                                            } else {
                                                // Is regular status
                                                echo $status['total'];
                                            }
                                            ?>
                                        </h3>
                                        <span style="color:<?php echo $status['color']; ?>" class="<?php echo isset($status['junk']) || isset($status['lost']) ? 'text-danger' : ''; ?>"><?php echo _l($status['name']); ?></span>
                                    </div>
                                    <?php
                                    if (($k + 1) % 6 == 0 && $k != 0) {
                                        echo '<div class="col-md-12"><div class="clearfix"></div></div>';
                                    }
                                    ?>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="tab-content">
                            <?php
                            if ($this->session->has_userdata('leads_kanban_view') && $this->session->userdata('leads_kanban_view') == 'true') { ?>
                                <div class="active kan-ban-tab" id="kan-ban-tab" style="overflow:auto;">
                                    <div class="kanban-leads-sort">
                                        <span class="bold"><?php echo _l('leads_sort_by'); ?>: </span>
                                        <a href="#" onclick="leads_kanban_sort('dateadded'); return false" class="dateadded">
                                            <?php if (get_option('default_leads_kanban_sort') == 'dateadded') {
                                                echo '<i class="kanban-sort-icon fal fa-sort-amount-' . strtolower(get_option('default_leads_kanban_sort_type')) . '"></i> ';
                                            } ?><?php echo _l('leads_sort_by_datecreated'); ?>
                                        </a>
                                        |
                                        <a href="#" onclick="leads_kanban_sort('leadorder');return false;" class="leadorder">
                                            <?php if (get_option('default_leads_kanban_sort') == 'leadorder') {
                                                echo '<i class="kanban-sort-icon fal fa-sort-amount-' . strtolower(get_option('default_leads_kanban_sort_type')) . '"></i> ';
                                            } ?><?php echo _l('leads_sort_by_kanban_order'); ?>
                                        </a>
                                        |
                                        <a href="#" onclick="leads_kanban_sort('lastcontact');return false;" class="lastcontact">
                                            <?php if (get_option('default_leads_kanban_sort') == 'lastcontact') {
                                                echo '<i class="kanban-sort-icon fal fa-sort-amount-' . strtolower(get_option('default_leads_kanban_sort_type')) . '"></i> ';
                                            } ?><?php echo _l('leads_sort_by_lastcontact'); ?>
                                        </a>
                                    </div>
                                    <div class="row">
                                        <div class="container-fluid leads-kan-ban">
                                            <div id="kan-ban"></div>
                                        </div>
                                    </div>
                                </div>
                            <?php } else { ?>
                                <div class="row" id="leads-table">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <p class="bold"><?php echo _l('filter_by'); ?></p>
                                            </div>
                                            <?php if (has_permission('leads', '', 'view')) { ?>
                                                <div class="col-md-3 leads-filter-column">
                                                    <?php echo render_select('view_assigned', $staff, array('staffid', array('firstname', 'lastname')), '', '', array('data-width' => '100%', 'data-none-selected-text' => _l('leads_dt_assigned')), array(), 'no-mbot'); ?>
                                                </div>
                                            <?php } ?>
                                            <div class="col-md-3 leads-filter-column">
                                                <?php
                                                $selected = array();
                                                if ($this->input->get('status')) {
                                                    $selected[] = $this->input->get('status');
                                                } else {
                                                    foreach ($statuses as $key => $status) {
                                                        if ($status['isdefault'] == 0) {
                                                            $selected[] = $status['id'];
                                                        } else {
                                                            $statuses[$key]['option_attributes'] = array('data-subtext' => _l('leads_converted_to_client'));
                                                        }
                                                    }
                                                }
                                                echo '<div id="leads-filter-status">';
                                                echo render_select('view_status[]', $statuses, array('id', 'name'), '', $selected, array('data-width' => '100%', 'data-none-selected-text' => _l('leads_all'), 'multiple' => true, 'data-actions-box' => true), array(), 'no-mbot', '', false, true);
                                                echo '</div>';
                                                ?>
                                            </div>
                                            <div class="col-md-3 leads-filter-column">
                                                <?php
                                                echo render_select('view_source', $sources, array('id', 'name'), '', '', array('data-width' => '100%', 'data-none-selected-text' => _l('leads_source')), array(), 'no-mbot');
                                                ?>
                                            </div>
                                            <div class="col-md-3 leads-filter-column">
                                                <div class="select-placeholder">
                                                    <select name="custom_view" title="<?php echo _l('additional_filters'); ?>" id="custom_view" class="selectpicker" data-width="100%">
                                                        <option value=""></option>
                                                        <option value="lost"><?php echo _l('lead_lost'); ?></option>
                                                        <option value="junk"><?php echo _l('lead_junk'); ?></option>
                                                        <option value="public"><?php echo _l('lead_public'); ?></option>
                                                        <option value="contacted_today"><?php echo _l('lead_add_edit_contacted_today'); ?></option>
                                                        <option value="created_today"><?php echo _l('created_today'); ?></option>
                                                        <?php if (has_permission('leads', '', 'edit')) { ?>
                                                            <option value="not_assigned"><?php echo _l('leads_not_assigned'); ?></option>
                                                        <?php } ?>
                                                        <?php if (isset($consent_purposes)) { ?>
                                                            <optgroup label="<?php echo _l('gdpr_consent'); ?>">
                                                                <?php foreach ($consent_purposes as $purpose) { ?>
                                                                    <option value="consent_<?php echo $purpose['id']; ?>">
                                                                        <?php echo $purpose['name']; ?>
                                                                    </option>
                                                                <?php } ?>
                                                            </optgroup>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                    <hr class="hr-panel-heading"/>
                                    <div class="col-md-12">
                                        <a href="#" data-toggle="modal" data-table=".table-leads" data-target="#leads_bulk_actions" class="hide bulk-actions-btn table-btn"><?php echo _l('bulk_actions'); ?></a>
                                        <?php $this->load->view('admin/leads/_table', array('bulk_actions' => true)); ?>
                                        <?php $this->load->view('admin/leads/_bulk_actions'); ?>
                                        <!-- /.modal -->
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<script id="hidden-columns-table-leads" type="text/json">
   <?php echo get_staff_meta(get_staff_user_id(), 'hidden-columns-table-leads'); ?>

</script>
<?php include_once(APPPATH . 'views/admin/leads/status.php'); ?>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    var openLeadID = '<?php echo $leadid; ?>';
    $(function () {
        leads_kanban();
        $('#leads_bulk_mark_lost').on('change', function () {
            $('#move_to_status_leads_bulk').prop('disabled', $(this).prop('checked') == true);
            $('#move_to_status_leads_bulk').selectpicker('refresh')
        });
        $('#move_to_status_leads_bulk').on('change', function () {
            if ($(this).selectpicker('val') != '') {
                $('#leads_bulk_mark_lost').prop('disabled', true);
                $('#leads_bulk_mark_lost').prop('checked', false);
            } else {
                $('#leads_bulk_mark_lost').prop('disabled', false);
            }
        });
    });
</script>
</body>
</html>
