<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
	<div class="breadcrumb">
	<a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo _l('leads'); ?>"><?php echo _l('leads'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
	</div>
    <div class="admin-title">
		<h1><?= $this->config->item('icons')['leads/statuses']; ?> 
		<?php echo html_entity_decode($title); ?></h1>
    </div>
	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="panel_s">
					<div class="panel-body">
						<div class="_buttons">
							<a href="#" onclick="new_status(); return false;" class="btn btn-info pull-left display-block">
								 <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE: echo _l('lead_new_status'); ?>
							</a>
						</div>
						<div class="clearfix"></div>
						<hr class="hr-panel-heading" />
						<?php if(count($statuses) > 0){ ?>
						<table class="table dt-table scroll-responsive" data-order-col="1" data-order-type="asc">
							<thead>
								<th><?php echo _l('id'); ?></th>
								<th><?php echo _l('leads_status_table_name'); ?></th>
								<th><?php echo _l('options'); ?></th>
							</thead>
							<tbody>
								<?php foreach($statuses as $status){ ?>
								<tr>
									<td>
										<?php echo $status['id']; ?>
									</td>
									<td><a href="#" onclick="edit_status(this,<?php echo $status['id']; ?>);return false;" data-color="<?php echo $status['color']; ?>" data-name="<?php echo $status['name']; ?>" data-order="<?php echo $status['statusorder']; ?>"><?php echo $status['name']; ?></a><br />
										<span class="text-muted">
											<?php echo _l('leads_table_total',total_rows(db_prefix().'leads',array('status'=>$status['id']))); ?></span>
										</td>
										<td>
											<a href="#" onclick="edit_status(this,<?php echo $status['id']; ?>);return false;" data-color="<?php echo $status['color']; ?>" data-name="<?php echo $status['name']; ?>" data-order="<?php echo $status['statusorder']; ?>" class="btn btn-default btn-icon"><i class="fal fa-pencil-square-o"></i></a>
											<?php if($status['isdefault'] == 0){ ?>
											<a href="<?php echo admin_url('leads/delete_status/'.$status['id']); ?>" class="btn btn-danger btn-icon _delete"><i class="fal fa-remove"></i></a>
											<?php } ?>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
							<?php } else { ?>
							<p class="no-margin"><?php echo _l('lead_statuses_not_found'); ?></p>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		
	</div>
	<?php include_once(APPPATH.'views/admin/leads/status.php'); ?>
	<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
