<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="pipeline" tabindex="-1" role="dialog">
   <div class="modal-dialog">
      <?php echo form_open(admin_url('leads/pipeline'), array('id'=>'leads-pipeline-form')); ?>
      <div class="modal-content">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">
               <span class="edit-title"><?php echo _l('edit_pipeline'); ?></span>
               <span class="add-title"><?php echo _l('lead_new_pipeline'); ?></span>
            </h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-md-12">
                  <div id="additional"></div>
                  <?php echo render_input('name', 'leads_pipeline_add_edit_name'); ?>
               </div>
            </div>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
         </div>
      </div>
      <!-- /.modal-content -->
      <?php echo form_close(); ?>
   </div>
   <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<script>
  window.addEventListener('load', function () {
    appValidateForm($("body").find('#leads-pipeline-form'), {
        name: 'required'
    }, manage_leads_pipelines);
    $('#pipeline').on("hidden.bs.modal", function (event) {
        $('#additional').html('');
        $('#pipeline input[name="name"]').val('');
        $('.add-title').removeClass('hide');
        $('.edit-title').removeClass('hide');
    });
});

// Create lead new pipeline
function new_pipeline() {
    $('#pipeline').modal('show');
    $('.edit-title').addClass('hide');
}

// Edit pipeline function which init the data to the modal
function edit_pipeline(invoker, id) {
    $('#additional').append(hidden_input('id', id));
    $('#pipeline input[name="name"]').val($(invoker).data('name'));
    $('#pipeline').modal('show');
    $('.add-title').addClass('hide');
}

// Form handler function for leads pipeline
function manage_leads_pipelines(form) {
    var data = $(form).serialize();
    var url = form.action;
    $.post(url, data).done(function (response) {
        window.location.reload();
    });
    return false;
}
</script>
