<?php defined('BASEPATH') or exit('No direct script access allowed');
$opportunity_already_client_tooltip = '';
$opportunity_is_client = $opportunity['is_lead_client'] !== '0';
if ($opportunity_is_client) {
 $opportunity_already_client_tooltip = ' data-toggle="tooltip" title="' . _l('lead_have_client_profile') . '"';
}

if (isset($opportunity['status_opportunity']) && $opportunity['status_opportunity'] == $status['id']) { ?>
<li data-opportunity-id="<?php echo $opportunity['id']; ?>"<?php echo $opportunity_already_client_tooltip; ?> class="lead-kan-ban<?php if ($opportunity['assigned'] == get_staff_user_id()) {echo ' current-user-lead'; } ?><?php if($opportunity_is_client && get_option('lead_lock_after_convert_to_customer') == 1 && !is_admin()){echo ' not-sortable';} ?>">
   <div class="panel-body lead-body">
      <div class="row">
         <div class="col-md-12 lead-name">
            <?php if ($opportunity['assigned'] != 0) { ?>
            <a href="<?php echo admin_url('profile/' . $opportunity['assigned']); ?>" data-placement="right" data-toggle="tooltip" title="<?php echo get_staff_full_name($opportunity['assigned']); ?>" class="pull-left mtop8 mright5">
               <?php echo staff_profile_image($opportunity['assigned'], array(
                  'staff-profile-image-xs'
                  )); ?></a>
                  <?php  } ?>
                  <a href="<?php echo admin_url('leads/index/'.$opportunity['id']); ?>" onclick="init_opportunity(<?php echo $opportunity['id']; ?>);return false;" class="pull-left">
                     <span class="inline-block mtop10 mbot10">#<?php echo $opportunity['id'] . ' - ' . $opportunity['lead_name']; ?></span>
                  </a>
               </div>
               <div class="col-md-6 text-muted">
                  <small  class="text-dark"><?php echo _l('leads_canban_source', $opportunity['source_name']); ?></small>
                  <?php $opportunity_value = $opportunity['lead_value'] != 0 ? app_format_money($opportunity['lead_value'], $base_currency->symbol) : ''; ?>
                  <small  class="text-dark"><?php echo _l('leads_canban_lead_value', $opportunity_value ); ?></small>
               </div>
               <div class="col-md-6 text-right text-muted">
                  <?php if(is_date($opportunity['lastcontact']) && $opportunity['lastcontact'] != '0000-00-00 00:00:00'){ ?>
                     <small class="text-dark"><?php echo _l('leads_dt_last_contact'); ?> <span class="bold">
                        <span class="text-has-action" data-toggle="tooltip" data-title="<?php echo _dt($opportunity['lastcontact']); ?>">
                           <?php echo time_ago($opportunity['lastcontact']); ?>
                        </span>
                     </span>
                  </small><br />
                  <?php } ?>
                  <small class="text-dark"><?php echo _l('lead_created'); ?>: <span class="bold">
                    <span class="text-has-action" data-toggle="tooltip" data-title="<?php echo _dt($opportunity['dateadded']); ?>">
                       <?php echo time_ago($opportunity['dateadded']); ?>
                    </span>
                 </span>
              </small><br />
              <span class="mright5 mtop5 inline-block text-muted" data-toggle="tooltip" data-placement="left" data-title="<?php echo _l('leads_canban_notes',$opportunity['total_notes']); ?>">
               <i class="fal fa-sticky-note"></i> <?php echo $opportunity['total_notes']; ?>
            </span>
            <span class="mtop5 inline-block text-muted" data-placement="left" data-toggle="tooltip" data-title="<?php echo _l('lead_kan_ban_attachments',$opportunity['total_files']); ?>">
               <i class="fal fa-paperclip"></i>
               <?php echo $opportunity['total_files']; ?>
            </span>
         </div>
         <?php if($opportunity['tags']){ ?>
         <div class="col-md-12">
            <div class="mtop5 kanban-tags">
               <?php echo render_tags($opportunity['tags']); ?>
            </div>
         </div>
         <?php } ?>
         <a href="#" class="pull-right text-muted kan-ban-expand-top" onclick="slideToggle('#kan-ban-expand-<?php echo $opportunity['id']; ?>'); return false;">
            <i class="fal fa-expand" aria-hidden="true"></i>
         </a>
         <div class="clearfix no-margin"></div>
          <div id="kan-ban-expand-<?php echo $opportunity['id']; ?>" class="padding-10" style="display:none;">
            <div class="clearfix"></div>
            <hr class="hr-10" />
            <p class="text-muted lead-field-heading"><?php echo _l('lead_title'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['title'] != '' ? $opportunity['title'] : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_add_edit_email'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['email'] != '' ? '<a href="mailto:'.$opportunity['email'].'">' . $opportunity['email'].'</a>' : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_website'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['website'] != '' ? '<a href="'.maybe_add_http($opportunity['website']).'" target="_blank">' . $opportunity['website'].'</a>' : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_add_edit_phonenumber'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['phonenumber'] != '' ? '<a href="tel:'.$opportunity['phonenumber'].'">' . $opportunity['phonenumber'].'</a>' : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_company'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['company'] != '' ? $opportunity['company'] : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_address'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['address'] != '' ? $opportunity['address'] : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_city'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['city'] != '' ? $opportunity['city'] : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_state'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['state'] != '' ? $opportunity['state'] : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_country'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['country'] != 0 ? get_country($opportunity['country'])->short_name : '-') ?></p>
            <p class="text-muted lead-field-heading"><?php echo _l('lead_zip'); ?></p>
            <p class="bold font-medium-xs"><?php echo ($opportunity['zip'] != '' ? $opportunity['zip'] : '-') ?></p>
          </div>
      </div>
   </div>
</li>
<?php }
