<?php defined('BASEPATH') or exit('No direct script access allowed');
if ($proforma->status == proformas_model::STATUS_DRAFT) { ?>
    <div class="alert alert-info">
        <?php echo _l('proforma_draft_status_info'); ?>
    </div>
<?php }
if ($proforma->scheduled_email) { ?>
    <div class="alert alert-warning">
        <?php echo _l('proforma_will_be_sent_at', _dt($proforma->scheduled_email->scheduled_at)); ?>
        <?php if (staff_can('edit', 'proformas') || $proforma->addedfrom == get_staff_user_id()) { ?>
            <a href="#"
                    onclick="edit_proforma_scheduled_email(<?php echo $proforma->scheduled_email->id; ?>); return false;">
                <?php echo _l('edit'); ?>
            </a>
        <?php } ?>
    </div>
<?php } ?>
<div id="proforma-preview">
    <div class="row">
        <?php

        if ($proforma->recurring > 0 || $proforma->is_recurring_from != null) {

            $recurring_proforma = $proforma;
            $show_recurring_proforma_info = true;

            if ($proforma->is_recurring_from != null) {
                $recurring_proforma = $this->proformas_model->get($proforma->is_recurring_from);
                // Maybe recurring proforma not longer recurring?
                if ($recurring_proforma->recurring == 0) {
                    $show_recurring_proforma_info = false;
                } else {
                    $next_recurring_date_compare = $recurring_proforma->last_recurring_date;
                }
            } else {
                $next_recurring_date_compare = to_sql_date($recurring_proforma->date);
                if ($recurring_proforma->last_recurring_date) {
                    $next_recurring_date_compare = $recurring_proforma->last_recurring_date;
                }
            }
            if ($show_recurring_proforma_info) {
                if ($recurring_proforma->custom_recurring == 0) {
                    $recurring_proforma->recurring_type = 'MONTH';
                }
                $next_date = date('Y-m-d',
                    strtotime('+' . $recurring_proforma->recurring . ' ' . strtoupper($recurring_proforma->recurring_type), strtotime($next_recurring_date_compare)));
            }
            ?>
            <div class="col-md-12">
                <div class="mg-b-10">
                    <?php if ($proforma->is_recurring_from == null
                        && $recurring_proforma->cycles > 0
                        && $recurring_proforma->cycles == $recurring_proforma->total_cycles) { ?>
                        <div class="alert alert-info no-mbot">
                            <?php echo _l('recurring_has_ended', _l('proforma_lowercase')); ?>
                        </div>
                    <?php } else if ($show_recurring_proforma_info) { ?>
                        <span class="badge badge-secondary padding-5">
                        <?php
                        if ($proforma->status == proformas_model::STATUS_DRAFT) {
                            echo '<i class="fal fa-exclamation-circle fa-fw text-warning" data-toggle="tooltip" title="' . _l('recurring_proforma_draft_notice') . '"></i>';
                        }
                        echo _l('cycles_remaining'); ?>:
                        <b>
                           <?php
                           echo $recurring_proforma->cycles == 0 ? _l('cycles_infinity') : $recurring_proforma->cycles - $recurring_proforma->total_cycles;
                           ?>
                        </b>
                     </span>
                        <?php
                        if ($recurring_proforma->cycles == 0 || $recurring_proforma->cycles != $recurring_proforma->total_cycles) {
                            echo '<span class="badge badge-secondary padding-5 mg-l-5"><i class="fal fa-question-circle fa-fw" data-toggle="tooltip" data-title="' . _l('recurring_recreate_hour_notice',
                                    _l('proforma')) . '"></i> ' . _l('next_proforma_date', '<b>' . _d($next_date) . '</b>') . '</span>';
                        }
                    }
                    ?>
                </div>
                <?php if ($proforma->is_recurring_from != null) { ?>
                    <?php echo '<p class="text-muted' . ($show_recurring_proforma_info ? ' mg-t-15' : '') . '">' . _l('proforma_recurring_from',
                            '<a href="' . admin_url('proformas/list_proformas/' . $proforma->is_recurring_from) . '" onclick="init_proforma(' . $proforma->is_recurring_from . ');return false;">' . format_proforma_number($proforma->is_recurring_from) . '</a></p>'); ?>
                <?php } ?>
            </div>
            <div class="clearfix"></div>
            <hr class="hr-10"/>
        <?php } ?>
        <?php if ($proforma->project_id != 0) { ?>
            <div class="col-md-12">
                <h4 class="font-medium mg-t-15 mg-b-20"><?php echo _l('related_to_project', [
                        _l('proforma_lowercase'),
                        _l('project_lowercase'),
                        '<a href="' . admin_url('projects/view/' . $proforma->project_id) . '" target="_blank">' . $proforma->project_data->name . '</a>',
                    ]); ?></h4>
            </div>
        <?php } ?>
        <div class="col-md-6 col-sm-6">
            <h4 class="bold">
                <?php
                $tags = get_tags_in($proforma->id, 'proforma');
                if (count($tags) > 0) {
                    echo '<i class="fal fa-tag" aria-hidden="true" data-toggle="tooltip" data-title="' . html_escape(implode(', ', $tags)) . '"></i>';
                }
                ?>
                <a href="<?php echo admin_url('proformas/proforma/' . $proforma->id); ?>">
            <span id="proforma-number">
            <?php echo format_proforma_number($proforma->id); ?>
            </span>
                </a>
            </h4>
            <address>
                <?php echo format_organization_invoicing_info(); ?>
            </address>
        </div>
        <div class="col-sm-6 text-right">
            <span class="bold"><?php echo _l('proforma_bill_to'); ?>:</span>
            <address>
                <?php
                if ((int)$proforma->options['view_client_code'] == '1') {
                    echo '<span class="bold">' . _l('client_code') . ': #' . $proforma->client->userid . '<br></span>';
                }
                ?>
                <?php echo format_customer_info($proforma, 'proforma', 'billing', true); ?>
            </address>
            <?php if ($proforma->include_shipping == 1 && $proforma->show_shipping_on_invoice == 1) { ?>
                <span class="bold"><?php echo _l('ship_to'); ?>:</span>
                <address>
                    <?php echo format_customer_info($proforma, 'proforma', 'shipping'); ?>
                </address>
            <?php } ?>
            <p class="no-mbot">
            <span class="bold">
            <?php echo _l('proforma_data_date'); ?>
            </span>
                <?php echo $proforma->date; ?>
            </p>
            <?php if (!empty($proforma->duedate)) { ?>
                <p class="no-mbot">
            <span class="bold">
            <?php echo _l('proforma_data_duedate'); ?>
            </span>
                    <?php echo $proforma->duedate; ?>
                </p>
            <?php } ?>
            <?php if ($proforma->sale_agent != 0 && get_option('show_sale_agent_on_proformas') == 1) { ?>
                <p class="no-mbot">
                    <span class="bold"><?php echo _l('sale_agent_string'); ?>: </span>
                    <?php echo get_staff_full_name($proforma->sale_agent); ?>
                </p>
            <?php } ?>
            <?php if ($proforma->project_id != 0 && get_option('show_project_on_proforma') == 1) { ?>
                <p class="no-mbot">
                    <span class="bold"><?php echo _l('project'); ?>:</span>
                    <?php echo get_project_name_by_id($proforma->project_id); ?>
                </p>
            <?php } ?>
            <?php $pdf_custom_fields = get_custom_fields('proforma', ['show_on_pdf' => 1]);
            foreach ($pdf_custom_fields as $field) {
                $value = get_custom_field_value($proforma->id, $field['id'], 'proforma');
                if ($value == '') {
                    continue;
                } ?>
                <p class="no-mbot">
                    <span class="bold"><?php echo $field['name']; ?>: </span>
                    <?php echo $value; ?>
                </p>
            <?php } ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <?php
                $items = get_items_table_data($proforma, 'proforma', 'html', true);
                $tbl_html = $items->table();

                $tbl_html = str_replace('{DOC_CUR}', $proforma->symbol, $tbl_html);
                echo $tbl_html;


                ?>
            </div>
        </div>
        <div class="flex flex-col w-full justify-end items-end">
            <table class="table text-right max-w-md mr-4">
                <tbody>
                <tr id="subtotal">
                    <td><span class="bold"><?php echo _l('proforma_subtotal'); ?></span>
                    </td>
                    <td class="subtotalx">
                        <?php echo app_format_money($proforma->subtotal, $proforma->currency_name); ?>
                    </td>
                </tr>
                <?php if (is_sale_discount_applied($proforma)) { ?>
                    <tr>
                        <td>
              <span class="bold"><?php echo _l('proforma_discount'); ?>
                  <?php if (is_sale_discount($proforma, 'percent')) { ?>
                      (<?php echo app_format_number($proforma->discount_percent, true); ?>%)
                  <?php } ?>
              </span>
                        </td>
                        <td class="discount">
                            <?php echo '-' . app_format_money($proforma->discount_total, $proforma->currency_name); ?>
                        </td>
                    </tr>
                <?php } ?>
                <?php
                foreach ($items->taxes() as $tax) {
                    echo '<tr class="tax-area"><td class="bold">' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)</td><td>' . app_format_money($tax['total_tax'],
                            $proforma->currency_name) . '</td></tr>';
                }
                ?>
                <?php if ((int)$proforma->adjustment != 0) { ?>
                    <tr>
                        <td>
                            <span class="bold"><?php echo _l('proforma_adjustment'); ?></span>
                        </td>
                        <td class="adjustment">
                            <?php echo app_format_money($proforma->adjustment, $proforma->currency_name); ?>
                        </td>
                    </tr>
                <?php } ?>
                <tr>
                    <td><span class="bold"><?php echo _l('proforma_total'); ?></span>
                    </td>
                    <td class="totalx">
                        <?php echo app_format_money($proforma->total, $proforma->currency_name); ?>
                    </td>
                </tr>
                <?php if (count($proforma->payments) > 0 && get_option('show_total_paid_on_proforma') == 1) { ?>
                    <tr>
                        <td><span class="bold"><?php echo _l('proforma_total_paid'); ?></span></td>
                        <td>
                            <?php echo '-' . app_format_money(sum_from_table(db_prefix() . 'proformapaymentrecords',
                                    ['field' => 'amount', 'where' => ['proformaid' => $proforma->id]]), $proforma->currency_name); ?>
                        </td>
                    </tr>
                <?php } ?>
                <?php if (get_option('show_credits_applied_on_proforma') == 1 && $credits_applied = total_credits_applied_to_proforma($proforma->id)) { ?>
                    <tr>
                        <td><span class="bold"><?php echo _l('applied_credits'); ?></span></td>
                        <td>
                            <?php echo '-' . app_format_money($credits_applied, $proforma->currency_name); ?>
                        </td>
                    </tr>
                <?php } ?>
                <?php if (get_option('show_amount_due_on_proforma') == 1 && $proforma->status != proformas_model::STATUS_CANCELLED) { ?>
                    <tr>
                        <td><span class="<?php if ($proforma->total_left_to_pay > 0) {
                                echo 'text-danger ';
                            } ?>bold"><?php echo _l('proforma_amount_due'); ?></span></td>
                        <td>
                     <span class="<?php if ($proforma->total_left_to_pay > 0) {
                         echo 'text-danger';
                     } ?>">
                     <?php echo app_format_money($proforma->total_left_to_pay, $proforma->currency_name); ?>
                     </span>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if (count($proforma->attachments) > 0) { ?>
        <div class="clearfix"></div>
        <hr/>
        <p class="bold text-muted"><?php echo _l('proforma_files'); ?></p>
        <?php foreach ($proforma->attachments as $attachment) {
            $attachment_url = site_url('download/file/sales_attachment/' . $attachment['attachment_key']);
            if (!empty($attachment['external'])) {
                $attachment_url = $attachment['external_link'];
            }
            ?>
            <div class="mg-b-15 row inline-block full-width" data-attachment-id="<?php echo $attachment['id']; ?>">
                <div class="col-md-8">
                    <div class="float-left"><i class="<?php echo get_mime_class($attachment['filetype']); ?>"></i></div>
                    <a href="<?php echo $attachment_url; ?>" target="_blank"><?php echo $attachment['file_name']; ?></a>
                    <br/>
                    <small class="text-muted"> <?php echo $attachment['filetype']; ?></small>
                </div>
                <div class="col-md-4 text-right">
                    <?php if ($attachment['visible_to_customer'] == 0) {
                        $icon = 'fa-toggle-off';
                        $tooltip = _l('show_to_customer');
                    } else {
                        $icon = 'fa-toggle-on';
                        $tooltip = _l('hide_from_customer');
                    }
                    ?>
                    <a href="#" data-toggle="tooltip" onclick="toggle_file_visibility(<?php echo $attachment['id']; ?>,<?php echo $proforma->id; ?>,this); return false;"
                            data-title="<?php echo $tooltip; ?>"><i class="fa <?php echo $icon; ?>" aria-hidden="true"></i></a>
                    <?php if ($attachment['staffid'] == get_staff_user_id() || is_admin()) { ?>
                        <a href="#" class="text-danger" onclick="delete_proforma_attachment(<?php echo $attachment['id']; ?>); return false;"><i class="fal fa-times"></i></a>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    <?php } ?>
    <hr/>
    <?php if ($proforma->clientnote != '') { ?>
        <div class="col-md-12 row mg-t-15">
            <p class="bold text-muted"><?php echo _l('proforma_note'); ?></p>
            <p><?php echo $proforma->clientnote; ?></p>
        </div>
    <?php } ?>
    <?php if ($proforma->terms != '') { ?>
        <div class="col-md-12 row mg-t-15">
            <p class="bold text-muted"><?php echo _l('terms_and_conditions'); ?></p>
            <p><?php echo $proforma->terms; ?></p>
        </div>
    <?php } ?>
</div>
