<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php if (count($proformas_to_merge) > 0) { ?>
    <div class="panel_s no-padding mbot5">
        <div class="panel-body">
            <h4 class="font-medium bold no-mtop mg-b-15"><?php echo _l('proformas_available_for_merging'); ?></h4>
            <hr class="hr-panel-heading hr-10"/>
            <?php foreach ($proformas_to_merge as $_inv) { ?>
                <p>
                    <a href="<?php echo admin_url('proformas/list_proformas/' . $_inv->id); ?>" target="_blank"><?php echo format_proforma_number($_inv->id); ?></a>
                    - <?php echo app_format_money($_inv->total, $_inv->currency_name); ?>
                    <span class="float-right text-<?php echo get_proforma_status_label($_inv->status); ?>">
         <?php echo format_proforma_status($_inv->status, '', false); ?>
         </span>
                </p>
            <?php } ?>
        </div>
    </div>
<?php } ?>
<?php echo form_hidden('_attachment_sale_id', $proforma->id); ?>
<?php echo form_hidden('_attachment_sale_type', 'proforma'); ?>
<div class="col-md-12 no-padding">
    <div class="panel_s">
        <div class="panel-body">
            <?php if ($proforma->recurring > 0) {
                echo '<div class="ribbon info"><span>' . _l('proforma_recurring_indicator') . '</span></div>';
            } ?>
            <div class="horizontal-scrollable-tabs preview-tabs-top">
                <div class="scroller arrow-left"><i class="fal fa-angle-left"></i></div>
                <div class="scroller arrow-right"><i class="fal fa-angle-right"></i></div>
                <div class="horizontal-tabs">
                    <ul class="nav nav-tabs nav-tabs-horizontal mbot15" role="tablist">
                        <li role="presentation" class="active">
                            <a href="#tab_proforma" class="nav-link active show" aria-controls="tab_proforma" role="tab" data-toggle="tab">
                                <?php echo _l('proforma'); ?>
                            </a>
                        </li>
                        <?php if (count($proforma->payments) > 0) { ?>
                            <li role="presentation">
                                <a href="#proforma_payments_received" class="nav-link" aria-controler="proforma_payments_received" role="tab" data-toggle="tab">
                                    <?php echo _l('payments'); ?>
                                    <span class="badge"><?php echo count($proforma->payments); ?></span>
                                </a>
                            </li>
                        <?php } ?>
                        <?php if (count($proforma_recurring_proformas) > 0 || $proforma->recurring != 0) { ?>
                            <li role="presentation">
                                <a href="#tab_child_proformas" class="nav-link" aria-controls="tab_child_proformas" role="tab" data-toggle="tab">
                                    <?php echo _l('child_proformas'); ?>
                                </a>
                            </li>
                        <?php } ?>
                        <li role="presentation">
                            <a href="#tab_tasks" class="nav-link" onclick="init_rel_tasks_table(<?php echo $proforma->id; ?>,'proforma'); return false;" aria-controls="tab_tasks" role="tab" data-toggle="tab">
                                <?php echo _l('tasks'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_activity" class="nav-link" aria-controls="tab_activity" role="tab" data-toggle="tab">
                                <?php echo _l('proforma_view_activity_tooltip'); ?>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#tab_reminders" class="nav-link" onclick="initDataTable('.table-reminders', admin_url + 'misc/get_reminders/' + <?php echo $proforma->id; ?> + '/' + 'proforma', undefined, undefined,undefined,[1,'asc']); return false;" aria-controls="tab_reminders" role="tab" data-toggle="tab">
                                <?php echo _l('estimate_reminders'); ?>
                                <?php
                                $total_reminders = total_rows(db_prefix() . 'reminders',
                                    array(
                                        'isnotified' => 0,
                                        'staff' => get_staff_user_id(),
                                        'rel_type' => 'proforma',
                                        'rel_id' => $proforma->id
                                    )
                                );
                                if ($total_reminders > 0) {
                                    echo '<span class="badge">' . $total_reminders . '</span>';
                                }
                                ?>
                            </a>
                        </li>
                        <li role="presentation" class="nav-item">
                            <a href="#tab_notes" class="nav-link" onclick="get_sales_notes(<?php echo $proforma->id; ?>,'proformas'); return false" aria-controls="tab_notes" role="tab" data-toggle="tab">
                                <?php echo _l('estimate_notes'); ?> <span class="notes-total">
                     <?php if ($totalNotes > 0) { ?>
                         <span class="badge"><?php echo $totalNotes; ?></span>
                     <?php } ?>
                     </span>
                            </a>
                        </li>
                        <li role="presentation" data-toggle="tooltip" title="<?php echo _l('emails_tracking'); ?>" class="nav-item">
                            <a href="#tab_emails_tracking" class="nav-link" aria-controls="tab_emails_tracking" role="tab" data-toggle="tab">
                                <?php if (!is_mobile()) { ?>
                                    <i class="fal fa-envelope-open" aria-hidden="true"></i>
                                <?php } else { ?>
                                    <?php echo _l('emails_tracking'); ?>
                                <?php } ?>
                            </a>
                        </li>
                        <li role="presentation" data-toggle="tooltip" title="<?php echo _l('view_tracking'); ?>" class="nav-item">
                            <a href="#tab_views" class="nav-link" aria-controls="tab_views" role="tab" data-toggle="tab">
                                <?php if (!is_mobile()) { ?>
                                    <i class="fal fa-eye"></i>
                                <?php } else { ?>
                                    <?php echo _l('view_tracking'); ?>
                                <?php } ?>
                            </a>
                        </li>
                        <li role="presentation" data-toggle="tooltip" data-title="<?php echo _l('toggle_full_view'); ?>" class="nav-item toggle_view">
                            <a href="#" class="nav-link" onclick="small_table_full_view(); return false;">
                                <i class="fal fa-expand"></i></a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="row mtop10">
                <div class="col-md-3">
                    <?php echo format_proforma_status($proforma->status, 'mg-t-5'); ?>
                    <?php if ($proforma->status == proformas_model::STATUS_PARTIALLY || $proforma->status == proformas_model::STATUS_OVERDUE) {
                        if ($proforma->duedate && date('Y-m-d') > date('Y-m-d', strtotime(to_sql_date($proforma->duedate)))) {
                            echo '<p class="text-danger mtop15 no-mbot">' . _l('proforma_is_overdue', floor((abs(time() - strtotime(to_sql_date($proforma->duedate)))) / (60 * 60 * 24))) . '</p>';
                        }
                    } ?>
                </div>
                <div class="col-md-9 _buttons">
                    <div class="visible-xs">
                        <div class="mg-t-10"></div>
                    </div>
                    <div class="float-right">
                        <?php
                        $_tooltip = _l('proforma_sent_to_email_tooltip');
                        $_tooltip_already_send = '';
                        if ($proforma->sent == 1 && is_date($proforma->datesend)) {
                            $_tooltip_already_send = _l('proforma_already_send_to_client_tooltip', time_ago($proforma->datesend));
                        }
                        ?>
                        <?php if (has_permission('proformas', '', 'edit')) { ?>
                            <a href="<?php echo admin_url('proformas/proforma/' . $proforma->id); ?>" data-toggle="tooltip" title="<?php echo _l('edit_proforma_tooltip'); ?>" class="btn btn-outline-secondary btn-with-tooltip" data-placement="bottom"><i class="fal fa-edit"></i></a>
                        <?php } ?>
                        <div class="btn-group">
                            <a href="#" class="btn btn-outline-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fal fa-file-pdf"></i><?php if (is_mobile()) {
                                    echo ' PDF';
                                } ?></a>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li class="hidden-xs">
                                    <a href="<?php echo admin_url('proformas/pdf/' . $proforma->id . '?output_type=I'); ?>" class="dropdown-item"><?php echo _l('view_pdf'); ?></a>
                                </li>
                                <li class="hidden-xs">
                                    <a href="<?php echo admin_url('proformas/pdf/' . $proforma->id . '?output_type=I'); ?>" class="dropdown-item" target="_blank"><?php echo _l('view_pdf_in_new_window'); ?></a>
                                </li>
                                <li>
                                    <a href="<?php echo admin_url('proformas/pdf/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('download'); ?></a>
                                </li>
                                <li>
                                    <a href="<?php echo admin_url('proformas/pdf/' . $proforma->id . '?print=true'); ?>" class="dropdown-item" target="_blank">
                                        <?php echo _l('print'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <?php if (!empty($proforma->clientid)) { ?>
                            <span<?php if ($proforma->status == proformas_model::STATUS_CANCELLED) { ?> data-toggle="tooltip" data-title="<?php echo _l('proforma_cancelled_email_disabled'); ?>"<?php } ?>>
                  <a href="#" class="proforma-send-to-client btn-with-tooltip btn btn-outline-secondary<?php if ($proforma->status == proformas_model::STATUS_CANCELLED) {
                      echo ' disabled';
                  } ?>" data-toggle="tooltip" title="<?php echo $_tooltip; ?>" data-placement="bottom"><span data-toggle="tooltip" data-title="<?php echo $_tooltip_already_send; ?>"><i class="fal fa-envelope"></i></span></a>
                  </span>
                        <?php } ?>
                        <!-- Single button -->
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-secondary float-left dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?php echo _l('more'); ?>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a href="<?php echo site_url('proforma/' . $proforma->id . '/' . $proforma->hash) ?>" class="dropdown-item" target="_blank"><?php echo _l('view_proforma_as_customer_tooltip'); ?></a>
                                </li>
                                <li>
                                    <?php hooks()->do_action('after_proforma_view_as_client_link', $proforma); ?>
                                    <?php if (($proforma->status == proformas_model::STATUS_OVERDUE
                                            || ($proforma->status == proformas_model::STATUS_PARTIALLY && !empty($proforma->duedate) && $proforma->duedate && date('Y-m-d') > date('Y-m-d', strtotime(to_sql_date($proforma->duedate)))))
                                        && is_proformas_overdue_reminders_enabled()) { ?>
                                        <a href="<?php echo admin_url('proformas/send_overdue_notice/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('send_overdue_notice_tooltip'); ?></a>
                                    <?php } ?>
                                </li>
                                <li>
                                    <a href="#" data-toggle="modal" data-target="#sales_attach_file" class="dropdown-item"><?php echo _l('proforma_attach_file'); ?></a>
                                </li>
                                <?php if (has_permission('proformas', '', 'create')) { ?>
                                    <li>
                                        <a href="<?php echo admin_url('proformas/copy/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('proforma_copy'); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if ($proforma->sent == 0) { ?>
                                    <li>
                                        <a href="<?php echo admin_url('proformas/mark_as_sent/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('proforma_mark_as_sent'); ?></a>
                                    </li>
                                <?php } ?>
                                <?php if (has_permission('proformas', '', 'edit') || has_permission('proformas', '', 'create')) { ?>
                                    <li>
                                        <?php if ($proforma->status != proformas_model::STATUS_CANCELLED
                                            && $proforma->status != proformas_model::STATUS_PAID
                                            && $proforma->status != proformas_model::STATUS_PARTIALLY) { ?>
                                            <a href="<?php echo admin_url('proformas/mark_as_cancelled/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('proforma_mark_as', _l('proforma_status_cancelled')); ?></a>
                                        <?php } else if ($proforma->status == proformas_model::STATUS_CANCELLED) { ?>
                                            <a href="<?php echo admin_url('proformas/unmark_as_cancelled/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('proforma_unmark_as', _l('proforma_status_cancelled')); ?></a>
                                        <?php } ?>
                                    </li>
                                <?php } ?>
                                <?php if (!in_array($proforma->status, array(proformas_model::STATUS_PAID, proformas_model::STATUS_CANCELLED, proformas_model::STATUS_DRAFT))
                                    && has_permission('proformas', '', 'edit')
                                    && $proforma->duedate
                                    && is_proformas_overdue_reminders_enabled()) { ?>
                                    <li>
                                        <?php if ($proforma->cancel_overdue_reminders == 1) { ?>
                                            <a href="<?php echo admin_url('proformas/resume_overdue_reminders/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('resume_overdue_reminders'); ?></a>
                                        <?php } else { ?>
                                            <a href="<?php echo admin_url('proformas/pause_overdue_reminders/' . $proforma->id); ?>" class="dropdown-item"><?php echo _l('pause_overdue_reminders'); ?></a>
                                        <?php } ?>
                                    </li>
                                <?php } ?>
                                <?php
                                if ((get_option('delete_only_on_last_proforma') == 1 && is_last_proforma($proforma->id)) || (get_option('delete_only_on_last_proforma') == 0)) { ?>
                                    <?php if (has_permission('proformas', '', 'delete')) { ?>
                                        <li data-toggle="tooltip" data-title="<?php echo _l('delete_proforma_tooltip'); ?>">
                                            <a href="<?php echo admin_url('proformas/delete/' . $proforma->id); ?>" class="text-danger dropdown-item delete-text _delete"><?php echo _l('delete_proforma'); ?></a>
                                        </li>
                                    <?php } ?>
                                <?php } ?>
                            </ul>
                        </div>
                        <?php if (has_permission('invoice', '', 'create') && abs($proforma->total) > 0) { ?>
                            <a href="<?php echo admin_url('proformas/invoice/' . $proforma->id); ?>" class="mg-l-10 float-right btn btn-success">
                                <i class="fal fa-plus-square"></i> <?php /* INACTIVE: echo _l('invoice');*/ ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <hr class="hr-panel-heading"/>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="tab_proforma">
                    <?php if ($proforma->status == proformas_model::STATUS_CANCELLED && $proforma->recurring > 0) { ?>
                        <div class="alert alert-info">
                            Recurring proforma with status Cancelled <b>is still ongoing recurring proforma</b>. If you
                            want to stop this recurring proforma you should update the proforma recurring field to
                            <b>No</b>.
                        </div>
                    <?php } ?>
                    <?php $this->load->view('admin/proformas/proforma_preview_html'); ?>
                </div>
                <?php if (count($proforma->payments) > 0) { ?>
                    <div class="tab-pane" role="tabpanel" id="proforma_payments_received">
                        <?php include_once(APPPATH . 'views/admin/proformas/proforma_payments_table.php'); ?>
                    </div>
                <?php } ?>
                <div role="tabpanel" class="tab-pane" id="tab_tasks">
                    <?php init_relation_tasks_table(array('data-new-rel-id' => $proforma->id, 'data-new-rel-type' => 'proforma')); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_reminders">
                    <a href="#" class="btn btn-primary btn-xs" data-toggle="modal" data-target=".reminder-modal-proforma-<?php echo $proforma->id; ?>"><i class="fal fa-bell"></i> <?php echo _l('proforma_set_reminder_title'); ?>
                    </a>
                    <hr/>
                    <?php render_datatable(array(_l('reminder_description'), _l('reminder_date'), _l('reminder_staff'), _l('reminder_is_notified')), 'reminders'); ?>
                    <?php $this->load->view('admin/includes/modals/reminder', array('id' => $proforma->id, 'name' => 'proforma', 'members' => $members, 'reminder_title' => _l('proforma_set_reminder_title'))); ?>
                </div>
                <?php if (count($proforma_recurring_proformas) > 0 || $proforma->recurring != 0) { ?>
                    <div role="tabpanel" class="tab-pane" id="tab_child_proformas">
                        <?php if (count($proforma_recurring_proformas)) { ?>
                            <p class="mtop30 bold"><?php echo _l('proforma_add_edit_recurring_proformas_from_proforma'); ?></p>
                            <br/>
                            <ul class="list-group">
                                <?php foreach ($proforma_recurring_proformas as $recurring) { ?>
                                    <li class="list-group-item">
                                        <a href="<?php echo admin_url('proformas/list_proformas/' . $recurring->id); ?>" onclick="init_proforma(<?php echo $recurring->id; ?>); return false;" target="_blank"><?php echo format_proforma_number($recurring->id); ?>
                                            <span class="float-right bold"><?php echo app_format_money($recurring->total, $recurring->currency_name); ?></span>
                                        </a>
                                        <br/>
                                        <span class="inline-block mg-t-10">
                     <?php echo '<span class="bold">' . _d($recurring->date) . '</span>'; ?><br/>
                     <?php echo format_proforma_status($recurring->status, '', false); ?>
                     </span>
                                    </li>
                                <?php } ?>
                            </ul>
                        <?php } else { ?>
                            <p class="bold"><?php echo _l('no_child_found', _l('proformas')); ?></p>
                        <?php } ?>
                    </div>
                <?php } ?>
                <div role="tabpanel" class="tab-pane" id="tab_emails_tracking">
                    <?php
                    $this->load->view('admin/includes/emails_tracking', array(
                            'tracked_emails' =>
                                get_tracked_emails($proforma->id, 'proforma'))
                    );
                    ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_notes">
                    <?php echo form_open(admin_url('proformas/add_note/' . $proforma->id), array('id' => 'sales-notes', 'class' => 'proforma-notes-form')); ?>
                    <?php echo render_textarea('description'); ?>
                    <div class="text-right">
                        <button type="submit" class="btn btn-info mg-t-15 mg-b-15"><?php echo _l('estimate_add_note'); ?></button>
                    </div>
                    <?php echo form_close(); ?>
                    <hr/>
                    <div class="mg-t-20" id="sales_notes_area"></div>
                </div>
                <div role="tabpanel" class="tab-pane ptop10" id="tab_activity">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="activity-feed">
                                <?php foreach ($activity as $activity) {
                                    $_custom_data = false;
                                    ?>
                                    <div class="feed-item" data-sale-activity-id="<?php echo $activity['id']; ?>">
                                        <div class="date">
                              <span class="text-has-action" data-toggle="tooltip" data-title="<?php echo _dt($activity['date']); ?>">
                              <?php echo time_ago($activity['date']); ?>
                              </span>
                                        </div>
                                        <div class="text">
                                            <?php if (is_numeric($activity['staffid']) && $activity['staffid'] != 0) { ?>
                                                <a href="<?php echo admin_url('profile/' . $activity["staffid"]); ?>">
                                                    <?php echo staff_profile_image($activity['staffid'], array('staff-profile-xs-image float-left mg-r-5 wd-32 rounded-circle'));
                                                    ?>
                                                </a>
                                            <?php } ?>
                                            <?php
                                            $additional_data = '';
                                            if (!empty($activity['additional_data'])) {
                                                $additional_data = unserialize($activity['additional_data']);
                                                $i = 0;
                                                foreach ($additional_data as $data) {
                                                    if (strpos($data, '<original_status>') !== false) {
                                                        $original_status = get_string_between($data, '<original_status>', '</original_status>');
                                                        $additional_data[$i] = format_proforma_status($original_status, '', false);
                                                    } else if (strpos($data, '<new_status>') !== false) {
                                                        $new_status = get_string_between($data, '<new_status>', '</new_status>');
                                                        $additional_data[$i] = format_proforma_status($new_status, '', false);
                                                    } else if (strpos($data, '<custom_data>') !== false) {
                                                        $_custom_data = get_string_between($data, '<custom_data>', '</custom_data>');
                                                        unset($additional_data[$i]);
                                                    }
                                                    $i++;
                                                }
                                            }
                                            $_formatted_activity = _l($activity['description'], $additional_data);
                                            if ($_custom_data !== false) {
                                                $_formatted_activity .= ' - ' . $_custom_data;
                                            }
                                            if (!empty($activity['full_name'])) {
                                                $_formatted_activity = $activity['full_name'] . ' - ' . $_formatted_activity;
                                            }
                                            echo $_formatted_activity;
                                            if (is_admin()) {
                                                echo '<a href="#" class="float-right text-danger" onclick="delete_sale_activity(' . $activity['id'] . '); return false;"><i class="fas fa-times"></i></a>';
                                            }
                                            ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_views">
                    <?php
                    $views_activity = get_views_tracking('proforma', $proforma->id);
                    if (count($views_activity) === 0) {
                        echo '<h4 class="no-mbot">' . _l('not_viewed_yet', _l('proforma_lowercase')) . '</h4>';
                    }
                    foreach ($views_activity as $activity) { ?>
                        <p class="text-success mg-0">
                            <?php echo _l('view_date') . ': ' . _dt($activity['date']); ?>
                        </p>
                        <p class="text-muted">
                            <?php echo _l('view_ip') . ': ' . $activity['view_ip']; ?>
                        </p>
                        <hr/>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $this->load->view('admin/proformas/proforma_send_to_client'); ?>
<script>
    init_items_sortable(true);
    init_btn_with_tooltips();
    init_datepicker();
    init_selectpicker();
    init_form_reminder();
    init_tabs_scrollable();
    <?php if($record_payment) { ?>
    record_payment_proforma(<?php echo $proforma->id; ?>);
    <?php } ?>
</script>
