<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div id="stats-top" class="hide mg-t-15">
  <div class="card bd-0 shadow-base mg-t-15">
    <div class="card-body pd-15">
      <div id="proformas_total" class="mg-b-15"></div>
			<?php
				$where_all           = '';
				$has_permission_view = has_permission('proformas', '', 'view');
				if (isset($project)) {
					$where_all .= 'project_id=' . $project->id . ' AND ';
				}
				if (!$has_permission_view) {
					$where_all .= get_proformas_where_sql_for_staff(get_staff_user_id());
				}
				$where_all = trim($where_all);
				if (endsWith($where_all, ' AND')) {
					$where_all = substr_replace($where_all, '', -4);
				}
				$total_proformas = total_rows(db_prefix() . 'proformas', $where_all);
			?>
      <div class="row text-left quick-top-stats">
				<?php foreach ($proformas_statuses as $status) {
					if ($status == proformas_model::STATUS_CANCELLED) {
						continue;
					}
					
					$where = ['status' => $status];
					if (isset($project)) {
						$where['project_id'] = $project->id;
					}
					if (!$has_permission_view) {
						$where['addedfrom'] = get_staff_user_id();
					}
					$total_by_status = total_rows(db_prefix() . 'proformas', $where);
					$percent         = ($total_proformas > 0 ? number_format(($total_by_status * 100) / $total_proformas, 2) : 0);
					?>
          <div class="col-xs-12 col-sm-12 col-md col-lg">
            <div class="row">
              <div class="col-md-7">
                <a href="#" data-cview="proformas_<?php echo $status; ?>"
                   onclick="dt_custom_view('proformas_<?php echo $status; ?>','.table-proformas','proformas_<?php echo $status; ?>',true); return false;">
                  <h5><?php echo format_proforma_status($status, '', false); ?></h5>
                </a>
              </div>
              <div class="col-md-5 text-right">
								<?php echo $total_by_status; ?> / <?php echo $total_proformas; ?>
              </div>
              <div class="col-md-12">
                <div class="progress mg-0">
                  <div class="progress-bar progress-bar-<?php echo get_proforma_status_label($status); ?>" role="progressbar" aria-valuenow="40" aria-valuemin="0"
                       aria-valuemax="100" style="width: 0%" data-percent="<?php echo $percent; ?>">
                  </div>
                </div>
              </div>
            </div>
          </div>
				<?php } ?>
      </div>
    </div>
  </div>
</div>
