<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="row">
  <?php if (count($proformas_years) > 1 || isset($proformas_total_currencies)) { ?>
    <div class="col-md-12 simple-bootstrap-select mg-b-5 text-right">
      <?php if (isset($proformas_total_currencies)) { ?>
        <select data-show-subtext="true" data-width="auto" class="selectpicker" name="total_currency" onchange="init_proformas_total();">
          <?php foreach ($proformas_total_currencies as $currency) {
            $selected = '';
            if (!$this->input->post('currency')) {
              if ($currency['isdefault'] == 1 || isset($_currency) && $_currency == $currency['id']) {
                $selected = 'selected';
              }
            } else {
              if ($this->input->post('currency') == $currency['id']) {
                $selected = 'selected';
              }
            }
            ?>
            <option value="<?php echo $currency['id']; ?>" <?php echo $selected; ?> data-subtext="<?php echo $currency['name']; ?>">
              <?php echo $currency['symbol']; ?>
            </option>
          <?php } ?>
        </select>
      <?php } ?>
      <?php if (count($proformas_years) > 1) { ?>
        <select data-none-selected-text="<?php echo date('Y'); ?>" data-width="auto" class="selectpicker" name="proformas_total_years"
                onchange="init_proformas_total();" multiple="true" id="proformas_total_years">
          <?php foreach ($proformas_years as $year) { ?>
            <option value="<?php echo $year['year']; ?>"<?php if ($this->input->post('years') && in_array($year['year'],
                $this->input->post('years')) || !$this->input->post('years') && date('Y') == $year['year']) {
              echo ' selected';
            } ?>><?php echo $year['year']; ?></option>
          <?php } ?>
        </select>
      <?php } ?>
    </div>
    <div class="clearfix"></div>
  <?php } ?>
  <div class="col-lg-4 col-xs-12 col-md-12 total-column">
    <div class="pd-y-15 tx-center bd text-center">
      <i class="fal fa-comment-dollar tx-50 tx-warning"></i>
      <h3 class="tx-lato tx-inverse tx-bold mg-b-0 _total">
        <?php echo app_format_money($total_result['due'], $total_result['currency']); ?>
      </h3>
      <span class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?php echo _l('outstanding_proformas'); ?></span>
    </div>
  </div>
  <div class="col-lg-4 col-xs-12 col-md-12 total-column">
    <div class="pd-y-15 tx-center bd text-center">
      <i class="fal fa-comment-alt-times tx-50 tx-danger"></i>
      <h3 class="tx-lato tx-inverse tx-bold mg-b-0 _total">
        <?php echo app_format_money($total_result['overdue'], $total_result['currency']); ?>
      </h3>
      <span class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?php echo _l('past_due_proformas'); ?></span>
    </div>
  </div>
  <div class="col-lg-4 col-xs-12 col-md-12 total-column">
    <div class="pd-y-15 tx-center bd text-center">
      <i class="fal fa-comment-alt-check tx-50 tx-success"></i>
      <h3 class="tx-lato tx-inverse tx-bold mg-b-0 _total">
          <?php echo app_format_money($total_result['paid'], $total_result['currency']); ?>
        </h3>
        <span class="tx-10 tx-uppercase tx-medium mg-b-0 tx-spacing-1"><?php echo _l('paid_proformas'); ?></span>
      </div>
  </div>
</div>
<div class="clearfix"></div>
<script>
  (function () {
    if (typeof (init_selectpicker) == 'function') {
      init_selectpicker();
    }
  })();
</script>
