<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog">
    <?php echo form_open(admin_url('projects/milestone'), array('id' => 'milestone_form')); ?>
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                        aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">
                <span class="edit-title"><?php echo _l('edit_milestone'); ?></span>
                <span class="add-title"><?php echo _l('new_milestone'); ?></span>
            </h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <?php echo form_hidden('project_id', $project->id); ?>
                    <?php if(isset($milestone)){?>
                        <?php echo form_hidden('id', $milestone->id); ?>
                    <?php } ?>
                    <div id="additional_milestone"></div>
                    <?php echo render_input('name', 'milestone_name',$milestone->name); ?>
                    <?php echo render_date_input('due_date', 'milestone_due_date', $milestone->due_date); ?>
                    <?php echo render_textarea('description', 'milestone_description',$milestone->description); ?>
                    <div class="checkbox">
                        <input type="checkbox" id="description_visible_to_customer" <?=($milestone->description_visible_to_customer == 1 ? 'checked' : '')?>
                               name="description_visible_to_customer">
                        <label for="description_visible_to_customer"><?php echo _l('description_visible_to_customer'); ?></label>
                    </div>
                    <?php echo render_input('milestone_order', 'project_milestone_order', $milestone->milestone_order); ?>
                </div>
            </div>
            <div class="row">
                <table class="table dt-table scroll-responsive table-project-files" data-order-col="7" data-order-type="desc">
                    <thead>
                    <tr>
                        <th data-orderable="false"><span class="hide"> - </span>
                            <div class="checkbox mass_select_all_wrap"><input type="checkbox" id="mass_select_all"
                                                                              data-to-table="project-files"><label></label></div>
                        </th>
                        <th><?php echo _l('project_file_filename'); ?></th>
                        <th><?php echo _l('project_file__filetype'); ?></th>
                        <th><?php echo _l('project_discussion_last_activity'); ?></th>
                        <th><?php echo _l('project_discussion_total_comments'); ?></th>
                        <th><?php echo _l('project_file_visible_to_customer'); ?></th>
                        <th><?php echo _l('project_file_uploaded_by'); ?></th>
                        <th><?php echo _l('project_file_dateadded'); ?></th>
                        <th><?php echo _l('options'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($files as $file) {
                        $path = get_upload_path_by_type('project') . $project->id . '/' . $file['file_name'];
                        ?>
                        <tr>
                            <td>
                                <div class="checkbox"><input type="checkbox" value="<?php echo $file['id']; ?>"><label></label></div>
                            </td>
                            <td data-order="<?php echo $file['file_name']; ?>">
                                <a href="#"
                                   onclick="view_project_file(<?php echo $file['id']; ?>,<?php echo $file['project_id']; ?>); return false;">
                                    <?php if (is_image(PROJECT_ATTACHMENTS_FOLDER . $project->id . '/' . $file['file_name']) || (!empty($file['external']) && !empty($file['thumbnail_link']))) {
                                        echo '<div class="text-left"><i class="fal fa-spinner fa-spin mtop30"></i></div>';
                                        echo '<img class="project-file-image img-table-loading" src="#" data-orig="' . project_file_url($file, true) . '" width="100">';
                                        echo '</div>';
                                    }
                                    echo $file['subject']; ?></a>
                            </td>
                            <td data-order="<?php echo $file['filetype']; ?>"><?php echo $file['filetype']; ?></td>
                            <td data-order="<?php echo $file['last_activity']; ?>">
                                <?php
                                if (!is_null($file['last_activity'])) { ?>
                                    <span class="text-has-action" data-toggle="tooltip"
                                          data-title="<?php echo _dt($file['last_activity']); ?>">
              <?php echo time_ago($file['last_activity']); ?>
            </span>
                                <?php } else {
                                    echo _l('project_discussion_no_activity');
                                }
                                ?>
                            </td>
                            <?php $total_file_comments = total_rows(db_prefix() . 'projectdiscussioncomments', array('discussion_id' => $file['id'], 'discussion_type' => 'file')); ?>
                            <td data-order="<?php echo $total_file_comments; ?>">
                                <?php echo $total_file_comments; ?>
                            </td>
                            <td data-order="<?php echo $file['visible_to_customer']; ?>">
                                <?php
                                $checked = '';
                                if ($file['visible_to_customer'] == 1) {
                                    $checked = 'checked';
                                }
                                ?>
                                <div class="onoffswitch">
                                    <input type="checkbox" data-switch-url="<?php echo admin_url(); ?>projects/change_file_visibility"
                                           id="<?php echo $file['id']; ?>" data-id="<?php echo $file['id']; ?>"
                                           class="onoffswitch-checkbox" value="<?php echo $file['id']; ?>" <?php echo $checked; ?>>
                                    <label class="onoffswitch-label" for="<?php echo $file['id']; ?>"></label>
                                </div>

                            </td>
                            <td>
                                <?php if ($file['staffid'] != 0) {
                                    $_data = '<a href="' . admin_url('staff/profile/' . $file['staffid']) . '">' . staff_profile_image($file['staffid'], array(
                                            'staff-profile-image-small'
                                        )) . '</a>';
                                    $_data .= ' <a href="' . admin_url('staff/member/' . $file['staffid']) . '">' . get_staff_full_name($file['staffid']) . '</a>';
                                    echo $_data;
                                } else {
                                    echo ' <img src="' . contact_profile_image_url($file['contact_id'], 'thumb') . '" class="client-profile-image-small mrigh5">
             <a href="' . admin_url('clients/client/' . get_user_id_by_contact_id($file['contact_id']) . '?contactid=' . $file['contact_id']) . '">' . get_contact_full_name($file['contact_id']) . '</a>';
                                }
                                ?>
                            </td>
                            <td data-order="<?php echo $file['dateadded']; ?>"><?php echo _dt($file['dateadded']); ?></td>
                            <td>
                                <?php if (empty($file['external'])) { ?>
                                    <button type="button" data-toggle="modal"
                                            data-original-file-name="<?php echo $file['file_name']; ?>"
                                            data-filetype="<?php echo $file['filetype']; ?>"
                                            data-path="<?php echo PROJECT_ATTACHMENTS_FOLDER . $project->id . '/' . $file['file_name']; ?>"
                                            data-target="#send_file" class="btn btn-info btn-icon"><i class="fal fa-envelope"></i>
                                    </button>
                                <?php } ?>
                                <?php if ($file['staffid'] == get_staff_user_id() || has_permission('projects', '', 'delete')) { ?>
                                    <a href="<?php echo admin_url('projects/remove_file/' . $project->id . '/' . $file['id']); ?>"
                                       class="btn btn-danger btn-icon _delete"><i class="fal fa-remove"></i></a>
                                <?php } ?>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
            <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
        </div>
    </div><!-- /.modal-content -->
    <?php echo form_close(); ?>
</div><!-- /.modal-dialog -->
