<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script>
    var currencies = <?php echo json_encode($currencies); ?>;
    var doc_type = 'proposal';
    var settings = <?= json_encode($settings); ?>;
    var invoice_settings = <?= json_encode($invoice_settings); ?>;
    var doc_rates = {};
</script>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url("proposals"); ?>"><?php echo _l('proposals'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>

    <div class="admin-title">
        <h1><?= $this->config->item('icons')['invoices']; ?><?php echo html_entity_decode($title); ?></h1>

    </div>


    <div class="content accounting-template proposal">
        <div class="row">
            <?php
            if (isset($proposal)) {
                echo form_hidden('isedit', $proposal->id);
            }
            $rel_type = '';
            $rel_id = '';
            if (isset($proposal) || ($this->input->get('rel_id') && $this->input->get('rel_type'))) {
                if ($this->input->get('rel_id')) {
                    $rel_id = $this->input->get('rel_id');
                    $rel_type = $this->input->get('rel_type');
                } else {
                    $rel_id = $proposal->rel_id;
                    $rel_type = $proposal->rel_type;
                }
            }
            ?>
            <?php echo form_open($this->uri->uri_string(), array('id' => 'proposal-form', 'class' => '_transaction_form proposal-form')); ?>
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <?php if (isset($proposal)) { ?>
                                <div class="col-md-12">
                                    <?php echo format_proposal_status($proposal->status); ?>
                                </div>
                                <div class="clearfix"></div>
                                <hr/>
                            <?php } ?>
                            <div class="col-md-6 border-right">
                                <?php $value = (isset($proposal) ? $proposal->subject : ''); ?>
                                <?php $attrs = (isset($proposal) ? array() : array('autofocus' => true)); ?>
                                <?php echo render_input('subject', 'proposal_subject', $value, 'text', $attrs); ?>
                                <div class="form-group select-placeholder">
                                    <label for="rel_type" class="control-label"><?php echo _l('proposal_related'); ?></label>
                                    <select name="rel_type" id="rel_type" class="selectpicker" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                        <option value=""></option>
                                        <option value="lead" <?php if ((isset($proposal) && $proposal->rel_type == 'lead') || $this->input->get('rel_type')) {
                                            if ($rel_type == 'lead') {
                                                echo 'selected';
                                            }
                                        } ?>><?php echo _l('proposal_for_lead'); ?></option>
                                        <option value="customer" <?php if ((isset($proposal) && $proposal->rel_type == 'customer') || $this->input->get('rel_type')) {
                                            if ($rel_type == 'customer') {
                                                echo 'selected';
                                            }
                                        } ?>><?php echo _l('proposal_for_customer'); ?></option>
                                    </select>
                                </div>
                                <div class="form-group select-placeholder<?php if ($rel_id == '') {
                                    echo ' hide';
                                } ?> " id="rel_id_wrapper">
                                    <label for="rel_id"><span class="rel_id_label"></span></label>
                                    <div id="rel_id_select">
                                        <select name="rel_id" id="rel_id" class="ajax-search" data-width="100%" data-live-search="true" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                            <?php if ($rel_id != '' && $rel_type != '') {
                                                $rel_data = get_relation_data($rel_type, $rel_id);
                                                $rel_val = get_relation_values($rel_data, $rel_type);
                                                echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
                                            } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php $value = (isset($proposal) ? _d($proposal->date) : _d(date('Y-m-d'))) ?>
                                        <?php
                                        $date_attrs = array();
                                        $date_attrs['readonly'] = true;
                                        $date_attrs['data-date-end-date'] = "+1d";
                                        ?>
                                        <?php echo render_date_input('date', 'proposal_date', $value, $date_attrs); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php
                                        $value = '';
                                        if (isset($proposal)) {
                                            $value = _d($proposal->open_till);
                                        } else {
                                            if (get_option('proposal_due_after') != 0) {
                                                $value = _d(date('Y-m-d', strtotime('+' . get_option('proposal_due_after') . ' DAY', strtotime(date('Y-m-d')))));
                                            }
                                        }
                                        echo render_date_input('open_till', 'proposal_open_till', $value); ?>
                                    </div>

                                    <div class="col-md-12">


                                        <?php if (isset($proposal)) { ?>
                                            <div class="form-group">
                                                <label for="number">
                                                    <?php echo _l('proposal_add_edit_number'); ?>
                                                    <i class="fal fa-question-circle" data-toggle="tooltip" data-title="<?php echo _l('invoice_number_not_applied_on_draft') ?>" data-placement="top"></i>
                                                </label>
                                                <div class="input-group">
                                        <span class="input-group-addon">
                                        <?php echo strtoupper($proposal->prefix); ?>
                                        </span>
                                                    <input type="text" name="number" class="form-control" value="<?php echo $proposal->number; ?>" disabled>
                                                    <?php if ($proposal->number_format == 3) { ?>
                                                        <span class="input-group-addon">
                                           <span id="prefix_year" class="format-n-yy"><?php echo $yy; ?></span>
                                        </span>
                                                    <?php } else if ($proposal->number_format == 4) { ?>
                                                        <span class="input-group-addon">
                                           <span id="prefix_month" class="format-mm-yyyy"><?php echo $mm; ?></span>
                                           /
                                           <span id="prefix_year" class="format-mm-yyyy"><?php echo $yyyy; ?></span>
                                        </span>
                                                    <?php } ?>
                                                </div>
                                            </div>


                                        <?php } else {

                                            ?>
                                            <label for="number" class="d-block">
                                                <?php echo _l('document_add_edit_number'); ?>
                                            </label>
                                            <?php

                                            echo '<div class="form-group select-wrapper">';
                                            $series = $this->proposals_model->get_series();
                                            $default = $this->proposals_model->get_seria();
                                            $nextnum = ((int)$default['current_number'] + 1);
                                            if (!empty($series)) {
                                                echo '<select name="s_prefix" id="select_seria" class="form-control" style="height: 30px !important; flex: 1;">';
                                                foreach ($series as $key => $value) { ?>
                                                    <option value="<?= $value['name'] ?>" <?= $value['default'] == '1' ? "selected" : ""; ?>>
                                                        <?= strtoupper($value['name']) . ' ' . ((int)$value['current_number'] + 1); ?>
                                                    </option>
                                                <?php }
                                                echo '</select></div>';
                                            }
                                        }

                                        ?>


                                    </div>


                                </div>
                                <?php
                                $selected = '';
                                $currency_attr = array('data-show-subtext' => true);
                                foreach ($currencies as $currency) {
                                    if ($currency['isdefault'] == 1) {
                                        $currency_attr['data-base'] = $currency['id'];
                                    }
                                    if (isset($proposal)) {
                                        if ($currency['id'] == $proposal->currency) {
                                            $selected = $currency['id'];
                                        }
                                        if ($proposal->rel_type == 'customer') {
                                            // Removed the disabled condition for now
                                            //$currency_attr['disabled'] = true;
                                        }
                                    } else {
                                        if ($rel_type == 'customer') {
                                            $customer_currency = $this->clients_model->get_customer_default_currency($rel_id);
                                            if ($customer_currency != 0) {
                                                $selected = $customer_currency;
                                            } else {
                                                if ($currency['isdefault'] == 1) {
                                                    $selected = $currency['id'];
                                                }
                                            }
                                            $currency_attr['disabled'] = true;
                                        } else {
                                            if ($currency['isdefault'] == 1) {
                                                $selected = $currency['id'];
                                            }
                                        }
                                    }
                                }
                                $currency_attr = apply_filters_deprecated('proposal_currency_disabled', [$currency_attr], '2.3.0', 'proposal_currency_attributes');
                                $currency_attr = hooks()->apply_filters('proposal_currency_attributes', $currency_attr);
                                ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php
                                        echo render_select('currency', $currencies, array('id', 'name', 'symbol'), 'proposal_currency', $selected, $currency_attr);
                                        ?>
                                    </div>
                                    <div class="col-md-6">

                                        <div class="form-group select-placeholder">
                                            <label for="discount_type" class="control-label"><?php echo _l('discount_type'); ?></label>
                                            <select name="discount_type" class="selectpicker" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                                <option value="" selected><?php echo _l('no_discount'); ?></option>
                                                <option value="before_tax" <?php
                                                if (isset($estimate)) {
                                                    if ($estimate->discount_type == 'before_tax') {
                                                        echo 'selected';
                                                    }
                                                } ?>><?php echo _l('discount_type_before_tax'); ?></option>
                                                <option value="after_tax" <?php if (isset($estimate)) {
                                                    if ($estimate->discount_type == 'after_tax') {
                                                        echo 'selected';
                                                    }
                                                } ?>><?php echo _l('discount_type_after_tax'); ?></option>
                                            </select>
                                        </div>

                                    </div>
                                </div>
                                <?php $fc_rel_id = (isset($proposal) ? $proposal->id : false); ?>
                                <?php echo render_custom_fields('proposal', $fc_rel_id); ?>
                                <div class="form-group no-mbot">
                                    <label for="tags" class="control-label"><i class="fal fa-tag" aria-hidden="true"></i> <?php echo _l('tags'); ?>
                                    </label>
                                    <input type="text" class="tagsinput" id="tags" name="tags" value="<?php echo(isset($proposal) ? prep_tags_input(get_tags_in($proposal->id, 'proposal')) : ''); ?>" data-role="tagsinput">
                                </div>
                                <div class="form-group mtop10 no-mbot">
                                    <p><?php echo _l('proposal_allow_comments'); ?></p>
                                    <div class="onoffswitch">
                                        <input type="checkbox" id="allow_comments" class="onoffswitch-checkbox" <?php if ((isset($proposal) && $proposal->allow_comments == 1) || !isset($proposal)) {
                                            echo 'checked';
                                        }; ?> value="on" name="allow_comments">
                                        <label class="onoffswitch-label" for="allow_comments" data-toggle="tooltip" title="<?php echo _l('proposal_allow_comments_help'); ?>"></label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group select-placeholder">
                                            <label for="status" class="control-label"><?php echo _l('proposal_status'); ?></label>
                                            <?php
                                            $disabled = '';
                                            if (isset($proposal)) {
                                                if ($proposal->estimate_id != NULL || $proposal->invoice_id != NULL) {
                                                    $disabled = 'disabled';
                                                }
                                            }
                                            ?>
                                            <select name="status" class="selectpicker" data-width="100%" <?php echo $disabled; ?> data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                                                <?php foreach ($statuses as $status) { ?>
                                                    <option value="<?php echo $status; ?>" <?php if ((isset($proposal) && $proposal->status == $status) || (!isset($proposal) && $status == 0)) {
                                                        echo 'selected';
                                                    } ?>><?php echo format_proposal_status($status, '', false); ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <?php
                                        $i = 0;
                                        $selected = '';
                                        foreach ($staff as $member) {
                                            if (isset($proposal)) {
                                                if ($proposal->assigned == $member['staffid']) {
                                                    $selected = $member['staffid'];
                                                }
                                            }
                                            $i++;
                                        }
                                        echo render_select('assigned', $staff, array('staffid', array('firstname', 'lastname')), 'proposal_assigned', $selected);
                                        ?>
                                    </div>
                                </div>
                                <?php $value = (isset($proposal) ? $proposal->proposal_to : ''); ?>
                                <?php echo render_input('proposal_to', 'proposal_to', $value); ?>
                                <?php $value = (isset($proposal) ? $proposal->address : ''); ?>
                                <?php echo render_textarea('address', 'proposal_address', $value); ?>
                                <div class="row">
                                    <div class="col-md-6">
                                        <?php $countries = get_all_countries(); ?>
                                        <?php $selected_country = (isset($proposal) ? $proposal->country : ''); ?>
                                        <?php echo render_select('country', $countries, array('country_id', array('short_name'), 'iso2'), 'billing_country', $selected_country, array('data-none-selected-text' => _l('dropdown_non_selected_tex'), 'onchange' => 'get_bcountry_states(this);')); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php //$value = (isset($proposal) ? $proposal->state : ''); ?>
                                        <?php //echo render_input('state','billing_state',$value);

                                        $states = get_all_states($selected_country);
                                        $selected = (isset($proposal) ? $proposal->state : 0);
                                        echo render_select('state', $states, array('state_id', array('short_name'), 'short_name'), 'state', $selected, array('data-none-selected-text' => _l('dropdown_non_selected_tex')));

                                        ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php $value = (isset($proposal) ? $proposal->city : ''); ?>
                                        <?php echo render_input('city', 'billing_city', $value); ?>
                                    </div>


                                    <div class="col-md-6">
                                        <?php $value = (isset($proposal) ? $proposal->zip : ''); ?>
                                        <?php echo render_input('zip', 'billing_zip', $value); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php $value = (isset($proposal) ? $proposal->email : ''); ?>
                                        <?php echo render_input('email', 'proposal_email', $value); ?>
                                    </div>
                                    <div class="col-md-6">
                                        <?php $value = (isset($proposal) ? $proposal->phone : ''); ?>
                                        <?php echo render_input('phone', 'proposal_phone', $value); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="btn-bottom-toolbar bottom-transaction text-right">
                            <p class="pull-left btn-toolbar-notice"><?php echo _l('include_proposal_items_merge_field_help', '<b>{proposal_items}</b>'); ?></p>
                            <button type="button" class="btn btn-info mleft10 proposal-form-submit save-and-send transaction-submit invoiceSave">
                                <?php echo _l('save_and_send'); ?>
                            </button>
                            <button class="btn btn-info mleft5 proposal-form-submit transaction-submit invoiceSave" type="button">
                                <?php echo _l('submit'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="panel_s">
                    <?php $this->load->view('admin/estimates/_add_edit_items', ['docType' => 'proforma']); ?>
                </div>
            </div>
            <?php echo form_close(); ?>
            <?php $this->load->view('admin/invoice_items/item'); ?>
        </div>
        <div class="btn-bottom-pusher"></div>
    </div>

</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    var _rel_id = $('#rel_id'),
        _rel_type = $('#rel_type'),
        _rel_id_wrapper = $('#rel_id_wrapper'),
        data = {};

    $(function () {
        init_currency();
        // Maybe items ajax search
        init_ajax_search('items', '#item_select.ajax-search', undefined, admin_url + 'items/search');
        validate_proposal_form();
        $('body').on('change', '#rel_id', function () {
            if ($(this).val() != '') {
                $.get(admin_url + 'proposals/get_relation_data_values/' + $(this).val() + '/' + _rel_type.val(), function (response) {
                    $('input[name="proposal_to"]').val(response.to);
                    $('textarea[name="address"]').val(response.address);
                    $('input[name="email"]').val(response.email);
                    $('input[name="phone"]').val(response.phone);
                    $('input[name="city"]').val(response.city);
                    $('input[name="state"]').val(response.state);
                    $('input[name="zip"]').val(response.zip);
                    $('select[name="country"]').selectpicker('val', response.country);
                    var currency_selector = $('#currency');
                    if (_rel_type.val() == 'customer') {
                        if (typeof (currency_selector.attr('multi-currency')) == 'undefined') {
                            //currency_selector.attr('disabled',true);
                        }

                    } else {
                        currency_selector.attr('disabled', false);
                    }
                    var proposal_to_wrapper = $('[app-field-wrapper="proposal_to"]');
                    if (response.is_using_company == false && !empty(response.company)) {
                        proposal_to_wrapper.find('#use_company_name').remove();
                        proposal_to_wrapper.find('#use_company_help').remove();
                        proposal_to_wrapper.append('<div id="use_company_help" class="hide">' + response.company + '</div>');
                        proposal_to_wrapper.find('label')
                            .prepend("<a href=\"#\" id=\"use_company_name\" data-toggle=\"tooltip\" data-title=\"<?php echo _l('use_company_name_instead'); ?>\" onclick='document.getElementById(\"proposal_to\").value = document.getElementById(\"use_company_help\").innerHTML.trim(); this.remove();'><i class=\"fal fa-building\"></i></a> ");
                    } else {
                        proposal_to_wrapper.find('label #use_company_name').remove();
                        proposal_to_wrapper.find('label #use_company_help').remove();
                    }
                    /* Check if customer default currency is passed */
                    if (response.currency) {
                        currency_selector.selectpicker('val', response.currency);
                    } else {
                        /* Revert back to base currency */
                        currency_selector.selectpicker('val', currency_selector.data('base'));
                    }
                    currency_selector.selectpicker('refresh');
                    currency_selector.change();
                }, 'json');
            }
        });
        $('.rel_id_label').html(_rel_type.find('option:selected').text());
        _rel_type.on('change', function () {
            var clonedSelect = _rel_id.html('').clone();
            _rel_id.selectpicker('destroy').remove();
            _rel_id = clonedSelect;
            $('#rel_id_select').append(clonedSelect);
            proposal_rel_id_select();
            if ($(this).val() != '') {
                _rel_id_wrapper.removeClass('hide');
            } else {
                _rel_id_wrapper.addClass('hide');
            }
            $('.rel_id_label').html(_rel_type.find('option:selected').text());
        });
        proposal_rel_id_select();
        <?php if(!isset($proposal) && $rel_id != ''){ ?>
        _rel_id.change();
        <?php } ?>
    });

    function proposal_rel_id_select() {
        var serverData = {};
        serverData.rel_id = _rel_id.val();
        data.type = _rel_type.val();
        init_ajax_search(_rel_type.val(), _rel_id, serverData);
    }

    function validate_proposal_form() {
        appValidateForm($('#proposal-form'), {
            subject: 'required',
            proposal_to: 'required',
            rel_type: 'required',
            rel_id: 'required',
            date: 'required',
            email: {
                email: true,
                required: true
            },
            currency: 'required',
        });
    }


    function get_bcountry_states(el, state_id_selected = false) {
        $.post(admin_url + 'misc/get_country_states/' + $(el).val()).done(function (response) {
            response = JSON.parse(response);
            if (response.success == true) {
                $('select[name="state"]').html(response.html);
                if (state_id_selected) {
                    $('select[name=state]').val(state_id_selected);
                }
                $('select[name="state"]').selectpicker('refresh');

            }
        });
    }

    $(document).ready(function () {
        var billing_country = $('#country');
        var state_id_selected = $('#state').val();
        get_bcountry_states(billing_country, state_id_selected);
    });
</script>
</body>
</html>
