<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['sales']; ?><?php echo html_entity_decode($title); ?></h1>
    </div>

    <div class="content">
        <div class="row">
            <div class="col-md-7">
                <div class="panel_s">
                    <div class="panel-body">
                        <?php if (isset($sales_kpi_category)) { ?>
                            <a href="<?php echo admin_url('sales_kpi_categories/sales_kpi_category'); ?>" class="btn btn-success pull-right mbot20 display-block"><?php echo _l('new_sales_kpi'); ?></a>
                            <div class="clearfix"></div>
                        <?php } ?>
                        <?php echo form_open($this->uri->uri_string()); ?>
                        <?php $attrs = (isset($sales_kpi_category) ? array() : array('autofocus' => true)); ?>
                        <?php $value = (isset($sales_kpi_category) ? $sales_kpi_category->name : ''); ?>
                        <?php $kpi = (isset($sales_kpi_category) ? $sales_kpi_category->kpi : ''); ?>
                        <?php echo render_input('name', 'sales_kpi_add_edit_name', $value, 'text', $attrs); ?>
                        <?php echo render_input('kpi', 'sales_kpi_add_edit_kpi', $kpi, 'text'); ?>
                        <hr/>
                        <button type="submit" class="btn btn-info pull-right"><?php echo _l('submit'); ?></button>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <?php show_footer(); ?><?php init_tail(); ?>
    <script>
        $(function () {
            appValidateForm($('form'), {name: 'required'});
        });
    </script>
    </body>
    </html>
