<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php hooks()->do_action('before_opportunities_settings'); ?>
<?php echo form_hidden('settings[_opportunities_settings]', 'true'); ?>
<?php echo render_input('settings[opportunities_kanban_limit]', 'settings_opportunities_kanban_limit', get_option('opportunities_kanban_limit'), 'number'); ?>
<hr/>
<?php
foreach ($opportunity_statuses as $subKey => $subArray) {
    $opportunity_statuses[$subKey]['name'] = _l($subArray['name']);
    if ($subArray['isdefault'] == '1') {
        unset($opportunity_statuses[$subKey]);
    }
}
echo render_select('settings[opportunities_default_status]', $opportunity_statuses, array('id', 'name'), 'opportunities_default_status', get_option('opportunities_default_status')); ?>
<hr/>
<?php render_yes_no_option('allow_non_admin_members_to_import_opportunities', 'allow_non_admin_members_to_import_opportunities'); ?>
<hr/>
<div class="row">
    <div class="col-md-7">
        <label for="default_opportunities_kanban_sort" class="control-label"><?php echo _l('default_opportunities_kanban_sort'); ?></label>
        <select name="settings[default_opportunities_kanban_sort]" id="default_opportunities_kanban_sort" class="selectpicker" data-width="100%" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
            <option value="dateadded" <?php if (get_option('default_opportunities_kanban_sort') == 'dateadded') {
                echo 'selected';
            } ?>><?php echo _l('opportunities_sort_by_datecreated'); ?></option>
            <option value="leadorder" <?php if (get_option('default_opportunities_kanban_sort') == 'leadorder') {
                echo 'selected';
            } ?>><?php echo _l('opportunities_sort_by_kanban_order'); ?></option>
            <option value="lastcontact" <?php if (get_option('default_opportunities_kanban_sort') == 'lastcontact') {
                echo 'selected';
            } ?>><?php echo _l('opportunities_sort_by_lastcontact'); ?></option>
        </select>
    </div>
    <div class="col-md-5">
        <div class="mtop30 text-right">
            <div class="radio radio-inline radio-primary">
                <input type="radio" id="k_desc" name="settings[default_opportunities_kanban_sort_type]" value="asc" <?php if (get_option('default_opportunities_kanban_sort_type') == 'asc') {
                    echo 'checked';
                } ?>>
                <label for="k_desc"><?php echo _l('order_ascending'); ?></label>
            </div>
            <div class="radio radio-inline radio-primary">
                <input type="radio" id="k_asc" name="settings[default_opportunities_kanban_sort_type]" value="desc" <?php if (get_option('default_opportunities_kanban_sort_type') == 'desc') {
                    echo 'checked';
                } ?>>
                <label for="k_asc"><?php echo _l('order_descending'); ?></label>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
</div>
<?php hooks()->do_action('after_opportunities_settings'); ?>
