<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'price',
    'price_buy',
    'price_buy_tax',
    'tblproduct_categ.name as categ',
    'weight',
    'valabilitate1',
    'valabilitate2',
    'stoc',
    'delivery',
    'tblsuppliers.name as supplier',
    ];

$sIndexColumn = 'id';
$sTable       = 'tblproduct';
$join = [
    'LEFT JOIN tblsuppliers on tblsuppliers.userid = tblproduct.supplier_id',
    'LEFT JOIN tblproduct_categ on tblproduct_categ.id = tblproduct.categ_id',
];
$where = [];
if (isset($_GET['client_id'])) {
    array_push($where, "AND client_id = {$_GET['client_id']}");
}
if ($this->ci->input->post('name')) {
    array_push($where, "AND tblproduct.name  LIKE '%".$this->ci->input->post('name')."%'");
}
if ($this->ci->input->post('price')) {
    array_push($where, 'AND price ="' . $this->ci->input->post('price').'"');
}
if ($this->ci->input->post('price_buy')) {
    array_push($where, 'AND price_buy ="' . $this->ci->input->post('price_buy').'"');
}
if ($this->ci->input->post('categ')) {
    array_push($where, 'AND tblproduct.categ_id =' . $this->ci->input->post('categ'));
}
if ($this->ci->input->post('valabilitate1')) {
    array_push($where, 'AND valabilitate1 ="' . $this->ci->input->post('valabilitate1').'"');
}
if ($this->ci->input->post('valabilitate2')) {
    array_push($where, 'AND valabilitate2 ="' . $this->ci->input->post('valabilitate2').'"');
}
if ($this->ci->input->post('stoc')) {
    array_push($where, 'AND stoc ="' . $this->ci->input->post('stoc').'"');
}
if ($this->ci->input->post('delivery')) {
    array_push($where, 'AND delivery ="' . $this->ci->input->post('delivery').'"');
}
if ($this->ci->input->post('supplier_id')) {
    array_push($where, 'AND supplier_id =' . $this->ci->input->post('supplier_id'));
}

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, ['tblproduct.id','tblproduct.name as name']);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    $row[] = '<div class="checkbox"><input type="checkbox" value="' . $aRow['id'] . '"><label></label></div>';
    //$row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['id'] . '</a>';
    $row[] = $aRow['id'];
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['name'] . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . number_format((float)$aRow['price_buy'],2,'.','') . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . number_format((float)$aRow['price_buy_tax'],2,'.','') . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['price'] . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['categ'] . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . _d($aRow['valabilitate1']) . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . _d($aRow['valabilitate2']) . '</a>';
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['stoc'] . '</a>';
    //$row[] = $aRow['stoc'];
    $row[] = '<a href="' . admin_url('hpyproducts/produs/' . $aRow['id']) . '" class="mbot10 display-block">' . $aRow['supplier'] . '</a>';

    $options = icon_btn('hpyproducts/produs/' . $aRow['id'], 'pencil-square-o');
    $row[]   = $options .= icon_btn('hpyproducts/sterge/' . $aRow['id'], 'times', 'btn-danger _delete');

    $output['aaData'][] = $row;
}
