<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    db_prefix() . 'items_categories.name',
    'COUNT(DISTINCT subcategories.id)',
    'COUNT(DISTINCT items.id)',
    db_prefix() . 'items_categories.description',
];
$sIndexColumn = 'id';
$sTable       = db_prefix().'items_categories';

$join         = [
    'LEFT JOIN ' . db_prefix() . 'items_categories as subcategories ON ' . db_prefix() . 'items_categories.id=subcategories.parent_id',
    'LEFT JOIN ' . db_prefix() . 'items as items ON ' . db_prefix() . 'items_categories.id=items.category_id',
];
$where = [];

if (isset($_GET['parent_id'])) {
    array_push($where, "AND " . db_prefix() . "items_categories.parent_id =  {$_GET['parent_id']}");
}else{
    array_push($where, "AND " . db_prefix() . "items_categories.parent_id =  0");
}

$sGroupBy     = 'GROUP BY '.db_prefix() . 'items_categories.id';

$result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [db_prefix() . 'items_categories.id' , db_prefix() . 'items_categories.parent_id'] , $sGroupBy);
$output  = $result['output'];
$rResult = $result['rResult'];
foreach ($rResult as $aRow) {
    $row = [];
    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == 'name') {
            $_data = '<a href="#" onclick="edit_category(this,' . $aRow['id'] . '); return false;" data-name="' . $aRow['name'] . '" data-description="' . clear_textarea_breaks($aRow['description']) . '">' . $_data . '</a>';
        }elseif ($aColumns[$i] == 'COUNT(DISTINCT subcategories.id)'){
            $_data = '<a href="'.admin_url('purchase/categories?parent_id='.$aRow['id'].'').'">' . $_data . '</a>';
        }

        $row[] = $_data;
    }

    $options = icon_btn('#', 'pencil-square-o', 'btn-default', [
        'onclick'           => 'edit_category(this,' . $aRow['id'] . '); return false;',
        'data-name'         => $aRow[db_prefix() . 'items_categories.name'],
        'data-description'  => clear_textarea_breaks($aRow[db_prefix() . 'items_categories.description']),
        'data-parent'       => $aRow['parent_id'],
    ]);
    if($aRow['COUNT(DISTINCT subcategories.id)'] == 0){
        $row[]              = $options .= icon_btn('purchase/delete_category/' . $aRow['id'], 'remove', 'btn-danger _delete');
    }else{
        $row[]              = $options .= icon_btn('purchase/delete_category/' . $aRow['id'], 'remove', 'btn-danger _delete disabled');
    }

    $output['aaData'][] = $row;
}
