<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'name',
    'kpi',
    ];

$sIndexColumn = 'id';
$sTable       = db_prefix().'sales_kpi_category';

$result  = data_tables_init($aColumns, $sIndexColumn, $sTable, [], [], ['id']);
$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];
    for ($i = 0; $i < count($aColumns); $i++) {
        $_data = $aRow[$aColumns[$i]];
        if ($aColumns[$i] == 'name') {
            $_data            = '<a href="' . admin_url('sales_kpi_categories/sales_kpi_category/' . $aRow['id']) . '" class="mbot10 display-block">' . $_data . '</a>';
            $_data .= '<span class="mtop10 display-block">' . _l('sales_kpi_categories_total_users') . ' ' . total_rows(db_prefix().'staff', [
                'sales_kpi_category' => $aRow['id'],
                ]) . '</span>';
        }
        $row[] = $_data;
    }

    $options = icon_btn('sales_kpi_categories/sales_kpi_category/' . $aRow['id'], 'pencil-square-o');
    $row[]   = $options .= icon_btn('sales_kpi_categories/delete/' . $aRow['id'], 'remove', 'btn-danger _delete');

    $output['aaData'][] = $row;
}
