<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php
$actual_link = getUrlForMenu();
?>
<nav class="navbar navbar-default header web-gradient">
    <div class="container">

        <div class="row">
            <div class="col-md-2 col-sm-6">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                            data-target="#theme-navbar-collapse" aria-expanded="false">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <?php get_company_logo('', 'navbar-brand logo', 'dark'); ?>
                </div>

            </div>

            <div class="col-md-2 col-lg-3 p-0 col-sm-6">
                <div class="search-box-inner">
                    <input type="text" class="search-field search-field-input" name="search_data" placeholder="<?php echo _l('search_product_here');?>">
                    <div class="ad-search-content-holder"></div>
                </div>
            </div>

            <div class="col-md-8 col-lg-7 p-0">
                <!-- Collect the nav links, forms, and other content for toggling -->
                <div class="collapse navbar-collapse pl-0" id="theme-navbar-collapse">

                    <ul class="nav nav-effect flex-column flex-lg-row navbar-nav navbar-right">

                        <?php if (is_client_logged_in()) { ?>
                            <li class="nav-item customers-nav-item-knowledge-base">
                                <a class="nav-link " href="<?php echo base_url(); ?>"><?= _l('home_page'); ?></a>
                            </li>
                        <?php } ?>

                        <?php hooks()->do_action('customers_navigation_start'); ?>

                        <?php foreach ($menu as $item_id => $item) { ?>
                            <li class="nav-item customers-nav-item-<?= $item_id; ?>"
                                <?= _attributes_to_string(isset($item['li_attributes']) ? $item['li_attributes'] : []); ?>>
                                <a class="nav-link <?= ($actual_link == $item['href']) ? 'active' : '' ?>"
                                   href="<?= $item['href']; ?>"
                                    <?= _attributes_to_string(isset($item['href_attributes']) ? $item['href_attributes'] : []); ?>>
                                    <?php
                                    if (!empty($item['icon'])) {
                                        echo '<i class="' . $item['icon'] . '"></i> ';
                                    }
                                    echo $item['name'];
                                    ?>
                                </a>
                            </li>
                        <?php } ?>


                        <?php if (is_client_logged_in()) { ?>
                            <li class="dropdown">
                                <a href="#" class="text-center dropdown-toggle" data-toggle="dropdown" role="button"
                                   aria-haspopup="true" aria-expanded="false">
                                    <?= _l('commercial') ?>
                                    <span class="fa-thin fa-caret-down"></span>
                                </a>
                                <ul class="dropdown-menu animated fadeIn">
                                    <?php hooks()->do_action('customers_commercial_menu'); ?>
                                </ul>
                            </li>
                        <?php } ?>

                        <?php if (is_client_logged_in()) { ?>
                            <li class="dropdown">
                                <a href="#" class="text-center dropdown-toggle" data-toggle="dropdown" role="button"
                                   aria-haspopup="true" aria-expanded="false">
                                    <?= _l('support_and_resources') ?>
                                    <span class="fa-thin fa-caret-down"></span>
                                </a>
                                <ul class="dropdown-menu animated fadeIn">
                                    <?php if (is_client_logged_in()) { ?>
                                        <li class="customers-nav-item-announcements">
                                            <a href="<?= site_url('clients/announcements'); ?>">
                                                <?= _l('announcements'); ?>
                                                <?php if ($total_undismissed_announcements != 0) { ?>
                                                    <span class="badge"><?= $total_undismissed_announcements; ?></span>
                                                <?php } ?>
                                            </a>
                                        </li>
                                    <?php } ?>

                                    <?php hooks()->do_action('customers_navigation_support'); ?>


                                </ul>
                            </li>
                        <?php } ?>

                        <?php if (is_client_logged_in()) { ?>
                            <?php hooks()->do_action('customers_navigation_end'); ?>
                        <?php } ?>

                        <?php if (is_client_logged_in()) { ?>
                            <li class="dropdown customers-nav-item-profile">
                                <a href="#" class="text-center dropdown-toggle" data-toggle="dropdown" role="button"
                                   aria-haspopup="true" aria-expanded="false">
                                    <img src="<?= contact_profile_image_url($contact->id,
                                        'thumb'); ?>" data-toggle="tooltip"
                                         data-title="<?= html_escape($contact->firstname . ' ' . $contact->lastname); ?>"
                                         data-placement="bottom" class="client-profile-image-small mright5">
                                    <span class="fa-thin fa-caret-down"></span>
                                </a>
                                <ul class="dropdown-menu animated fadeIn">
                                    <div class="img-header">
                                        <a href="<?= site_url('clients/profile'); ?>" class="dropdown-toggle profile"
                                           data-toggle="dropdown" aria-expanded="false">
                                            <img src="<?= contact_profile_image_url($contact->id, 'thumb'); ?>"
                                                 class="img img-responsive text-center imagine-profil-header X-staff-profile-image-big">
                                        </a>
                                    </div>
                                    <div class="clearfix"></div>
                                    <div class="text-center nume-header">
                                        <?= html_escape($contact->firstname . ' ' . $contact->lastname); ?>
                                    </div>
                                    <div class="text-center email-header">
                                        <?= html_escape($contact->email); ?>
                                    </div>
                                    <div class="col-md-12">
                                        <hr>
                                    </div>
                                    <li class="customers-nav-item-edit-profile">
                                        <a class="li-header" href="<?php echo site_url('clients/files'); ?>">
                                            <i class="fal fa-file"
                                               aria-hidden="true"></i> <?= _l('customer_profile_files'); ?>
                                        </a>
                                    </li>
                                    <li class="customers-nav-item-edit-profile">
                                        <a class="li-header" href="<?php echo site_url('clients/calendar'); ?>">
                                            <i class="fal fa-calendar-minus-o"
                                               aria-hidden="true"></i> <?= _l('calendar'); ?>
                                        </a>
                                    </li>
                                    <div class="col-md-12">
                                        <hr>
                                    </div>

                                    <li class="customers-nav-item-edit-profile">
                                        <a class="li-header" href="<?= site_url('clients/profile'); ?>">
                                            <i class="icon ion-ios-person icon-color"></i> <?= _l('clients_nav_profile'); ?>
                                        </a>
                                    </li>
                                    <?php if ($contact->is_primary == 1) { ?>
                                        <?php if (can_loggged_in_user_manage_contacts()) { ?>
                                            <li class="customers-nav-item-edit-profile">
                                                <a class="li-header" href="<?= site_url('contacts'); ?>">
                                                    <i class="fal fa-commenting-o icon-color"
                                                       aria-hidden="true"></i> <?= _l('clients_nav_contacts'); ?>
                                                </a>
                                            </li>
                                        <?php } ?>
                                        <li class="customers-nav-item-company-info">
                                            <a class="li-header" href="<?= site_url('clients/company'); ?>">
                                                <i class="fal fa-building icon-color"
                                                   aria-hidden="true"></i> <?= _l('client_company_info'); ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                    <?php if (can_logged_in_contact_update_credit_card()) { ?>
                                        <li class="customers-nav-item-stripe-card">
                                            <a class="li-header" href="<?= site_url('clients/credit_card'); ?>">
                                                <i class="fal fa-credit-card icon-color"
                                                   aria-hidden="true"></i><?= _l('credit_card'); ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                    <?php if (is_gdpr() && get_option('show_gdpr_in_customers_menu') == '1') { ?>
                                        <li class="customers-nav-item-announcements">
                                            <a class="li-header" href="<?= site_url('clients/gdpr'); ?>">
                                                <i class="fal fa-id-card icon-color"
                                                   aria-hidden="true"></i> <?= _l('gdpr_short'); ?>
                                            </a>
                                        </li>
                                    <?php } ?>

                                    <?php if (!is_language_disabled()) {
                                        ?>
                                        <li class="dropdown-submenu customers-nav-item-languages">
                                            <a class="li-header" href="#" tabindex="-1">
                                                <i class="fal fa-language icon-color"
                                                   aria-hidden="true"></i> <?= _l('language'); ?>
                                            </a>
                                            <ul class="dropdown-menu dropdown-menu-left">
                                                <li class="<?php if (get_contact_language() == "") {
                                                    echo 'active';
                                                } ?>">
                                                    <a href="<?= site_url('clients/change_language'); ?>">
                                                        <?= _l('system_default_string'); ?>
                                                    </a>
                                                </li>
                                                <?php foreach ($this->app->get_available_languages() as $user_lang) { ?>
                                                    <li <?php if (get_contact_language() == $user_lang) {
                                                        echo 'class="active"';
                                                    } ?>>
                                                        <a href="<?= site_url('clients/change_language/' . $user_lang); ?>">
                                                            <?= ucfirst($user_lang); ?>
                                                        </a>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </li>
                                    <?php } ?>
                                    <li class="customers-nav-item-logout">
                                        <a class="li-header" href="<?= site_url('authentication/logout'); ?>">
                                            <i class="icon ion-power icon-color"></i> <?= _l('clients_nav_logout'); ?>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>

                        <?php hooks()->do_action('customers_navigation_after_profile'); ?>
                    </ul>
                </div>
                <!-- /.navbar-collapse -->

            </div>
        </div>


    </div>


    <!-- /.container-fluid -->
</nav>

<script>
    var base_url =  "<?php echo base_url(); ?>";
    $(document).on('keyup', '.search-field-input', (function(e){
        $_this = $(this);
        var cod = e.keyCode || e.which;
        var holderContent = $(this).parent().find('.ad-search-content-holder');
        var contents = holderContent.children('div');
        var search_spin = $(this).parent().find('.search-spin');

        if($_this.val().length > 2) {
            $.post(base_url+'omni_sales/omni_sales_client/search/',{search_data:$_this.val()}, function(result){
                result = $.parseJSON(result);
                if(result.error === 0 && result.html.length>0) {
                    $_this.removeClass('error');
                    holderContent.removeClass('d-none').html(result.html);
                    search_spin.addClass('d-none');
                } else if (result.error === 1){
                    $_this.addClass('error');
                    holderContent.html('').addClass('d-none');
                    search_spin.addClass('d-none');
                } else {
                    holderContent.removeClass('d-none').html('<div class="select-ad-search-option"></div>');
                    search_spin.addClass('d-none');
                }
            });
        } else {
            holderContent.removeClass('d-none').html('<div><div class="text-center"><?php echo _l('minimum_three_characters_for_search'); ?></div></div>');
        }

        $_iS = 0;

    }));
    $(document).on('click', '.select-ad-search-option', function(){
        if ($(this).data('e')) {window.location.href = base_url+$(this).data('e');}
    });
</script>
