<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s">
    <div class="panel-body">
        <h4 class="no-margin section-text"><?php echo _l('proformas'); ?></h4>
    </div>
    <div class="panel-body">
        <table class="table dt-table table-invoices" data-order-col="1" data-order-type="desc">
            <thead>
            <tr>
                <th class="th-proformas-number"><?php echo _l('clients_proformas_dt_number'); ?></th>
                <th class="th-proformas-date"><?php echo _l('clients_proformas_dt_date'); ?></th>
                <th class="th-proformas-status"><?php echo _l('clients_proformas_dt_status'); ?></th>
                <th class="th-proformas-company"><?php echo _l('clients_proformas_dt_company'); ?></th>
                <th class="th-proformas-amount"><?php echo _l('clients_proformas_dt_amount'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($invoices as $invoice) { ?>
                <tr>
                    <td data-order="<?php echo $invoice['number']; ?>"><a
                                href="<?php echo site_url('proforma/' . $invoice['id'] . '/' . $invoice['hash']); ?>"
                                class="invoice-number"><?php echo format_credit_note_number($invoice['id']); ?></a></td>
                    <td data-order="<?php echo $invoice['date']; ?>"><?php echo _d($invoice['date']); ?></td>
                    <td><?php echo format_proforma_status_portal($invoice['status']); ?></td>
                    <td data-order="<?php echo $invoice['client']->company; ?>"><?php echo $invoice['client']->company; ?></td>
                    <td data-order="<?php echo $invoice['total']; ?>"><?php echo app_format_money($invoice['total'], $invoice['currency_name']); ?></td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
    </div>
</div>
