<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="mtop15 preview-top-wrapper">
   <div class="row">
      <div class="col-md-3">
         <div class="mbot30">
            <div class="invoice-html-logo">
               <?php echo get_company_logo(); ?>
            </div>
         </div>
      </div>
      <div class="clearfix"></div>
   </div>
   <div class="top" data-sticky data-sticky-class="preview-sticky-header">
      <div class="container preview-sticky-container">
         <div class="row">
            <div class="col-md-12">
               <div class="pull-left">
                  <h3 class="bold no-mtop invoice-html-number no-mbot">
                     <span class="sticky-visible hide">
                        <?php echo format_invoice_number($invoice->id); ?>
                     </span>
                  </h3>
                  <h4 class="invoice-html-status mtop7">
                     <?php echo format_credit_note_status($invoice->status);  ?>
                  </h4>
               </div>
               <div class="visible-xs">
                  <div class="clearfix"></div>
               </div>


               <?php if (is_client_logged_in() && has_contact_permission('invoices')) { ?>
                  <a href="<?php echo site_url('clients/credit_notes/'); ?>" class="btn btn-default pull-right mtop5 mright5 action-button go-to-portal">
                     <?php echo _l('client_go_to_credit_notes'); ?>
                  </a>
               <?php } ?>
               <div class="clearfix"></div>
            </div>
         </div>
      </div>
   </div>
</div>
<div class="clearfix"></div>
<div class="panel_s mtop20">
   <div class="panel-body">
      <div class="col-md-10 col-md-offset-1">
         <div class="row mtop20">
            <div class="col-md-6 col-sm-6 transaction-html-info-col-left">
               <h4 class="bold invoice-html-number"><?php echo _l('view_storno_invoice'); ?></h4>
               <h4 class="bold invoice-html-number"><?php echo format_credit_note_number($invoice->id); ?></h4>
               <address class="invoice-html-company-info">
                  <?php echo format_organization_invoicing_info(); ?>
               </address>
            </div>
            <div class="col-sm-6 text-right transaction-html-info-col-right">
               <span class="bold invoice-html-bill-to"><?php echo _l('invoice_bill_to'); ?>:</span>
               <address class="invoice-html-customer-billing-info">
                  <?php echo format_customer_info($invoice, 'invoice', 'billing'); ?>
               </address>
               <p class="no-mbot invoice-html-date">
                  <span class="bold">
                     <?php echo _l('invoice_data_date'); ?>
                  </span>
                  <?php echo _d($invoice->date); ?>
               </p>
               <?php if (!empty($invoice->duedate)) { ?>
                  <p class="no-mbot invoice-html-duedate">
                     <span class="bold"><?php echo _l('invoice_data_duedate'); ?></span>
                     <?php echo _d($invoice->duedate); ?>
                  </p>
               <?php } ?>

               <?php if ($invoice->project_id != 0 && get_option('show_project_on_invoice') == 1) { ?>
                  <p class="no-mbot invoice-html-project">
                     <span class="bold"><?php echo _l('project'); ?>:</span>
                     <?php echo get_project_name_by_id($invoice->project_id); ?>
                  </p>
               <?php } ?>
               <?php $pdf_custom_fields = get_custom_fields('invoice', array('show_on_pdf' => 1, 'show_on_client_portal' => 1));
               foreach ($pdf_custom_fields as $field) {
                  $value = get_custom_field_value($invoice->id, $field['id'], 'invoice');
                  if ($value == '') {
                     continue;
                  } ?>
                  <p class="no-mbot">
                     <span class="bold"><?php echo $field['name']; ?>: </span>
                     <?php echo $value; ?>
                  </p>
               <?php } ?>
            </div>
         </div>
         <div class="row">
            <div class="col-md-12">
               <div class="table-responsive">
                  <?php
                  $items = get_items_table_data($invoice, 'invoice');
                  $tbl_html = $items->table();
                  $tbl_html = str_replace('{DOC_CUR}',$invoice->symbol,$tbl_html);
                  echo $tbl_html;
                  ?>
               </div>
            </div>
            <div class="col-md-6 col-md-offset-6">
               <table class="table text-right">
                  <tbody>
                     <tr id="subtotal">
                        <td><span class="bold"><?php echo _l('invoice_subtotal'); ?></span>
                        </td>
                        <td class="subtotal">
                           <?php echo app_format_money($invoice->subtotal, $invoice->currency_name); ?>
                        </td>
                     </tr>
                     <?php if (is_sale_discount_applied($invoice)) { ?>
                        <tr>
                           <td>
                              <span class="bold"><?php echo _l('invoice_discount'); ?>
                                 <?php if (is_sale_discount($invoice, 'percent')) { ?>
                                    (<?php echo app_format_number($invoice->discount_percent, true); ?>%)
                                 <?php } ?></span>
                           </td>
                           <td class="discount">
                              <?php echo '-' . app_format_money($invoice->discount_total, $invoice->currency_name); ?>
                           </td>
                        </tr>
                     <?php } ?>
                     <?php
                     foreach ($items->taxes() as $tax) {
                        echo '<tr class="tax-area"><td class="bold">' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)</td><td>' . app_format_money($tax['total_tax'], $invoice->currency_name) . '</td></tr>';
                     }
                     ?>
                     <?php if ((int)$invoice->adjustment != 0) { ?>
                        <tr>
                           <td>
                              <span class="bold"><?php echo _l('invoice_adjustment'); ?></span>
                           </td>
                           <td class="adjustment">
                              <?php echo app_format_money($invoice->adjustment, $invoice->currency_name); ?>
                           </td>
                        </tr>
                     <?php } ?>
                     <tr>
                        <td><span class="bold"><?php echo _l('invoice_total'); ?></span>
                        </td>
                        <td class="total">
                           <?php echo app_format_money($invoice->total, $invoice->currency_name); ?>
                        </td>
                     </tr>

                     <?php if (get_option('show_credits_applied_on_invoice') == 1 && $credits_applied = total_credits_applied_to_invoice($invoice->id)) { ?>
                        <tr>
                           <td><span class="bold"><?php echo _l('applied_credits'); ?></span></td>
                           <td>
                              <?php echo '-' . app_format_money($credits_applied, $invoice->currency_name); ?>
                           </td>
                        </tr>
                     <?php } ?>

                  </tbody>
               </table>
            </div>

            <?php if (count($invoice->attachments) > 0 && $invoice->visible_attachments_to_customer_found == true) { ?>
               <div class="clearfix"></div>
               <div class="invoice-html-files">
                  <div class="col-md-12">
                     <hr />
                     <p class="bold mbot15 font-medium"><?php echo _l('invoice_files'); ?></p>
                  </div>
                  <?php foreach ($invoice->attachments as $attachment) {
                     // Do not show hidden attachments to customer
                     if ($attachment['visible_to_customer'] == 0) {
                        continue;
                     }
                     $attachment_url = site_url('download/file/sales_attachment/' . $attachment['attachment_key']);
                     if (!empty($attachment['external'])) {
                        $attachment_url = $attachment['external_link'];
                     }
                  ?>
                     <div class="col-md-12 mbot10">
                        <div class="pull-left"><i class="<?php echo get_mime_class($attachment['filetype']); ?>"></i></div>
                        <a href="<?php echo $attachment_url; ?>"><?php echo $attachment['file_name']; ?></a>
                     </div>
                  <?php } ?>
               </div>
            <?php } ?>

            <div class="col-md-12">
            <?php

            $display_currency = '';
            $data_items = hooks()->apply_filters('invoice_html_pdf_data', $invoice);

            $settings['vat_payer'] = (int)get_option('settings_company_vat_payer');
            $settings['vat_on_collection'] = (int)get_option('settings_company_vat_on_collection');
            if($settings['vat_on_collection'] == 1){
              $display_vat_collection = '<p>'._l('invoice_notice_vat_on_collection').'</p>';
              echo $display_vat_collection;
            }


            foreach($invoice->displayRates as $rate){
               echo '<p>' . $rate . '</p>';
            } ?>
          </div>

            <?php if (!empty($invoice->clientnote)) { ?>
               <div class="col-md-12 invoice-html-note">
                  <b><?php echo _l('invoice_note'); ?></b><br /><br /><?php echo $invoice->clientnote; ?>
               </div>
            <?php } ?>
            <?php if (!empty($invoice->terms)) { ?>
               <div class="col-md-12 invoice-html-terms-and-conditions">
                  <hr />
                  <b><?php echo _l('terms_and_conditions'); ?></b><br /><br /><?php echo $invoice->terms; ?>
               </div>
            <?php } ?>
            <div class="col-md-12">
               <hr />
            </div>
         </div>
      </div>
   </div>
</div>
