<?php
defined('BASEPATH') or exit('No direct script access allowed');
/////////////// begin DEFINE ///////////////////////
$subtotal = 0;
$subtotalTax = 0;
$item_tax_rate = 0;
$item_no = 0;
$discount_tax = 0;
$identity_document = '';
$credit_note_issued_by = '';

if (property_exists('invoice', 'sale_agent')) {
    if (property_exists('invoice', 'account_man')) {
        if ($credit_note->sale_agent) {
            if ($credit_note->account_man != NULL) {
                foreach ($credit_note->account_man as $key3 => $row3) {

                    if ($row3['staffid'] == $credit_note->sale_agent) {

                        $identity_document = $row3['identity_document'];
                        $credit_note_issued_by = $row3['full_name'];

                    }

                }
            }
        }
    }
}


if (!function_exists('header_pdf')) {

    function header_pdf($credit_note, $pdf, $credit_note_number, $status, $payment_modes, $font_name)
    {


        $dimensions = $pdf->getPageDimensions();
        $pdf->SetFont($font_name, 'B', 10);
        $pdf->SetFillColor(251, 248, 248);
        $pdf->SetFillColor(255, 255, 255);


        $info_right_column = '';
        $info_left_column = '';

        $info_right_column .= '<span style="font-weight:bold;font-size:27px;">' . _l('invoice_pdf_heading') . '</span><br />';
        $info_right_column .= '<b style="color:#4e4e4e;"># ' . $credit_note_number . '</b>';

        if (get_option('show_status_on_pdf_ei') == 1) {
            $info_right_column .= '<br /><span style="color:rgb(' . invoice_status_color_pdf($status) . ');text-transform:uppercase;">' . format_invoice_status_portal($status, '', false) . '</span>';
        }

        // if ($status != Invoices_model::STATUS_PAID && $status != Invoices_model::STATUS_CANCELLED && get_option('show_pay_link_to_invoice_pdf') == 1
        // 	&& found_invoice_mode($payment_modes, $credit_note->id, false)) {
        // 	$info_right_column .= ' - <a style="color:#84c529;text-decoration:none;text-transform:uppercase;" href="' . site_url('invoice/' . $credit_note->id . '/' . $credit_note->hash) . '"><1b>' . _l('view_invoice_pdf_link_pay') . '</1b></a>';
        // }

        // Add logo
        //$info_left_column .= pdf_logo_url();


        if ((int)$credit_note->options['invoice_settings']['view_logo'] == 1) {
            $info_left_column .= ' <img src="' . $credit_note->logoUrl . '" width="150" class="invoice-logo">';
        } else {
            $info_left_column .= '';
        }

        $pdf->SetFont($font_name, '', 10);
        // Write top left logo and right column info/text
        pdf_multi_row($info_left_column, $info_right_column, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);

        $info_right_column = '';
        $info_left_column = '';
        $info_left_column .= '<br><h4 class="inv-title-1">' . _l('billing_vendor') . '</h4>';
        $info_left_column .= '<p class="p">' . mb_strtoupper($credit_note->company['name']) . '<br>';
        if ($credit_note->company['trade_no']) {
            $info_left_column .= '' . _l('billing_registrar_of_companies') . ': ' . $credit_note->company['trade_no'] . '<br>';
        }
        if ($credit_note->company['vat']) {
            $info_left_column .= '' . _l('billing_vat_code') . ': ' . $credit_note->company['vat'] . '<br>';
        }
        if ($credit_note->company['vat_eu']) {
            $info_left_column .= '' . _l('company_vat_number_eu') . ': ' . $credit_note->company['vat_eu'] . '<br>';
        }
        if ($credit_note->company['address'] || $credit_note->company['state'] || $credit_note->company['city']) {
            $info_left_column .= '' . _l('billing_vendor_address') . ': ' . format_address_line($credit_note->company) . '<br>';
        }
        if ((int)$credit_note->options['invoice_settings']['view_website'] == '1' and $credit_note->company['website']) {
            $info_left_column .= '' . _l('billing_vendor_web') . ': ' . $credit_note->company['website'] . '<br>';
        }

        if ((int)$credit_note->options['invoice_settings']['view_phone'] == '1' and $credit_note->company['phonenumber']) {
            $info_left_column .= '' . _l('billing_vendor_tel') . ': ' . $credit_note->company['phonenumber'] . '<br>';
        }

        if ((int)$credit_note->options['invoice_settings']['view_fax'] == '1' and $credit_note->company['fax']) {
            $info_left_column .= '' . _l('billing_vendor_fax') . ': ' . $credit_note->company['fax'] . '<br>';
        }

        if ((int)$credit_note->options['invoice_settings']['view_email'] == '1' and $credit_note->company['email']) {
            $info_left_column .= '' . _l('billing_vendor_email') . ': ' . $credit_note->company['email'] . '<br>';
        }
        if (!empty($credit_note->company['share_capital']) and $credit_note->company['share_capital']) {
            $info_left_column .= '' . _l('billing_vendor_share_capital') . ': ' . $credit_note->company['share_capital'] . '<br>';
        }
        $info_left_column .= '</p>';


        $info_right_column .= '<br><h4 class="inv-title-1">' . _l('billing_customer') . '</h4>';
        $info_right_column .= ' <p class="p">' . mb_strtoupper($credit_note->client->company) . '<br>';

        if ((int)$credit_note->options['invoice_settings']['view_client_code'] == '1') {
            $info_right_column .= '' . _l('client_code') . ': #' . $credit_note->client->userid . '<br>';
        }

        if (!empty($credit_note->client->trade_number)) {
            $info_right_column .= '' . _l('billing_registrar_of_companies') . ': ' . $credit_note->client->trade_number . '<br>';
        }
        if (!empty($credit_note->client->vat)) {
            $info_right_column .= '' . _l('billing_vat_code') . ': ' . $credit_note->client->vat . '<br>';
        }
        if (!empty($credit_note->client->billing_street)) {
            $info_right_column .= '' . _l('billing_vendor_address') . ': ' . $credit_note->client->billing_street . '<br>';
        }
        if (!empty($credit_note->client->billing_city)) {
            $info_right_column .= '' . _l('billing_vendor_state') . ': ' . $credit_note->client->billing_city . ', ' . get_state_name($credit_note->billing_state) . '<br>';
        }
        if (!empty($credit_note->client->organization_email)) {
            $info_right_column .= '' . _l('billing_vendor_email') . ': ' . $credit_note->client->organization_email . '<br>';
        }
        $info_right_column .= '</p>';

        $pdf->SetFont($font_name, '', 10);
        // Write top left logo and right column info/text
        pdf_multi_row($info_left_column, $info_right_column, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);


        $pdf->MultiCell(73, 10, '', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');
        $pdf->SetFillColor(251, 248, 248);

        /*
        _l('billing_pdf_due_date')
        $credit_note->duedate
        }
        if (!empty($credit_note->payment_link)) {

        ;

        }  */
        /* 			if((int)$credit_note->options['invoice_settings']['view_due_date'] == 1){
                    $pdf->MultiCell(44, 14, _l('billing_pdf_due_date').' '.$credit_note->duedate, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
                    $pdf->ln(4);
                    }else{

                    $pdf->MultiCell(44, 14, _l('billing_pdf_due_date').' ', 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
                    $pdf->ln(4);

                    } */

        if (isset($credit_note->duedate)) {
            $pdf->MultiCell(44, 14, _l('billing_pdf_due_date') . ' ' . $credit_note->duedate, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
            $pdf->ln(4);
        } else {

            $pdf->MultiCell(44, 14, _l('billing_pdf_due_date') . ' ', 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
            $pdf->ln(4);

        }


        $y_line = $pdf->GetY() + 1;

        // if ($status != Invoices_model::STATUS_PAID && $status != Invoices_model::STATUS_CANCELLED && get_option('show_pay_link_to_invoice_pdf') == 1
        // 	&& found_invoice_mode($payment_modes, $credit_note->id, false)) {


        // 	$pdf->Image('assets/images/button_pay-now2.jpg', 10, $y_line, 20, 0, 'JPG', site_url('invoice/' . $credit_note->id . '/' . $credit_note->hash), false, 300);
        // 	$pdf->Write(10,'                       '._l('view_invoice_pdf_link_pay').'  ', site_url('invoice/' . $credit_note->id . '/' . $credit_note->hash), false, 'L', true);


        // }

        if (!file_exists(FCPATH . 'assets/images/button_pay-now2.jpg')) {
            $pdf->Write(10, '' . _l('no_btn') . '  ', 'L');
            $pdf->Error('Image file could not be loaded: assets/images/button_pay-now2.jpg');
        }
        if (!extension_loaded('gd')) {
            $pdf->Error('GD not loaded');
        }

        //lasat ca exemplu, scoate tu. Este un IF mai sus
        //$pdf->Write(0,'Buton lasat ca exemplu. De eliminat si alsat in IF', 'L');

        //$pdf->Image('assets/images/button_pay-now.jpg', 100, 24, 20, 0, 'JPG',  site_url('invoice/' . $credit_note->id . '/' . $credit_note->hash), '', false, 300);
        //$pdf->Image('assets/images/button_pay-now.jpg', 100, 34, 20, 0, 'JPG',  site_url('invoice/' . $credit_note->id . '/' . $credit_note->hash), '', false, 300);


        //$imgdata = base_url('assets/images/mobilpay.jpg');
        //$pdf->Image(FCPATH.'assets/images/mobilpay.jpg', 10, 10, 50, 20, '', site_url('invoice/' . $credit_note->id . '/' . $credit_note->hash), '', false, 300, '', false, false, 0, false, false, false);

        //$pdf->Write(10,'                      '._l('view_invoice_pdf_link_pay').'  ', 'L');

        if (!empty($credit_note->payment_link)) {
            //$pdf->Write(10, _l('billing_pdf_payment_method_card'), $credit_note->payment_link, false, 'L', true);
            //$pdf->MultiCell(44, 14, _l('billing_pdf_payment_method_card').' '.$credit_note->payment_link, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
        }
        $pdf->ln(12);
        // $left_info = '<div style="color:#424242;">';
        // $left_info .= format_customer_info($credit_note, 'invoice', 'shipping');
        // $left_info .= '</div>';
        // MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)
        $pdf->SetFillColor(251, 248, 248);
        $pdf->MultiCell(93, 10, _l('invoice_pdf_heading') . ': ' . $credit_note->prefix . '' . $credit_note->number, 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');
        $pdf->SetFillColor(37, 204, 126);
        $pdf->MultiCell(4, 10, '', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');
        $pdf->SetFillColor(251, 248, 248);
        $pdf->MultiCell(93, 10, _l('billing_pdf_date') . ' : ' . $credit_note->date, 0, 'C', 1, 1, '', '', true, 0, false, true, 10, 'M');


    }
}

if (!function_exists('table_lines_pdf')) {
    function table_lines_pdf($credit_note, $pdf, $font_name, $identity_document, $credit_note_issued_by)
    {


        // linii orizontale
        $pdf->SetDrawColor(192, 192, 192);
        $pdf->Line(10, 114, 200, 114); // ------------ sus
        $pdf->Line(10, 125, 200, 125); // ------------ sus
        $pdf->Line(10, 130, 200, 130); // ------------ sus

        // cartus jos
        $pdf->Line(112, 241, 112, 286);  // ||||||| jos // linie ||| mica jos
        $pdf->Line(10, 241, 200, 241);  // ------------ jos
        $pdf->Line(112, 270, 200, 270);  // ------------ jos
        $pdf->Line(10, 286, 200, 286);  // ------------ jos


        // linii vericale
        $pdf->Line(10, 114, 10, 286); // |||||
        $pdf->Line(22, 114, 22, 241); // |||||
        $pdf->Line(92, 114, 92, 241); // |||||
        $pdf->Line(104, 114, 104, 241); // |||||
        $pdf->Line(128, 114, 128, 241); // |||||
        $pdf->Line(152, 114, 152, 241); // |||||
        $pdf->Line(176, 114, 176, 241); // |||||
        $pdf->Line(200, 114, 200, 286); // |||||


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetFillColor(251, 248, 248);
        //$pdf->MultiCell(73, 10, 'Nr. Crt.', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetXY(10, 116);
        $pdf->setFillColor(230, 230, 230);
        $pdf->Cell(12, 5, '#', '', 0, 'C', '0');

        $pdf->SetXY(20, 116);
        $pdf->Cell(70, 5, _l('inv_item_short_description'), '', 0, 'C', '0');


        $pdf->SetXY(90, 116);
        $pdf->Cell(16, 5, _l('invoice_m_u'), '', 0, 'C', '0');

        $pdf->SetXY(95, 116);
        $pdf->Cell(40, 5, _l('invoice_table_quantity_heading'), '', 0, 'C', '0');

        $pdf->SetXY(120, 116);
        $pdf->Cell(40, 5, _l('unit_price'), '', 0, 'C', '0');

        $pdf->SetXY(144, 116);
        $pdf->Cell(40, 5, _l('invoice_table_amount_heading'), '', 0, 'C', '0');

        $pdf->SetXY(168, 116);
        $pdf->Cell(40, 5, _l('invoice_table_tax_heading'), '', 0, 'C', '0');


        // rand explicativ
        $pdf->SetXY(120, 120);
        $pdf->Cell(40, 5, _l('discount_type_no_tax') . ' (' . $credit_note->currency_name . ')', '', 0, 'C', '0');

        $pdf->SetXY(144, 120);
        $pdf->Cell(40, 5, _l('discount_type_no_tax') . ' (' . $credit_note->currency_name . ')', '', 0, 'C', '0');

        $pdf->SetXY(167, 120);
        $pdf->Cell(40, 5, '(' . $credit_note->currency_name . ')', '', 0, 'C', '0');


        ///////////// nr coloana

        $pdf->SetFont($font_name, '', 8);
        $pdf->SetTextColor(192, 192, 192);

        $pdf->SetXY(14, 125);
        $pdf->Cell(12, 5, '0', '', 0, 'L', '0');

        $pdf->SetXY(20, 125);
        $pdf->Cell(70, 5, '1', '', 0, 'C', '0');


        $pdf->SetXY(90, 125);
        $pdf->Cell(16, 5, '2', '', 0, 'C', '0');

        $pdf->SetXY(95, 125);
        $pdf->Cell(40, 5, '3', '', 0, 'C', '0');

        $pdf->SetXY(120, 125);
        $pdf->Cell(40, 5, '4', '', 0, 'C', '0');

        $pdf->SetXY(144, 125);
        $pdf->Cell(40, 5, '5(3x4)', '', 0, 'C', '0');

        $pdf->SetXY(168, 125);
        $pdf->Cell(40, 5, '6', '', 0, 'C', '0');

        $pdf->SetTextColor(0, 0, 0);

        // pregatire pentru listarea datelor

        $x = 14;
        $y = 133;
        $pdf->SetFont($font_name, '', 8);
        //$pdf->SetFont('Arial', '', 9);
        $pdf->setFillColor(255, 255, 255);

        ///////////////////////////////////////////
        ////////////////////////FOOTER summary /////////////////

        // rates

        if ($credit_note->displayRates != NULL) {

            $xul = 118;
            $pdf->SetFont($font_name, '', 6);

            foreach ($credit_note->displayRates as $key => $row) {


                $pdf->SetXY($xul, 265);
                $pdf->Cell(110, 4, $row, '', 0, 'L', '0');

                $xul = $xul + 30;


            }

        }


        // cartusul de jos


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(10, 242);
        $pdf->Cell(110, 4, _l('invoice_issued_by') . ' : ' . $credit_note_issued_by, '', 0, 'L', '0');
        $pdf->SetXY(10, 246);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ' . $identity_document, '', 0, 'L', '0');
        $pdf->SetXY(10, 250);
        $pdf->Cell(110, 4, _l('delegate_name') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(10, 254);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(10, 258);
        $pdf->Cell(110, 4, _l('transportation_type') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(10, 262);
        $pdf->Cell(110, 4, _l('invoice_expedition'), '', 0, 'L', '0');
        $pdf->SetXY(10, 266);
        $pdf->Cell(110, 4, _l('invoice_at_date') . ' : ................ ' . _l('invoice_hour') . ' ......', '', 0, 'L', '0');
        $pdf->SetXY(10, 268);
        //$pdf->Cell(110,4,'Semnaturile : ','',0,'L','0');
        //$pdf->SetXY(40, 255);
//////////////////////////// here total

        ///alte texte SUME
        $pdf->SetFont($font_name, 'B', 9);
        $pdf->SetXY(114, 246);
        //$pdf->Cell(110,4,'Total ','',0,'L','0');


        $pdf->SetFont($font_name, 'B', 9);

        $pdf->SetXY(134, 246);


        //////////////// total

        $pdf->SetFont($font_name, '0', 14);
        $pdf->SetXY(118, 256);
        $pdf->Cell(110, 4, 'TOTAL', '', 0, 'L', '0');


        $pdf->SetFont($font_name, 'B', 16);
        $pdf->SetXY(158, 255);
        $pdf->Cell(110, 4, number_format($credit_note->total, 2, '.', '') . ' ' . $credit_note->currency_name, '', 0, 'L', '0');

        $pdf->SetFont($font_name, '', 9);
        $pdf->SetXY(118, 265);
        //$pdf->Cell(110,4,'Curs 1 EUR = 4.7635 Lei','',0,'L','0');


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(118, 268);
        //$pdf->Cell(110,2,'Semnatura de primire','',0,'L','0');
        //////////////////////////////////////////////////////////////////////


    }
}
if (!function_exists('table_lines_no_VAT_pdf')) {
    function table_lines_no_VAT_pdf($credit_note, $pdf, $font_name, $identity_document, $credit_note_issued_by)
    {


        // linii orizontale
        $pdf->SetDrawColor(192, 192, 192);
        $pdf->Line(10, 114, 200, 114); // ------------ sus
        $pdf->Line(10, 125, 200, 125); // ------------ sus
        $pdf->Line(10, 130, 200, 130); // ------------ sus

        // cartus jos
        $pdf->Line(112, 241, 112, 286);  // ||||||| jos // linie ||| mica jos
        $pdf->Line(10, 241, 200, 241);  // ------------ jos
        $pdf->Line(112, 270, 200, 270);  // ------------ jos
        $pdf->Line(10, 286, 200, 286);  // ------------ jos


        // linii vericale
        $pdf->Line(10, 114, 10, 286); // |||||
        $pdf->Line(22, 114, 22, 241); // |||||
        $pdf->Line(102, 114, 102, 241); // |||||
        $pdf->Line(114, 114, 114, 241); // |||||
        $pdf->Line(138, 114, 138, 241); // |||||
        $pdf->Line(162, 114, 162, 241); // |||||
        $pdf->Line(200, 114, 200, 286); // |||||


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetFillColor(251, 248, 248);
        //$pdf->MultiCell(73, 10, 'Nr. Crt.', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetXY(10, 116);
        $pdf->setFillColor(230, 230, 230);
        $pdf->Cell(12, 5, '#', '', 0, 'C', '0');

        $pdf->SetXY(28, 116);
        $pdf->Cell(70, 5, _l('inv_item_short_description'), '', 0, 'C', '0');


        $pdf->SetXY(100, 116);
        $pdf->Cell(16, 5, _l('invoice_m_u'), '', 0, 'C', '0');

        $pdf->SetXY(105, 116);
        $pdf->Cell(40, 5, _l('invoice_table_quantity_heading'), '', 0, 'C', '0');

        $pdf->SetXY(130, 116);
        $pdf->Cell(40, 5, _l('unit_price'), '', 0, 'C', '0');

        $pdf->SetXY(160, 116);
        $pdf->Cell(40, 5, _l('invoice_table_amount_heading'), '', 0, 'C', '0');


        // rand explicativ
        $pdf->SetXY(130, 120);
        $pdf->Cell(40, 5, ' (' . $credit_note->currency_name . ')', '', 0, 'C', '0');

        $pdf->SetXY(160, 120);
        $pdf->Cell(40, 5, ' (' . $credit_note->currency_name . ')', '', 0, 'C', '0');


        ///////////// nr coloana

        //$pdf->SetFont('Arial', 'B', 8);
        $pdf->SetXY(14, 125);
        $pdf->Cell(12, 5, '0', '', 0, 'L', '0');

        $pdf->SetXY(28, 125);
        $pdf->Cell(70, 5, '1', '', 0, 'C', '0');


        $pdf->SetXY(100, 125);
        $pdf->Cell(16, 5, '2', '', 0, 'C', '0');

        $pdf->SetXY(105, 125);
        $pdf->Cell(40, 5, '3', '', 0, 'C', '0');

        $pdf->SetXY(130, 125);
        $pdf->Cell(40, 5, '4', '', 0, 'C', '0');

        $pdf->SetXY(160, 125);
        $pdf->Cell(40, 5, '5', '', 0, 'C', '0');


        // pregatire pentru listarea datelor

        $x = 14;
        $y = 133;
        $pdf->SetFont($font_name, '', 8);
        //$pdf->SetFont('Arial', '', 9);
        $pdf->setFillColor(255, 255, 255);

        ///////////////////////////////////////////
        ////////////////////////FOOTER summary /////////////////


        // rates
        if ($credit_note->displayRates != NULL) {

            $xul = 118;
            $pdf->SetFont($font_name, '', 6);

            foreach ($credit_note->displayRates as $key => $row) {


                $pdf->SetXY($xul, 265);
                $pdf->Cell(110, 4, $row, '', 0, 'L', '0');

                $xul = $xul + 30;


            }

        }


        // cartusul de jos


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(50, 242);
        $pdf->Cell(110, 4, _l('invoice_issued_by') . ' : ' . $credit_note_issued_by, '', 0, 'L', '0');
        $pdf->SetXY(50, 246);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ' . $identity_document, '', 0, 'L', '0');
        $pdf->SetXY(50, 250);
        $pdf->Cell(110, 4, _l('delegate_name') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 254);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 258);
        $pdf->Cell(110, 4, _l('transportation_type') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 262);
        $pdf->Cell(110, 4, _l('invoice_expedition'), '', 0, 'L', '0');
        $pdf->SetXY(50, 266);
        $pdf->Cell(110, 4, _l('invoice_at_date') . ' : ................ ' . _l('invoice_hour') . ' ......', '', 0, 'L', '0');
        $pdf->SetXY(50, 268);
        //$pdf->Cell(110,4,'Semnaturile : ','',0,'L','0');
        //$pdf->SetXY(40, 255);


        ///alte texte SUME
        $pdf->SetFont($font_name, 'B', 9);
        $pdf->SetXY(114, 246);
        //$pdf->Cell(110,4,'Total ','',0,'L','0');


        $pdf->SetFont($font_name, 'B', 9);

        $pdf->SetXY(134, 246);


        //////////////// total

        $pdf->SetFont($font_name, 'B', 14);
        $pdf->SetXY(118, 256);
        $pdf->Cell(110, 4, 'TOTAL', '', 0, 'L', '0');


        $pdf->SetFont($font_name, 'B', 16);
        $pdf->SetXY(158, 255);
        $pdf->Cell(110, 4, number_format($credit_note->total, 2, '.', '') . ' ' . $credit_note->currency_name, '', 0, 'L', '0');


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(118, 268);
        //$pdf->Cell(110,2,'Semnatura de primire','',0,'L','0');
        //////////////////////////////////////////////////////////////////////


    }
    /////////////////////// END define ///////////////
}

/////++++

//////////// first page

header_pdf($credit_note, $pdf, $credit_note_number, $status, $payment_modes, $font_name);


// formating for VAT and NON VAT

if ($credit_note->settings['vat_payer'] == 1) {

    table_lines_pdf($credit_note, $pdf, $font_name, $identity_document, $credit_note_issued_by);

} else {

    table_lines_no_VAT_pdf($credit_note, $pdf, $font_name, $identity_document, $credit_note_issued_by);

}


$x = 14;
$y = 133;


///////////////////////////////////////////////////////

/////////////////default multiple
$one_page = 1;


if ($credit_note->items != NULL) {
    foreach ($credit_note->items as $key => $row) {


        $n = 1;


        if ($credit_note->settings['vat_payer'] == 1) {

            $pdf->SetXY($x, $y);
            $pdf->Cell(4, 5, $key + 1, '', 0, 'C', '0');

            $pdf->SetXY($x + 10, $y);

            if ($row['sku']) {
                if ($credit_note->options['invoice_settings']['view_product_code']) {
                    $string = '[' . $row['sku'] . '] ' . $row['description'];
                } else {
                    $string = $row['description'];
                }
                if ($row['item_tax_name']) {
                    $string = $string . ' (' . $row['item_tax_name'] . ') ';
                }
            } else {
                $string = $row['description'];
                if ($row['item_tax_name']) {
                    $string = $string . ' (' . $row['item_tax_name'] . ') ';
                }
            }
            //$string = 'This This sentence is centered in the middle of This This sentence is centered in the middle of This This sentence is centered in the middle of ';
            $cellWidth = $pdf->GetStringWidth($string);

            // impart cellwidth la 50 - cat are coloana si de atatea ori maresc Y-ul

            if (($cellWidth / 69) > 1) {
                $n = ceil($cellWidth / 69);
            }

            $pdf->MultiCell(69, 10, $string, 0, 'L', 0, 1, '', '', true, 0, false, true, 0);
            //$pdf->Cell($cellWidth + 5, 0, $string, 0, 0, 'L', true);

            $pdf->SetXY($x + 80, $y);
            $pdf->MultiCell(13, 5, $row['unit'], '', 0, 'C', '0');

            $cellWidth = $pdf->GetStringWidth($row['unit']);
            if (($cellWidth / 13) > 1) {
                $n2 = ceil($cellWidth / 13);
                if($n2 > $n){
                    $n = $n2;
                }
            }

            $pdf->SetXY($x + 99, $y);
            $pdf->Cell(5, 5, number_format($row['qty'], 2, '.', ''), '', 0, 'C', '0');

            $pdf->SetXY($x + 121, $y);
            $pdf->Cell(10, 5, number_format($row['price_converted'], 2, '.', ''), '', 0, 'C', '0');

            //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!

            $pdf->SetXY($x + 145, $y);
            $pdf->Cell(10, 5, number_format(round(($row['qty'] * $row['price_converted']), 2), 2, '.', ''), '', 0, 'C', '0');


            $pdf->SetXY($x + 169, $y);
            $pdf->Cell(10, 5, number_format(round($row['tax_amount'], 2), 2, '.', ''), '', 0, 'C', '0');


            // calculate in view
            $subtotal = $subtotal + round(($row['qty'] * $row['price_converted']), 2);
            $subtotalTax = $subtotalTax + round($row['tax_amount'], 2);
            // takes tax rate percent from last object
            $item_tax_rate = $row['item_tax_rate'];
            $item_no = $key + 1;

        } else {

            $pdf->SetXY($x, $y);
            $pdf->Cell(4, 5, $key + 1, '', 0, 'C', '0');

            $pdf->SetXY($x + 10, $y);


            if ($row['sku']) {
                if ($credit_note->options['invoice_settings']['view_product_code']) {
                    $string = '[' . $row['sku'] . '] ' . $row['description'];
                } else {
                    $string = $row['description'];
                }
                if ($row['item_tax_name']) {
                    $string = $string . ' (' . $row['item_tax_name'] . ') ';
                }
            } else {
                $string = $row['description'];
                if ($row['item_tax_name']) {
                    $string = $string . ' (' . $row['item_tax_name'] . ') ';
                }
            }
            //$string = 'This This sentence is centered in the middle of This This sentence is centered in the middle of This This sentence is centered in the middle of ';
            $cellWidth = $pdf->GetStringWidth($string);

            // impart cellwidth la 50 - cat are coloana si de atatea ori maresc Y-ul

            if (($cellWidth / 69) > 1) {
                $n = ceil($cellWidth / 69);
            }
            $pdf->MultiCell(69, 10, $string, 0, 'L', 0, 1, '', '', true, 0, false, true, 0);
            //$pdf->Cell($cellWidth + 5, 0, $string, 0, 0, 'L', true);

            $pdf->SetXY($x + 90, $y);
            $pdf->MultiCell(13, 5, $row['unit'], '', 0, 'C', '0');

            $cellWidth = $pdf->GetStringWidth($row['unit']);
            if (($cellWidth / 13) > 1) {
                $n2 = ceil($cellWidth / 13);
                if($n2 > $n){
                    $n = $n2;
                }
            }

            $pdf->SetXY($x + 109, $y);
            $pdf->Cell(5, 5, number_format($row['qty'], 2, '.', ''), '', 0, 'C', '0');

            $pdf->SetXY($x + 131, $y);
            $pdf->Cell(10, 5, number_format($row['price_converted'], 2, '.', ''), '', 0, 'C', '0');

            //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!

            $pdf->SetXY($x + 162, $y);
            $pdf->Cell(10, 5, number_format(round(($row['qty'] * $row['price_converted']), 2), 2, '.', ''), '', 0, 'C', '0');


            // calculate in view
            $subtotal = $subtotal + round(($row['qty'] * $row['price_converted']), 2);
            $subtotalTax = 0;
            // takes tax rate percent from last object
            $item_tax_rate = 0;
            $item_no = $key + 1;

        }

        // aici se inmulteste y	cu 4 nu cu 5
        $y = $y + $n * 5;

        //////////// over one page
        if ($y >= 230) {

            //page number

            $one_page = 1;

            if ($credit_note->settings['vat_payer'] == 1) {


                /// set TVA la incasare
                if (isset($credit_note->settings['display_vat_collection'])) {
                    if ($credit_note->settings['display_vat_collection']) {
                        $pdf->SetFont($font_name, '', 9);
                        $pdf->SetXY(10, 109);
                        $pdf->Cell(110, 4, strip_tags($credit_note->settings['display_vat_collection']), '', 0, 'L', '0');

                    }
                }
                //////////////////// subtotal and page number
                $pdf->SetFont($font_name, '', 10);
                $pdf->SetXY(118, 245);
                $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

                //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                // calculate sums ...

                $pdf->SetXY(157, 246);
                $pdf->Cell(15, 4, number_format($subtotal, 2, '.', '') . '', '', 0, 'C', '0');

                $pdf->SetXY(180, 246);
                $pdf->Cell(15, 4, number_format($subtotalTax, 2, '.', '') . '', '', 0, 'C', '0');


                // page number
                $pdf->SetFont($font_name, '', 8);
                $pdf->SetXY(138, 243);
                $pdf->Cell(0, 10, 'page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, 0, 'L');
                ////////////////////////////////////////


            } else {


                //////////////////// subtotal and page number
                $pdf->SetFont($font_name, '', 10);
                $pdf->SetXY(118, 245);
                $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

                //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                // calculate sums ...

                $pdf->SetXY(172, 246);
                $pdf->Cell(15, 4, number_format($subtotal, 2, '.', '') . '', '', 0, 'C', '0');


                // page number
                $pdf->SetFont($font_name, '', 8);
                $pdf->SetXY(138, 243);
                $pdf->Cell(0, 10, 'page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, 0, 'L');
                ////////////////////////////////////////


            }


            $pdf->AddPage();


            ////////////////////////
            header_pdf($credit_note, $pdf, $credit_note_number, $status, $payment_modes, $font_name);


            if ($credit_note->settings['vat_payer'] == 1) {

                table_lines_pdf($credit_note, $pdf, $font_name, $identity_document, $credit_note_issued_by);

            } else {

                table_lines_no_VAT_pdf($credit_note, $pdf, $font_name, $identity_document, $credit_note_issued_by);

            }

            //table_lines_pdf ($credit_note, $pdf, $font_name);
            ///////////////////////////////


            //$pdf->MultiCell(73, 10, 'Nr. Crt.', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');


            ///////////// nr coloana


            // pregatire pentru listarea datelor

            $x = 14;
            $y = 133;
            $pdf->SetFont($font_name, '', 8);
            $pdf->setFillColor(255, 255, 255);


            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');


            // $pdf->SetXY(157, 246);
            // $pdf->Cell(15,4,number_format($subtotal,2, '.', '').'','',0,'C','0');

            // $pdf->SetXY(180, 246);
            // $pdf->Cell(15,4,number_format($subtotalTax,2, '.', '').'','',0,'C','0');


            // page number
            $pdf->SetFont($font_name, '', 8);
            $pdf->SetXY(138, 243);
            $pdf->Cell(0, 10, 'page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, 0, 'L');
            ////////////////////////////////////////

            //////////////////////////////////////////////////////////////////////

        } else {

            //////////////// for one page

            $one_page = 0;


        }


    }

}

if ($credit_note->settings['vat_payer'] == 1) {


} else {


}

// if it's one page
if ($one_page == 0) {


    //////////////// total

    $pdf->SetFont($font_name, 'B', 14);
    $pdf->SetXY(118, 256);
    $pdf->Cell(110, 4, 'TOTAL', '', 0, 'L', '0');


    $pdf->SetFont($font_name, 'B', 16);
    $pdf->SetXY(158, 255);
    $pdf->Cell(110, 4, number_format($credit_note->total, 2, '.', '') . ' ' . $credit_note->currency_name, '', 0, 'L', '0');


    // ADD at one page invoice
    if ($credit_note->settings['vat_payer'] == 1) {


        //////////////////// subtotal and page number
        $pdf->SetFont($font_name, '', 10);
        $pdf->SetXY(118, 245);
        $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

        $discount_tax = round(($credit_note->discount_total * $item_tax_rate / 100), 2);


        $pdf->SetXY(157, 246);
        $pdf->Cell(15, 4, number_format($subtotal - $credit_note->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

        $pdf->SetXY(180, 246);
        $pdf->Cell(15, 4, number_format($subtotalTax - $discount_tax, 2, '.', '') . '', '', 0, 'C', '0');

    } else {


        //////////////////// subtotal and page number
        $pdf->SetFont($font_name, '', 10);
        $pdf->SetXY(118, 245);
        $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');


        $pdf->SetXY(172, 246);
        $pdf->Cell(15, 4, number_format($subtotal - $credit_note->discount_total, 2, '.', '') . '', '', 0, 'C', '0');


    }


    // if one page write only on that page, else write on the last page

    if (is_sale_discount_applied($credit_note)) {


        if ($credit_note->settings['vat_payer'] == 1) {


            // takes tax rate percent from last object

            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($credit_note->discount_total, $credit_note->currency_name) ,'',0,'L','0');
            $pdf->SetXY(15, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(94, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(112, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(135, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(158, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');

            $discount_tax = round(($credit_note->discount_total * $item_tax_rate / 100), 2);

            $pdf->SetXY(182, 236);
            $pdf->Cell(10, 5, '-' . $discount_tax, '', 0, 'C', '0');


            /// set TVA la incasare
            if (isset($credit_note->settings['display_vat_collection'])) {
                if ($credit_note->settings['display_vat_collection']) {
                    $pdf->SetFont($font_name, '', 9);
                    $pdf->SetXY(10, 109);
                    $pdf->Cell(110, 4, strip_tags($credit_note->settings['display_vat_collection']), '', 0, 'L', '0');

                }
            }
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(157, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $credit_note->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            $pdf->SetXY(180, 246);
            $pdf->Cell(15, 4, number_format($subtotalTax - $discount_tax, 2, '.', '') . '', '', 0, 'C', '0');


            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');


        } else {


            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($credit_note->discount_total, $credit_note->currency_name) ,'',0,'L','0');
            $pdf->SetXY(13, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(104, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(122, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(145, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(174, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');


            /// subtotal /////////////////////////////////////////////
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(172, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $credit_note->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            ////////////////////////////////////////////////////////

            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

            //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!


        }


    }


}
if ($one_page != 0) {


    // if one page write only on that page, else write on the last page

    if (is_sale_discount_applied($credit_note)) {


        if ($credit_note->settings['vat_payer'] == 1) {


            // takes tax rate percent from last object

            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($credit_note->discount_total, $credit_note->currency_name) ,'',0,'L','0');
            $pdf->SetXY(15, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(94, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(112, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(135, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(158, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');

            $discount_tax = round(($credit_note->discount_total * $item_tax_rate / 100), 2);

            $pdf->SetXY(182, 236);
            $pdf->Cell(10, 5, '-' . $discount_tax, '', 0, 'C', '0');


            /// set TVA la incasare
            if (isset($credit_note->settings['display_vat_collection'])) {
                if ($credit_note->settings['display_vat_collection']) {
                    $pdf->SetFont($font_name, '', 9);
                    $pdf->SetXY(10, 109);
                    $pdf->Cell(110, 4, strip_tags($credit_note->settings['display_vat_collection']), '', 0, 'L', '0');

                }
            }
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(157, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $credit_note->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            $pdf->SetXY(180, 246);
            $pdf->Cell(15, 4, number_format($subtotalTax - $discount_tax, 2, '.', '') . '', '', 0, 'C', '0');


        } else {


            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($credit_note->discount_total, $credit_note->currency_name) ,'',0,'L','0');
            $pdf->SetXY(13, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(104, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(122, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(145, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(174, 236);
            $pdf->Cell(10, 5, '-' . $credit_note->discount_total, '', 0, 'C', '0');


            /// subtotal /////////////////////////////////////////////
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(172, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $credit_note->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            ////////////////////////////////////////////////////////


        }


    }


}