<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="panel_s section-heading section-invoices">
    <div class="panel-body">
        <h4 class="no-margin section-text"><?php echo _l('credit_notes'); ?></h4>
    </div>
</div>
<div class="panel_s">
 <div class="panel-body">
     <hr />
     <table class="table dt-table table-invoices" data-order-col="1" data-order-type="desc">
         <thead>
            <tr>
                <th class="th-creditnote-number"><?php echo _l('clients_creditnote_dt_number'); ?></th>
                <th class="th-creditnote-date"><?php echo _l('clients_creditnote_dt_date'); ?></th>
                <th class="th-creditnote-status"><?php echo _l('clients_creditnote_dt_status'); ?></th>
                <th class="th-creditnote-ref"><?php echo _l('clients_creditnote_dt_ref'); ?></th>
                <th class="th-creditnote-amount"><?php echo _l('clients_creditnote_dt_amount'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($invoices as $invoice){ ?>
                <tr>
                    <td data-order="<?php echo $invoice['number']; ?>"><a href="<?php echo site_url('credit-note/' . $invoice['id'] . '/' . $invoice['hash']); ?>" class="invoice-number"><?php echo format_credit_note_number($invoice['id']); ?></a></td>
                    <td data-order="<?php echo $invoice['date']; ?>"><?php echo _d($invoice['date']); ?></td>
                    <td><?php echo format_credit_note_status($invoice['status']);  ?></td>
                    <td data-order="<?php echo $invoice['reference_no']; ?>"><?php echo $invoice['reference_no']; ?></td>
                    <td data-order="<?php echo $invoice['total']; ?>"><?php echo app_format_money($invoice['total'], $invoice['currency_name']); ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
</div>
