<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="<?php echo $locale; ?>">
<head>
    <title><?php if (isset($title))
		{
			echo $title;
		} ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="UTF-8">
    <!-- External CSS libraries -->
    <link type="text/css" rel="stylesheet" href="<?= base_url('assets/invoice-design-v2/css/bootstrap.min.css'); ?>">
    <link type="text/css" rel="stylesheet" href="<?= base_url('assets/invoice-design-v2/fonts/font-awesome/css/font-awesome.min.css'); ?>">
    <!-- Favicon icon -->
    <link rel="shortcut icon" href="<?= base_url('assets/invoice-design-v2/img/favicon.ico'); ?>" type="image/x-icon">
    <!-- Google fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <!-- Custom Stylesheet -->
    <link type="text/css" rel="stylesheet" href="<?= base_url('assets/invoice-design-v2/css/style.css'); ?>">
</head>
<body>

<!-- Invoice 6 start -->
<div class="invoice-6 invoice-content">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="invoice-inner-6" id="invoice_wrapper">
                    <div class="invoice-top">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="logo">
                                    <a href="<?= base_url('/'); ?>">
                                        <img class="logo" src="/uploads/company/7206ef444c904927330f1327fe6b18e2.png" alt="logo">
                                    </a>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="invoice">
                                    <h1><?= _l('proforma_html_proforma'); ?></h1>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="invoice-titel">
                        <div class="row">
                            <div class="invoice2 col-sm-6">
                                <h3><?= _l('proforma_html_proforma'); ?>:
                                    <span> <?= format_proforma_number($proforma->id); ?></span></h3>
                            </div>
                            <div class="date col-sm-6 text-end">
                                <h3><?= _l('proforma_html_proforma_proforma_date'); ?>:
                                    <span>	<?= _d($proforma->date); ?></span></h3>
                            </div>
                        </div>

                    </div>
                    <div class="invoice-info border-bottom">
                        <div class="row">
                            <div class="col-sm-6 mb-30">
                                <div class="invoice-number">
                                    <h4 class="inv-title-1"><?= _l('proforma_html_proforma_vendor'); ?>:</h4>
                                    <p>DIRECT CONSULTING & ADVERTISING</p>
                                    <p class="invo-addr-1">
										<?= _l('proforma_html_proforma_registrar_of_companies'); ?>: <?= $company['trade_no']; ?>
                                        <br>

										<?= _l('proforma_html_proforma_vat_code'); ?>:<?= $company['vat_eu']; ?><br>

										<?= _l('proforma_html_proforma_address'); ?>: <?= $company['address']; ?>, <?= $company['state']; ?>,<br>

										<?= $company['city']; ?>, <?= _l('proforma_html_proforma_state_province'); ?> <?= $company['city']; ?>
                                        <br>

										<?= _l('proforma_html_proforma_web'); ?>:
                                        <a href="<?= $company['website']; ?>" target="_blank"><?= $company['website']; ?></a><br>

										<?= _l('proforma_html_proforma_tel'); ?>: <?= $company['phonenumber']; ?> // <?= $company['fax']; ?>
                                        <br>

										<?= _l('proforma_html_proforma_email'); ?>: <?= $company['email']; ?><br>
										<?php if ( ! empty($company['share_capital'])) { ?>
											<?= _l('proforma_html_proforma_share_capital'); ?>: <?= $company['share_capital']; ?>
										<?php } ?>

                                    </p>
                                </div>
                            </div>
                            <div class="col-sm-6 mb-30">
                                <div class="invoice-number text-end">
                                    <h4 class="inv-title-1"><?= _l('proforma_html_proforma_customer'); ?>:</h4>
                                    <p><?= $proforma->client->company ?></p>
                                    <p class="invo-addr-1">
										<?php if ( ! empty($proforma->client->trade_number)) { ?>
											<?= _l('proforma_html_proforma_registrar_of_companies'); ?>:  <?= $proforma->client->trade_number ?>
                                            <br>
										<?php } ?>

										<?php if ( ! empty($proforma->client->vat)) { ?>
											<?= _l('proforma_html_proforma_vat_code'); ?>: <?= $proforma->client->vat ?>
                                            <br>
										<?php } ?>

										<?= _l('proforma_html_proforma_address'); ?>: <?= $proforma->client->billing_street ?>, <?= $proforma->client->billing_city ?>
                                        <br>

										<?php if ( ! empty($proforma->client->billing_state)) { ?>
											<?= _l('proforma_html_proforma_state_province'); ?>: <?= $proforma->client->billing_state ?>
                                            <br>
										<?php } ?>

										<?php if ( ! empty($proforma->client->organization_email)) { ?>
											<?= _l('proforma_html_proforma_email'); ?>:<?= $proforma->client->organization_email ?>
										<?php } ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 mb-30">
                                <h4 class="inv-title-1"><?= _l('proforma_html_proforma_date'); ?></h4>
                                <p class="inv-from-1"><?= _l('proforma_html_proforma_due_date'); ?>:<?= _d($proforma->duedate); ?></p>
                            </div>
                            <div class="col-sm-6 text-end mb-30">

                                <h4 class="inv-title-1"><?= _l('proforma_html_proforma_payment_method'); ?></h4>

                                <!-- show the payment method if different than payment card. If it is payment card, show the button-->
                                <p class="inv-from-1"><?= _l('credit_card'); ?></p><br>


                                <a href="#" class="btn" style="color: #fff; background-color: #510bc4; border-color: #4209a0; }"><?= _l('proforma_html_proforma_pay_button'); ?></a>

                            </div>
                        </div>
                    </div>
                    <div class="order-summary">
                        <div class="table-responsive">
                            <table class="table invoice-table">
                                <thead class="bg-active">
                                <tr>
                                    <th>#</th>
                                    <th class="text-left"><?= _l('proforma_html_proforma_table_description'); ?></th>
                                    <th class="text-center"><?= _l('proforma_html_proforma_table_unit'); ?></th>
                                    <th class="text-center"><?= _l('proforma_html_proforma_table_quantity'); ?></th>
                                    <th class="text-center"><?= _l('proforma_html_proforma_table_unit_price'); ?>
                                        <br>
                                        <small>(<?= $proforma->currency_name; ?> VAT excl.)</small>
                                    </th>

                                    <th class="text-right"><?= _l('proforma_html_proforma_table_value'); ?>
                                        <br>
                                        <small>(<?= $proforma->currency_name; ?> Value)</small>
                                    </th>
                                    <th class="text-right"><?= _l('proforma_html_proforma_table_tax'); ?></th>

                                </tr>
                                </thead>
                                <tbody>
								<?php $k = 1; ?>
								<?php foreach ($proforma->items as $item) { ?>
                                    <tr>
                                        <td class="text-center"><?= $k ?></td>
                                        <td> <!---description-->
                                            <div class="item-desc-1">
												<?php if ( ! empty($item['sku'])) { ?>
                                                    <span><?= $item['sku'] ?></span>
												<?php } ?>
                                                <small><?= $item['description'] ?></small>
                                            </div>
                                        </td>
                                        <td class="text-center"><?= $item['unit'] ?></td><!---unit-->
                                        <td class="text-center"><?= (int)$item['qty'] ?></td><!---quantity-->
                                        <td class="text-center"><!---unit_price-->
											<?= round($item['rate'], 4);
											if ($item['price_converted'] != 0 AND $item['price_converted'] != '' AND (float)$item['price_converted'] != (float)$item['rate'])
											{
												echo '<br><small>('.round($item['price_converted'],
														2).' '.$item['currency_name'].')</small>';
											} ?>

                                        </td><!---unit_price-->
                                        <td class="text-right"><?= round($item['qty'] * $item['rate'],
												4); ?></td><!---value-->
                                        <td class="text-right"><?= $item['item_tax_name'] ?></td><!---vat TODO-->
                                    </tr>
									<?php $k++; ?>
								<?php } ?>

                                <!----------------------------------------------------------------------------------------->
                                <tr>
                                    <td colspan="6" class="text-end"><?= _l('proforma_html_proforma_table_subtotal'); ?></td>
                                    <td class="text-right">
										<?= round($proforma->subtotal, 2); ?> <?= $proforma->currency_name ?>
                                    </td>
                                </tr>
                                <!-------------------------->
                                <tr><!---vat TODO-->
                                    <td colspan="6" class="text-end"><?= _l('proforma_html_proforma_table_tax'); ?></td>
                                    <td class="text-right"><?= round($proforma->total_tax,
											2); ?> <?= $proforma->currency_name ?></td>
                                </tr>
                                <!-------------------------->
								<?php if (round($proforma->discount_total, 2) > 0) { ?>
                                    <tr>
                                        <td colspan="6" class="text-end">
											<?= _l('proforma_html_proforma_table_discount'); ?>
											<?php if ( ! empty($proforma->discount_percent)) { ?>
                                                (<?= $proforma->discount_percent ?>%)
											<?php } ?>
                                        </td>
                                        <td class="text-right">
                                            -<?= round($proforma->discount_total, 2); ?> <?= $proforma->currency_name ?>
                                        </td>
                                    </tr>
								<?php } ?>
                                <!-------------------------->
								<?php if (round($proforma->adjustment, 2) > 0) { ?>
                                    <tr>
                                        <td colspan="6" class="text-end">
											<?= _l('proforma_html_proforma_table_adjustment'); ?>
                                        </td>
                                        <td class="text-right">
											<?= round($proforma->adjustment, 2); ?> <?= $proforma->currency_name ?>
                                        </td>
                                    </tr>
								<?php } ?>
                                <!-------------------------->
                                <tr>
                                    <td colspan="6" class="text-end fw-bold">
										<?= _l('proforma_html_proforma_table_grand_total'); ?>
                                    </td>
                                    <td class="text-right fw-bold">
										<?= round($proforma->total_left_to_pay, 2); ?> <?= $proforma->currency_name ?>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>


                    <div class="invoice-shipping">
                        <div class="row">
                            <div class="col-sm-10">
                                <div class="expedition-details">
                                    <h3 class="inv-title-1"><?= _l('proforma_html_proforma_expedition_details'); ?></h3>
                                    <p>Made by: Bogdan Minoiu</p>
                                    <p>Shipment made in our presence, on .................... at .........</p>
                                    <p><?= _l('proforma_html_proforma_signatures'); ?>:</p>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <div class="signature text-center">
                                    <h3 class="inv-title-1"><?= _l('proforma_html_proforma_signatures'); ?></h3>
                                    <div class="text-center">
                                        Account Manager <br>
                                        <strong style="font-size: 20px;">Damiel Thomson</strong> <br>
                                        <img src="<?= base_url('assets/invoice-design-v2/images/image6.png'); ?>" height="60px"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="payment-term">
                                    <small>Factura este valabila fara semnatura si stampila, conform art. 319 alin. 29 din legea 227/2015</small>
                                    <!-- This is a check from Settings > Billing > Configuration > Invoice without signature -->
                                </div>
                            </div>

                        </div>

                    </div>


                    <div class="invoice-informeshon">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="payment-info">
									<?php if ( ! empty($banks)) { ?>
                                        <h3 class="inv-title-1"><?= _l('proforma_html_proforma_payment_info'); ?></h3>
                                        <ul class="bank-transfer-list-1">
											<?php foreach ($banks as $bank) { ?>
                                                <li>
                                                    <strong>BAN code (<?= $bank['currency_name'] ?>): <?= $bank['iban'] ?></strong>
                                                </li>
                                                <li>Bank : <?= $bank['name'] ?>; <?php if ( ! empty($bank['swift'])) { ?>SWIFT: <?= $bank['swift'] ?><?php } ?></li>
											<?php } ?>
                                        </ul>
									<?php } ?>
                                </div>
                            </div>
                            <div class="col-sm-6">
								<?php if ( ! empty($proforma->terms)) { ?>
                                    <div class="terms-and-condistions text-left">
                                        <h3 class="inv-title-1"><?= _l('proforma_html_proforma_terms_conditions'); ?></h3>
                                        <p class="mb-0"><?= $proforma->terms; ?></p>
                                    </div>
								<?php } ?>
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-sm-6">
								<?php if ( ! empty($proforma->display_currency)) { ?>
                                    <h4 class="inv-title-1"><?= _l('proforma_html_proforma_currency_rates'); ?></h4>
									<?php foreach ($proforma->display_currency as $currency) { ?>
                                        <p class="text-muted"><?= $currency ?></p>
									<?php } ?>
								<?php } ?>
                            </div>

                            <div class="col-sm-6">
								<?php if ( ! empty($proforma->clientnote)) { ?>
                                    <h4 class="inv-title-1"><?= _l('proforma_html_proforma_notes'); ?></h4>
                                    <p class="text-muted"><?= $proforma->clientnote; ?></p>

								<?php } ?>

                            </div>
                        </div>
                    </div>


                    <p class="doc-generator text-end">
                        <small>Document generat prin CRMconnect (crmconnect.ro)</small>
                    </p>


                </div>
                <div class="invoice-btn-section clearfix d-print-none">
                    <a href="javascript:window.print()" class="btn btn-lg btn-print">
                        <i class="fal fa-print"></i> <?= _l('proforma_html_proforma_print_proforma'); ?>
                    </a>
                    <a id="invoice_download_btn" class="btn btn-lg btn-download">
                        <i class="fal fa-download"></i> <?= _l('proforma_html_proforma_download_proforma'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Invoice 6 end -->

<script src="<?= base_url('assets/invoice-design-v2/js/jquery.min.js'); ?>"></script>
<script src="<?= base_url('assets/invoice-design-v2/js/jspdf.min.js'); ?>"></script>
<script src="<?= base_url('assets/invoice-design-v2/js/html2canvas.js'); ?>"></script>
<script src="<?= base_url('assets/invoice-design-v2/js/app.js'); ?>"></script>
</body>
</html>
