<?php
defined('BASEPATH') or exit('No direct script access allowed');

/////////////// begin DEFINE ///////////////////////
$subtotal = 0;
$subtotalTax = 0;
$item_tax_rate = 0;
$item_no = 0;
$discount_tax = 0;
$identity_document = '';
$invoice_issued_by = '';

if (property_exists('invoice', 'sale_agent')) {
    if (property_exists('invoice', 'account_man')) {
        if ($invoice->sale_agent) {
            if ($invoice->account_man != NULL) {
                foreach ($invoice->account_man as $key3 => $row3) {

                    if ($row3['staffid'] == $invoice->sale_agent) {

                        $identity_document = $row3['identity_document'];
                        $invoice_issued_by = $row3['full_name'];

                    }

                }
            }
        }
    }
}


if (!function_exists('header_pdf')) {
    function header_pdf($invoice, $pdf, $invoice_number, $status, $payment_modes, $font_name)
    {


        $dimensions = $pdf->getPageDimensions();
        $pdf->SetFont($font_name, 'B', 10);
        $pdf->SetFillColor(251, 248, 248);
        $pdf->SetFillColor(255, 255, 255);


        $info_right_column = '';
        $info_left_column = '';

        $info_right_column .= '<span style="font-weight:bold;font-size:27px;">' . _l('proforma_pdf_heading') . '</span><br />';
        $info_right_column .= '<b style="color:#4e4e4e;"># ' . $invoice_number . '</b>';

        if (get_option('show_status_on_pdf_ei') == 1) {
            $info_right_column .= '<br /><span style="color:rgb(' . invoice_status_color_pdf($status) . ');text-transform:uppercase;">' . format_invoice_status_portal($status, '', false) . '</span>';
        }

        if ($status != Proformas_model::STATUS_PAID && $status != Proformas_model::STATUS_CANCELLED && get_option('show_pay_link_to_invoice_pdf') == 1
            && found_invoice_mode($payment_modes, $invoice->id, false)) {
            $info_right_column .= ' - <a style="color:#84c529;text-decoration:none;text-transform:uppercase;" href="' . site_url('invoice/' . $invoice->id . '/' . $invoice->hash) . '"><1b>' . _l('view_invoice_pdf_link_pay') . '</1b></a>';
        }

        // Add logo
        //$info_left_column .= pdf_logo_url();


        if ((int)$invoice->options['invoice_settings']['view_logo'] == 1) {
            $info_left_column .= ' <img src="' . $invoice->logoUrl . '" width="150" class="invoice-logo">';
        } else {
            $info_left_column .= '';
        }

        $pdf->SetFont($font_name, '', 10);
        // Write top left logo and right column info/text
        pdf_multi_row($info_left_column, $info_right_column, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);

        $info_right_column = '';
        $info_left_column = '';
        $info_left_column .= '<br><h4 class="inv-title-1">' . _l('billing_vendor') . '</h4>';
        $info_left_column .= '<p class="p">' . mb_strtoupper($invoice->company['name']) . '<br>';
        if ($invoice->company['trade_no']) {
            $info_left_column .= '' . _l('billing_registrar_of_companies') . ': ' . $invoice->company['trade_no'] . '<br>';
        }
        if ($invoice->company['vat']) {
            $info_left_column .= '' . _l('billing_vat_code') . ': ' . $invoice->company['vat'] . '<br>';
        }
        if ($invoice->company['vat_eu']) {
            $info_left_column .= '' . _l('company_vat_number_eu') . ': ' . $invoice->company['vat_eu'] . '<br>';
        }
        if ($invoice->company['address'] || $invoice->company['state'] || $invoice->company['city']) {
            $info_left_column .= '' . _l('billing_vendor_address') . ': ' . format_address_line($invoice->company) . '<br>';
        }
        if ((int)$invoice->options['invoice_settings']['view_website'] == '1' and $invoice->company['website']) {
            $info_left_column .= '' . _l('billing_vendor_web') . ': ' . $invoice->company['website'] . '<br>';
        }

        if ((int)$invoice->options['invoice_settings']['view_phone'] == '1' and $invoice->company['phonenumber']) {
            $info_left_column .= '' . _l('billing_vendor_tel') . ': ' . $invoice->company['phonenumber'] . '<br>';
        }

        if ((int)$invoice->options['invoice_settings']['view_fax'] == '1' and $invoice->company['fax']) {
            $info_left_column .= '' . _l('billing_vendor_fax') . ': ' . $invoice->company['fax'] . '<br>';
        }

        if ((int)$invoice->options['invoice_settings']['view_email'] == '1' and $invoice->company['email']) {
            $info_left_column .= '' . _l('billing_vendor_email') . ': ' . $invoice->company['email'] . '<br>';
        }
        if (!empty($invoice->company['share_capital']) and $invoice->company['share_capital']) {
            $info_left_column .= '' . _l('billing_vendor_share_capital') . ': ' . $invoice->company['share_capital'] . '<br>';
        }
        $info_left_column .= '</p>';


        $info_right_column .= '<br><h4 class="inv-title-1">' . _l('billing_customer') . '</h4>';
        $info_right_column .= ' <p class="p">' . mb_strtoupper($invoice->client->company) . '<br>';

        if ((int)$invoice->options['invoice_settings']['view_client_code'] == '1') {
            $info_right_column .= '' . _l('client_code') . ': #' . $invoice->client->userid . '<br>';
        }

        if (!empty($invoice->client->trade_number)) {
            $info_right_column .= '' . _l('billing_registrar_of_companies') . ': ' . $invoice->client->trade_number . '<br>';
        }
        if (!empty($invoice->client->vat)) {
            $info_right_column .= '' . _l('billing_vat_code') . ': ' . $invoice->client->vat . '<br>';
        }
        if (!empty($invoice->client->billing_street)) {
            $info_right_column .= '' . _l('billing_vendor_address') . ': ' . $invoice->client->billing_street . '<br>';
        }
        if (!empty($invoice->client->billing_city)) {
            $info_right_column .= '' . _l('billing_vendor_state') . ': ' . $invoice->client->billing_city . ', ' . get_state_name($invoice->billing_state) . '<br>';
        }
        if (!empty($invoice->client->organization_email)) {
            $info_right_column .= '' . _l('billing_vendor_email') . ': ' . $invoice->client->organization_email . '<br>';
        }
        $info_right_column .= '</p>';

        $pdf->SetFont($font_name, '', 10);
        // Write top left logo and right column info/text
        pdf_multi_row($info_left_column, $info_right_column, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);


        $pdf->MultiCell(73, 10, '', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');
        $pdf->SetFillColor(251, 248, 248);

        /*
        _l('billing_pdf_due_date')
        $invoice->duedate
        }
        if (!empty($invoice->payment_link)) {

        ;

        }  */
        /* 			if((int)$invoice->options['invoice_settings']['view_due_date'] == 1){
                    $pdf->MultiCell(44, 14, _l('billing_pdf_due_date').' '.$invoice->duedate, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
                    $pdf->ln(4);
                    } */

        /* 			if((int)$invoice->options['invoice_settings']['view_due_date'] == 1){
                    $pdf->MultiCell(44, 14, _l('billing_pdf_due_date').' '.$invoice->duedate, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
                    $pdf->ln(4);
                    }else{

                    $pdf->MultiCell(44, 14, _l('billing_pdf_due_date').' ', 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
                    $pdf->ln(4);

                    } */

        if (isset($invoice->duedate)) {
            $pdf->MultiCell(44, 14, _l('billing_pdf_due_date') . ' ' . $invoice->duedate, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
            $pdf->ln(4);
        } else {

            $pdf->MultiCell(44, 14, _l('billing_pdf_due_date') . ' ', 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
            $pdf->ln(4);

        }

        $y_line = $pdf->GetY() + 1;

        if ($status != Proformas_model::STATUS_PAID && $status != Proformas_model::STATUS_CANCELLED && get_option('show_pay_link_to_invoice_pdf') == 1
            && found_invoice_mode($payment_modes, $invoice->id, false)) {
            //$pdf->MultiCell(44, 14, _l('view_invoice_pdf_link_pay'), 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');


            $pdf->Image('assets/images/button_pay-now2.jpg', 10, $y_line, 20, 0, 'JPG', '', false, 300);
            $pdf->Write(10, '                       ' . _l('view_invoice_pdf_link_pay') . '  ', site_url('proforma/' . $invoice->id . '/' . $invoice->hash), false, 'L', true);
            //$pdf->Write(10,'                       '._l('view_invoice_pdf_link_pay').'  ', 'L');

            //$pdf->Image(site_url('assets/images/button.png'), '','', 19,10 , '', site_url('invoice/' . $invoice->id . '/' . $invoice->hash));

            //$imgdata = base64_decode('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');

            //$pdf->Image('@'.$imgdata,'','', 19,10 , '', site_url('proforma/' . $invoice->id . '/' . $invoice->hash));
            //$pdf->Write(10,'                      '._l('view_invoice_pdf_link_pay').'  ', 'L');
        }


        if (!empty($invoice->payment_link)) {
            //$pdf->Write(10, _l('billing_pdf_payment_method_card'), $invoice->payment_link, false, 'L', true);
            //$pdf->MultiCell(44, 14, _l('billing_pdf_payment_method_card').' '.$invoice->payment_link, 0, 'C', 1, 0, '', '', true, 0, false, true, 14, 'M');
        }
        $pdf->ln(20);
        // $left_info = '<div style="color:#424242;">';
        // $left_info .= format_customer_info($invoice, 'invoice', 'shipping');
        // $left_info .= '</div>';
        // MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)

        // align header grey
        $pdf->SetXY(10, 102);

        $pdf->SetFillColor(251, 248, 248);
        $pdf->MultiCell(93, 10, _l('proforma_pdf_heading') . ': ' . $invoice->prefix . '' . $invoice->number, 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');
        $pdf->SetFillColor(37, 204, 126);
        $pdf->MultiCell(4, 10, '', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');
        $pdf->SetFillColor(251, 248, 248);
        $pdf->MultiCell(93, 10, _l('billing_pdf_date') . ' : ' . $invoice->date, 0, 'C', 1, 1, '', '', true, 0, false, true, 10, 'M');


    }
}
if (!function_exists('table_lines_pdf')) {
    function table_lines_pdf($invoice, $pdf, $font_name, $identity_document, $invoice_issued_by)
    {


        // linii orizontale
        $pdf->SetDrawColor(192, 192, 192);
        $pdf->Line(10, 114, 200, 114); // ------------ sus
        $pdf->Line(10, 125, 200, 125); // ------------ sus
        $pdf->Line(10, 130, 200, 130); // ------------ sus

        // cartus jos
        $pdf->Line(112, 241, 112, 286);  // ||||||| jos // linie ||| mica jos
        $pdf->Line(10, 241, 200, 241);  // ------------ jos
        $pdf->Line(112, 270, 200, 270);  // ------------ jos
        $pdf->Line(10, 286, 200, 286);  // ------------ jos


        // linii vericale
        $pdf->Line(10, 114, 10, 286); // |||||
        $pdf->Line(22, 114, 22, 241); // |||||
        $pdf->Line(92, 114, 92, 241); // |||||
        $pdf->Line(104, 114, 104, 241); // |||||
        $pdf->Line(128, 114, 128, 241); // |||||
        $pdf->Line(152, 114, 152, 241); // |||||
        $pdf->Line(176, 114, 176, 241); // |||||
        $pdf->Line(200, 114, 200, 286); // |||||


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetFillColor(251, 248, 248);
        //$pdf->MultiCell(73, 10, 'Nr. Crt.', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetXY(10, 116);
        $pdf->setFillColor(230, 230, 230);
        $pdf->Cell(12, 5, '#', '', 0, 'C', '0');

        $pdf->SetXY(20, 116);
        $pdf->Cell(70, 5, _l('inv_item_short_description'), '', 0, 'C', '0');


        $pdf->SetXY(90, 116);
        $pdf->Cell(16, 5, _l('invoice_m_u'), '', 0, 'C', '0');

        $pdf->SetXY(95, 116);
        $pdf->Cell(40, 5, _l('invoice_table_quantity_heading'), '', 0, 'C', '0');

        $pdf->SetXY(120, 116);
        $pdf->Cell(40, 5, _l('unit_price'), '', 0, 'C', '0');

        $pdf->SetXY(144, 116);
        $pdf->Cell(40, 5, _l('invoice_table_amount_heading'), '', 0, 'C', '0');

        $pdf->SetXY(168, 116);
        $pdf->Cell(40, 5, _l('invoice_table_tax_heading'), '', 0, 'C', '0');


        // rand explicativ
        $pdf->SetXY(120, 120);
        $pdf->Cell(40, 5, _l('discount_type_no_tax') . ' (' . $invoice->currency_name . ')', '', 0, 'C', '0');

        $pdf->SetXY(144, 120);
        $pdf->Cell(40, 5, _l('discount_type_no_tax') . ' (' . $invoice->currency_name . ')', '', 0, 'C', '0');

        $pdf->SetXY(167, 120);
        $pdf->Cell(40, 5, '(' . $invoice->currency_name . ')', '', 0, 'C', '0');


        ///////////// nr coloana

        $pdf->SetFont($font_name, '', 8);
        $pdf->SetTextColor(192, 192, 192);

        $pdf->SetXY(14, 125);
        $pdf->Cell(12, 5, '0', '', 0, 'L', '0');

        $pdf->SetXY(20, 125);
        $pdf->Cell(70, 5, '1', '', 0, 'C', '0');


        $pdf->SetXY(90, 125);
        $pdf->Cell(16, 5, '2', '', 0, 'C', '0');

        $pdf->SetXY(95, 125);
        $pdf->Cell(40, 5, '3', '', 0, 'C', '0');

        $pdf->SetXY(120, 125);
        $pdf->Cell(40, 5, '4', '', 0, 'C', '0');

        $pdf->SetXY(144, 125);
        $pdf->Cell(40, 5, '5(3x4)', '', 0, 'C', '0');

        $pdf->SetXY(168, 125);
        $pdf->Cell(40, 5, '6', '', 0, 'C', '0');

        $pdf->SetTextColor(0, 0, 0);

        // pregatire pentru listarea datelor

        $x = 14;
        $y = 133;
        $pdf->SetFont($font_name, '', 8);
        //$pdf->SetFont('Arial', '', 9);
        $pdf->setFillColor(255, 255, 255);

        ///////////////////////////////////////////
        ////////////////////////FOOTER summary /////////////////


        // rates
        if ($invoice->displayRates != NULL) {

            $xul = 118;
            $pdf->SetFont($font_name, '', 6);

            foreach ($invoice->displayRates as $key => $row) {


                $pdf->SetXY($xul, 266);
                $pdf->Cell(110, 4, $row, '', 0, 'L', '0');

                $xul = $xul + 30;


            }

        }


        // cartusul de jos


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(50, 242);
        $pdf->Cell(110, 4, _l('invoice_issued_by') . ' : ' . $invoice_issued_by, '', 0, 'L', '0');
        $pdf->SetXY(50, 246);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ' . $identity_document, '', 0, 'L', '0');
        $pdf->SetXY(50, 250);
        $pdf->Cell(110, 4, _l('delegate_name') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 254);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 258);
        $pdf->Cell(110, 4, _l('transportation_type') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 262);
        $pdf->Cell(110, 4, _l('invoice_expedition'), '', 0, 'L', '0');
        $pdf->SetXY(50, 266);
        $pdf->Cell(110, 4, _l('invoice_at_date') . ' : ................ ' . _l('invoice_hour') . ' ......', '', 0, 'L', '0');
        $pdf->SetXY(50, 268);
        //$pdf->Cell(110,4,'Semnaturile : ','',0,'L','0');
        //$pdf->SetXY(40, 255);


        ///alte texte SUME
        $pdf->SetFont($font_name, 'B', 9);
        $pdf->SetXY(114, 246);
        //$pdf->Cell(110,4,'Total ','',0,'L','0');
///// de modificat 222

        $pdf->SetFont($font_name, 'B', 9);

        $pdf->SetXY(134, 246);


        //////////////// total

        $pdf->SetFont($font_name, 'B', 14);
        $pdf->SetXY(118, 261);
        $pdf->Cell(110, 4, 'TOTAL', '', 0, 'L', '0');


        $pdf->SetFont($font_name, 'B', 16);
        $pdf->SetXY(158, 260);
        $pdf->Cell(110, 4, number_format($invoice->total, 2, '.', '') . ' ' . $invoice->currency_name, '', 0, 'L', '0');


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(118, 268);
        //$pdf->Cell(110,2,'Semnatura de primire','',0,'L','0');
        //////////////////////////////////////////////////////////////////////


    }
}

if (function_exists('header_pdf')) {
    function table_lines_no_VAT_pdf($invoice, $pdf, $font_name, $identity_document, $invoice_issued_by)
    {


        // linii orizontale
        $pdf->SetDrawColor(192, 192, 192);
        $pdf->Line(10, 114, 200, 114); // ------------ sus
        $pdf->Line(10, 125, 200, 125); // ------------ sus
        $pdf->Line(10, 130, 200, 130); // ------------ sus

        // cartus jos
        $pdf->Line(112, 241, 112, 286);  // ||||||| jos // linie ||| mica jos
        $pdf->Line(10, 241, 200, 241);  // ------------ jos
        $pdf->Line(112, 270, 200, 270);  // ------------ jos
        $pdf->Line(10, 286, 200, 286);  // ------------ jos


        // linii vericale
        $pdf->Line(10, 114, 10, 286); // |||||
        $pdf->Line(22, 114, 22, 241); // |||||
        $pdf->Line(102, 114, 102, 241); // |||||
        $pdf->Line(114, 114, 114, 241); // |||||
        $pdf->Line(138, 114, 138, 241); // |||||
        $pdf->Line(162, 114, 162, 241); // |||||
        $pdf->Line(200, 114, 200, 286); // |||||


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetFillColor(251, 248, 248);
        //$pdf->MultiCell(73, 10, 'Nr. Crt.', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');


        $pdf->SetFont($font_name, 'B', 8);
        $pdf->SetXY(10, 116);
        $pdf->setFillColor(230, 230, 230);
        $pdf->Cell(12, 5, '#', '', 0, 'C', '0');

        $pdf->SetXY(28, 116);
        $pdf->Cell(70, 5, _l('inv_item_short_description'), '', 0, 'C', '0');


        $pdf->SetXY(100, 116);
        $pdf->Cell(16, 5, _l('invoice_m_u'), '', 0, 'C', '0');

        $pdf->SetXY(105, 116);
        $pdf->Cell(40, 5, _l('invoice_table_quantity_heading'), '', 0, 'C', '0');

        $pdf->SetXY(130, 116);
        $pdf->Cell(40, 5, _l('unit_price'), '', 0, 'C', '0');

        $pdf->SetXY(160, 116);
        $pdf->Cell(40, 5, _l('invoice_table_amount_heading'), '', 0, 'C', '0');


        // rand explicativ
        $pdf->SetXY(130, 120);
        $pdf->Cell(40, 5, ' (' . $invoice->currency_name . ')', '', 0, 'C', '0');

        $pdf->SetXY(160, 120);
        $pdf->Cell(40, 5, ' (' . $invoice->currency_name . ')', '', 0, 'C', '0');


        ///////////// nr coloana

        //$pdf->SetFont('Arial', 'B', 8);
        $pdf->SetXY(14, 125);
        $pdf->Cell(12, 5, '0', '', 0, 'L', '0');

        $pdf->SetXY(28, 125);
        $pdf->Cell(70, 5, '1', '', 0, 'C', '0');


        $pdf->SetXY(100, 125);
        $pdf->Cell(16, 5, '2', '', 0, 'C', '0');

        $pdf->SetXY(105, 125);
        $pdf->Cell(40, 5, '3', '', 0, 'C', '0');

        $pdf->SetXY(130, 125);
        $pdf->Cell(40, 5, '4', '', 0, 'C', '0');

        $pdf->SetXY(160, 125);
        $pdf->Cell(40, 5, '5', '', 0, 'C', '0');


        // pregatire pentru listarea datelor

        $x = 14;
        $y = 133;
        $pdf->SetFont($font_name, '', 8);
        //$pdf->SetFont('Arial', '', 9);
        $pdf->setFillColor(255, 255, 255);

        ///////////////////////////////////////////
        ////////////////////////FOOTER summary /////////////////


        // rates
        if ($invoice->displayRates != NULL) {

            $xul = 118;
            $pdf->SetFont($font_name, '', 6);

            foreach ($invoice->displayRates as $key => $row) {


                $pdf->SetXY($xul, 266);
                $pdf->Cell(110, 4, $row, '', 0, 'L', '0');

                $xul = $xul + 30;


            }

        }


        // cartusul de jos


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(50, 242);
        $pdf->Cell(110, 4, _l('invoice_issued_by') . ' : ' . $invoice_issued_by, '', 0, 'L', '0');
        $pdf->SetXY(50, 246);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ' . $identity_document, '', 0, 'L', '0');
        $pdf->SetXY(50, 250);
        $pdf->Cell(110, 4, _l('delegate_name') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 254);
        $pdf->Cell(110, 4, _l('identity_document') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 258);
        $pdf->Cell(110, 4, _l('transportation_type') . ' : ', '', 0, 'L', '0');
        $pdf->SetXY(50, 262);
        $pdf->Cell(110, 4, _l('invoice_expedition'), '', 0, 'L', '0');
        $pdf->SetXY(50, 266);
        $pdf->Cell(110, 4, _l('invoice_at_date') . ' : ................ ' . _l('invoice_hour') . ' ......', '', 0, 'L', '0');
        $pdf->SetXY(50, 268);
        //$pdf->Cell(110,4,'Semnaturile : ','',0,'L','0');
        //$pdf->SetXY(40, 255);


        ///alte texte SUME
        $pdf->SetFont($font_name, 'B', 9);
        $pdf->SetXY(114, 246);
        //$pdf->Cell(110,4,'Total ','',0,'L','0');


        $pdf->SetFont($font_name, 'B', 9);

        $pdf->SetXY(134, 246);


        //////////////// total

        $pdf->SetFont($font_name, 'B', 14);
        $pdf->SetXY(118, 261);
        $pdf->Cell(110, 4, 'TOTAL', '', 0, 'L', '0');


        $pdf->SetFont($font_name, 'B', 16);
        $pdf->SetXY(158, 260);
        $pdf->Cell(110, 4, number_format($invoice->total, 2, '.', '') . ' ' . $invoice->currency_name, '', 0, 'L', '0');


        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(118, 268);
        //$pdf->Cell(110,2,'Semnatura de primire','',0,'L','0');
        //////////////////////////////////////////////////////////////////////


    }
}
/////////////////////// END define ///////////////


//////////// first page

header_pdf($invoice, $pdf, $invoice_number, $status, $payment_modes, $font_name);


// formating for VAT and NON VAT

if ($invoice->settings['vat_payer'] == 1) {

    table_lines_pdf($invoice, $pdf, $font_name, $identity_document, $invoice_issued_by);

} else {

    table_lines_no_VAT_pdf($invoice, $pdf, $font_name, $identity_document, $invoice_issued_by);

}


$x = 14;
$y = 133;


///////////////////////////////////////////////////////

/////////////////default multiple
$one_page = 1;


foreach ($invoice->items as $key => $row) {


    $n = 1;


    if ($invoice->settings['vat_payer'] == 1) {

        $pdf->SetXY($x, $y);
        $pdf->Cell(4, 5, $key + 1, '', 0, 'C', '0');

        $pdf->SetXY($x + 10, $y);

        if ($row['sku']) {
            if ($invoice->options['invoice_settings']['view_product_code']) {
                $string = '[' . $row['sku'] . '] ' . $row['description'];
            } else {
                $string = $row['description'];
            }
            if ($row['item_tax_name']) {
                $string = $string . ' (' . $row['item_tax_name'] . ') ';
            }
        } else {
            $string = $row['description'];
            if ($row['item_tax_name']) {
                $string = $string . ' (' . $row['item_tax_name'] . ') ';
            }
        }
        //$string = 'This This sentence is centered in the middle of This This sentence is centered in the middle of This This sentence is centered in the middle of ';
        $cellWidth = $pdf->GetStringWidth($string);

        // impart cellwidth la 50 - cat are coloana si de atatea ori maresc Y-ul

        if (($cellWidth / 69) > 1) {
            $n = ceil($cellWidth / 69);
        }
        $pdf->MultiCell(69, 10, $string, 0, 'L', 0, 1, '', '', true, 0, false, true, 0);
        //$pdf->Cell($cellWidth + 5, 0, $string, 0, 0, 'L', true);

        $pdf->SetXY($x + 80, $y);
        $pdf->MultiCell(13, 5, $row['unit'], '', 0, 'C', '0');

        $cellWidth = $pdf->GetStringWidth($row['unit']);
        if (($cellWidth / 13) > 1) {
            $n2 = ceil($cellWidth / 13);
            if($n2 > $n){
                $n = $n2;
            }
        }

        $pdf->SetXY($x + 99, $y);
        $pdf->Cell(5, 5, number_format($row['qty'], 2, '.', ''), '', 0, 'C', '0');

        $pdf->SetXY($x + 121, $y);
        $pdf->Cell(10, 5, number_format($row['price_converted'], 2, '.', ''), '', 0, 'C', '0');

        //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        $pdf->SetXY($x + 145, $y);
        $pdf->Cell(10, 5, number_format(round(($row['qty'] * $row['price_converted']), 2), 2, '.', ''), '', 0, 'C', '0');


        $pdf->SetXY($x + 169, $y);
        $pdf->Cell(10, 5, number_format(round($row['tax_amount'], 2), 2, '.', ''), '', 0, 'C', '0');


        // calculate in view
        $subtotal = $subtotal + round(($row['qty'] * $row['price_converted']), 2);
        $subtotalTax = $subtotalTax + round($row['tax_amount'], 2);
        // takes tax rate percent from last object
        $item_tax_rate = $row['item_tax_rate'];
        $item_no = $key + 1;

    } else {

        $pdf->SetXY($x, $y);
        $pdf->Cell(4, 5, $key + 1, '', 0, 'C', '0');

        $pdf->SetXY($x + 10, $y);


        if ($row['sku']) {
            if ($invoice->options['invoice_settings']['view_product_code']) {
                $string = '[' . $row['sku'] . '] ' . $row['description'];
            } else {
                $string = $row['description'];
            }
            if ($row['item_tax_name']) {
                $string = $string . ' (' . $row['item_tax_name'] . ') ';
            }
        } else {
            $string = $row['description'];
            if ($row['item_tax_name']) {
                $string = $string . ' (' . $row['item_tax_name'] . ') ';
            }
        }
        //$string = 'This This sentence is centered in the middle of This This sentence is centered in the middle of This This sentence is centered in the middle of ';
        $cellWidth = $pdf->GetStringWidth($string);

        // impart cellwidth la 50 - cat are coloana si de atatea ori maresc Y-ul

        if (($cellWidth / 69) > 1) {
            $n = ceil($cellWidth / 69);
        }
        $pdf->MultiCell(69, 10, $string, 0, 'L', 0, 1, '', '', true, 0, false, true, 0);
        //$pdf->Cell($cellWidth + 5, 0, $string, 0, 0, 'L', true);

        $pdf->SetXY($x + 90, $y);
        $pdf->MultiCell(13, 5, $row['unit'], '', 0, 'C', '0');

        $cellWidth = $pdf->GetStringWidth($row['unit']);
        if (($cellWidth / 13) > 1) {
            $n2 = ceil($cellWidth / 13);
            if($n2 > $n){
                $n = $n2;
            }
        }

        $pdf->SetXY($x + 109, $y);
        $pdf->Cell(5, 5, number_format($row['qty'], 2, '.', ''), '', 0, 'C', '0');

        $pdf->SetXY($x + 131, $y);
        $pdf->Cell(10, 5, number_format($row['price_converted'], 2, '.', ''), '', 0, 'C', '0');

        //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        $pdf->SetXY($x + 162, $y);
        $pdf->Cell(10, 5, number_format(round(($row['qty'] * $row['price_converted']), 2), 2, '.', ''), '', 0, 'C', '0');


        // calculate in view
        $subtotal = $subtotal + round(($row['qty'] * $row['price_converted']), 2);
        $subtotalTax = 0;
        // takes tax rate percent from last object
        $item_tax_rate = 0;
        $item_no = $key + 1;

    }

    // aici se inmulteste y	cu 4 nu cu 5
    $y = $y + $n * 5;

    //////////// over one page
    if ($y >= 230) {

        //page number

        $one_page = 1;

        if ($invoice->settings['vat_payer'] == 1) {


            /// set TVA la incasare
            if (isset($invoice->settings['display_vat_collection'])) {
                if ($invoice->settings['display_vat_collection']) {
                    $pdf->SetFont($font_name, '', 9);
                    $pdf->SetXY(10, 109);
                    $pdf->Cell(110, 4, strip_tags($invoice->settings['display_vat_collection']), '', 0, 'L', '0');

                }
            }
            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

            //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // calculate sums ...

            $pdf->SetXY(157, 246);
            $pdf->Cell(15, 4, number_format($subtotal, 2, '.', '') . '', '', 0, 'C', '0');

            $pdf->SetXY(180, 246);
            $pdf->Cell(15, 4, number_format($subtotalTax, 2, '.', '') . '', '', 0, 'C', '0');


            // page number
            $pdf->SetFont($font_name, '', 8);
            $pdf->SetXY(138, 243);
            $pdf->Cell(0, 10, 'page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, 0, 'L');
            ////////////////////////////////////////


        } else {


            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

            //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            // calculate sums ...

            $pdf->SetXY(172, 246);
            $pdf->Cell(15, 4, number_format($subtotal, 2, '.', '') . '', '', 0, 'C', '0');


            // page number
            $pdf->SetFont($font_name, '', 8);
            $pdf->SetXY(138, 243);
            $pdf->Cell(0, 10, 'page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, 0, 'L');
            ////////////////////////////////////////


        }


        $pdf->AddPage();


        ////////////////////////
        header_pdf($invoice, $pdf, $invoice_number, $status, $payment_modes, $font_name);


        if ($invoice->settings['vat_payer'] == 1) {

            table_lines_pdf($invoice, $pdf, $font_name, $identity_document, $invoice_issued_by);

        } else {

            table_lines_no_VAT_pdf($invoice, $pdf, $font_name, $identity_document, $invoice_issued_by);

        }

        //table_lines_pdf ($invoice, $pdf, $font_name);
        ///////////////////////////////


        //$pdf->MultiCell(73, 10, 'Nr. Crt.', 0, 'C', 1, 0, '', '', true, 0, false, true, 10, 'M');


        ///////////// nr coloana


        // pregatire pentru listarea datelor

        $x = 14;
        $y = 133;
        $pdf->SetFont($font_name, '', 8);
        $pdf->setFillColor(255, 255, 255);


        //////////////////// subtotal and page number
        $pdf->SetFont($font_name, '', 10);
        $pdf->SetXY(118, 245);
        $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');


        // $pdf->SetXY(157, 246);
        // $pdf->Cell(15,4,number_format($subtotal,2, '.', '').'','',0,'C','0');

        // $pdf->SetXY(180, 246);
        // $pdf->Cell(15,4,number_format($subtotalTax,2, '.', '').'','',0,'C','0');


        // page number
        $pdf->SetFont($font_name, '', 8);
        $pdf->SetXY(138, 243);
        $pdf->Cell(0, 10, 'page ' . $pdf->getAliasNumPage() . '/' . $pdf->getAliasNbPages(), 0, 0, 'L');
        ////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////

    } else {

        //////////////// for one page

        $one_page = 0;


    }


}


if ($invoice->settings['vat_payer'] == 1) {


} else {


}

// if it's one page
if ($one_page == 0) {


    //////////////// total

    $pdf->SetFont($font_name, 'B', 14);
    $pdf->SetXY(118, 261);
    $pdf->Cell(110, 4, 'TOTAL', '', 0, 'L', '0');


    $pdf->SetFont($font_name, 'B', 16);
    $pdf->SetXY(158, 260);
    $pdf->Cell(110, 4, number_format($invoice->total, 2, '.', '') . ' ' . $invoice->currency_name, '', 0, 'L', '0');


    // ADD at one page invoice
    if ($invoice->settings['vat_payer'] == 1) {


        //////////////////// subtotal and page number
        $pdf->SetFont($font_name, '', 10);
        $pdf->SetXY(118, 245);
        $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

        $discount_tax = round(($invoice->discount_total * $item_tax_rate / 100), 2);


        $pdf->SetXY(157, 246);
        $pdf->Cell(15, 4, number_format($subtotal - $invoice->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

        $pdf->SetXY(180, 246);
        $pdf->Cell(15, 4, number_format($subtotalTax - $discount_tax, 2, '.', '') . '', '', 0, 'C', '0');

    } else {


        //////////////////// subtotal and page number
        $pdf->SetFont($font_name, '', 10);
        $pdf->SetXY(118, 245);
        $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');


        $pdf->SetXY(172, 246);
        $pdf->Cell(15, 4, number_format($subtotal - $invoice->discount_total, 2, '.', '') . '', '', 0, 'C', '0');


    }


    // if one page write only on that page, else write on the last page

    if (is_sale_discount_applied($invoice)) {


        if ($invoice->settings['vat_payer'] == 1) {


            // takes tax rate percent from last object

            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($invoice->discount_total, $invoice->currency_name) ,'',0,'L','0');
            $pdf->SetXY(15, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(94, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(112, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(135, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(158, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');

            $discount_tax = round(($invoice->discount_total * $item_tax_rate / 100), 2);

            $pdf->SetXY(182, 236);
            $pdf->Cell(10, 5, '-' . $discount_tax, '', 0, 'C', '0');


            /// set TVA la incasare
            if (isset($invoice->settings['display_vat_collection'])) {
                if ($invoice->settings['display_vat_collection']) {
                    $pdf->SetFont($font_name, '', 9);
                    $pdf->SetXY(10, 109);
                    $pdf->Cell(110, 4, strip_tags($invoice->settings['display_vat_collection']), '', 0, 'L', '0');

                }
            }
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(157, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $invoice->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            $pdf->SetXY(180, 246);
            $pdf->Cell(15, 4, number_format($subtotalTax - $discount_tax, 2, '.', '') . '', '', 0, 'C', '0');


            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');


        } else {


            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($invoice->discount_total, $invoice->currency_name) ,'',0,'L','0');
            $pdf->SetXY(13, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(104, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(122, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(145, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(174, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');


            /// subtotal /////////////////////////////////////////////
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(172, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $invoice->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            ////////////////////////////////////////////////////////

            //////////////////// subtotal and page number
            $pdf->SetFont($font_name, '', 10);
            $pdf->SetXY(118, 245);
            $pdf->Cell(110, 4, 'Subtotal', '', 0, 'L', '0');

            //////////AICI calculeaza in VIEW !!!!!!!!!!!!!!!!!!!!!!!!!!!!!


        }


    }


}
if ($one_page != 0) {


    // if one page write only on that page, else write on the last page

    if (is_sale_discount_applied($invoice)) {


        if ($invoice->settings['vat_payer'] == 1) {


            // takes tax rate percent from last object

            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($invoice->discount_total, $invoice->currency_name) ,'',0,'L','0');
            $pdf->SetXY(15, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(94, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(112, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(135, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(158, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');

            $discount_tax = round(($invoice->discount_total * $item_tax_rate / 100), 2);

            $pdf->SetXY(182, 236);
            $pdf->Cell(10, 5, '-' . $discount_tax, '', 0, 'C', '0');


            /// set TVA la incasare
            if (isset($invoice->settings['display_vat_collection'])) {
                if ($invoice->settings['display_vat_collection']) {
                    $pdf->SetFont($font_name, '', 9);
                    $pdf->SetXY(10, 109);
                    $pdf->Cell(110, 4, strip_tags($invoice->settings['display_vat_collection']), '', 0, 'L', '0');

                }
            }
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(157, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $invoice->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            $pdf->SetXY(180, 246);
            $pdf->Cell(15, 4, number_format($subtotalTax - $discount_tax, 2, '.', '') . '', '', 0, 'C', '0');


        } else {


            $pdf->SetFont($font_name, '', 8);
            //$pdf->SetXY(10, 236);
            //$pdf->Cell(110,4,_l('invoice_discount').' '.app_format_money($invoice->discount_total, $invoice->currency_name) ,'',0,'L','0');
            $pdf->SetXY(13, 235);
            $pdf->Cell(4, 5, $item_no + 1, '', 0, 'C', '0');

            $pdf->SetXY(25, 236);

            $pdf->Cell(10, 0, _l('invoice_discount'), 0, 0, 'L', true);
            //$pdf->SetXY(80,35);
            // $pdf->SetXY($x+10, $y);
            // $pdf->Cell(9,5,$string,'',0,'L','0');

            $pdf->SetXY(104, 236);
            $pdf->Cell(9, 5, '-', '', 0, 'C', '0');

            $pdf->SetXY(122, 236);
            $pdf->Cell(5, 5, 1.00, '', 0, 'C', '0');

            $pdf->SetXY(145, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');

            $pdf->SetXY(174, 236);
            $pdf->Cell(10, 5, '-' . $invoice->discount_total, '', 0, 'C', '0');


            /// subtotal /////////////////////////////////////////////
            $pdf->SetFont($font_name, '', 10);

            $pdf->SetXY(172, 246);
            $pdf->Cell(15, 4, number_format($subtotal - $invoice->discount_total, 2, '.', '') . '', '', 0, 'C', '0');

            ////////////////////////////////////////////////////////


        }


    }


}







// $tblhtml = $items->table();
// $tblhtml = str_replace('{DOC_CUR}',$invoice->symbol,$tblhtml);


// $pdf->writeHTML($tblhtml, true, false, false, false, '');
/* 
$pdf->Ln(8);
//$pdf->AddPage('P', 'A4');
$pdf->GetY();


$tbltotal = '';
$tbltotal .= '<table cellpadding="6" style="font-size:' . ($font_size + 4) . 'px">';
$tbltotal .= '
<tr>
    <td align="right" width="85%"><strong>' . _l('invoice_subtotal') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($invoice->subtotal, $invoice->currency_name) . '</td>
</tr>';

if (is_sale_discount_applied($invoice)) {
    $tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('invoice_discount');
    if (is_sale_discount($invoice, 'percent')) {
        $tbltotal .= '(' . app_format_number($invoice->discount_percent, true) . '%)';
    }
    $tbltotal .= '</strong>';
    $tbltotal .= '</td>';
    $tbltotal .= '<td align="right" width="15%">-' . app_format_money($invoice->discount_total, $invoice->currency_name) . '</td>
    </tr>';
}

foreach ($items->taxes() as $tax) {
    $tbltotal .= '<tr>
    <td align="right" width="85%"><strong>' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)' . '</strong></td>
    <td align="right" width="15%">' . app_format_money($tax['total_tax'], $invoice->currency_name) . '</td>
</tr>';
}

if ((int) $invoice->adjustment != 0) {
    $tbltotal .= '<tr>
    <td align="right" width="85%"><strong>' . _l('invoice_adjustment') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($invoice->adjustment, $invoice->currency_name) . '</td>
</tr>';
}

$tbltotal .= '
<tr style="background-color:#f0f0f0;">
    <td align="right" width="85%"><strong>' . _l('invoice_total') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($invoice->total, $invoice->currency_name) . '</td>
</tr>';

if (count($invoice->payments) > 0 && get_option('show_total_paid_on_invoice') == 1) {
    $tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('invoice_total_paid') . '</strong></td>
        <td align="right" width="15%">-' . app_format_money(sum_from_table(db_prefix().'invoicepaymentrecords', [
        'field' => 'amount',
        'where' => [
            'invoiceid' => $invoice->id,
        ],
    ]), $invoice->currency_name) . '</td>
    </tr>';
}

if (get_option('show_credits_applied_on_invoice') == 1 && $credits_applied = total_credits_applied_to_invoice($invoice->id)) {
    $tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('applied_credits') . '</strong></td>
        <td align="right" width="15%">-' . app_format_money($credits_applied, $invoice->currency_name) . '</td>
    </tr>';
}

if (get_option('show_amount_due_on_invoice') == 1 && $invoice->status != Proformas_model::STATUS_CANCELLED) {
    $tbltotal .= '<tr style="background-color:#f0f0f0;">
       <td align="right" width="85%"><strong>' . _l('invoice_amount_due') . '</strong></td>
       <td align="right" width="15%">' . app_format_money($invoice->total_left_to_pay, $invoice->currency_name) . '</td>
   </tr>';
}

$tbltotal .= '</table>';
$pdf->writeHTML($tbltotal, true, false, false, false, '');

if (get_option('total_to_words_enabled') == 1) {
    // Set the font bold
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->writeHTMLCell('', '', '', '', _l('num_word') . ': ' . $CI->numberword->convert($invoice->total, $invoice->currency_name), 0, 1, false, true, 'C', true);
    // Set the font again to normal like the rest of the pdf
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(4);
}

if (count($invoice->payments) > 0 && get_option('show_transactions_on_invoice_pdf') == 1) {
    $pdf->Ln(4);
    $border = 'border-bottom-color:#000000;border-bottom-width:1px;border-bottom-style:solid; 1px solid black;';
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_received_payments'), 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(4);
    $tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
        <tr height="20"  style="color:#000;border:1px solid #000;">
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_number_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_mode_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_date_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('invoice_payments_table_amount_heading') . '</th>
    </tr>';
    $tblhtml .= '<tbody>';
    foreach ($invoice->payments as $payment) {
        $payment_name = $payment['name'];
        if (!empty($payment['paymentmethod'])) {
            $payment_name .= ' - ' . $payment['paymentmethod'];
        }
        $tblhtml .= '
            <tr>
            <td>' . $payment['paymentid'] . '</td>
            <td>' . $payment_name . '</td>
            <td>' . _d($payment['date']) . '</td>
            <td>' . app_format_money($payment['amount'], $invoice->currency_name) . '</td>
            </tr>
        ';
    }
    $tblhtml .= '</tbody>';
    $tblhtml .= '</table>';
    $pdf->writeHTML($tblhtml, true, false, false, false, '');
}

if (found_invoice_mode($payment_modes, $invoice->id, true, true)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_html_offline_payment'), 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);

    foreach ($payment_modes as $mode) {
        if (is_numeric($mode['id'])) {
            if (!is_payment_mode_allowed_for_invoice($mode['id'], $invoice->id)) {
                continue;
            }
        }
        if (isset($mode['show_on_pdf']) && $mode['show_on_pdf'] == 1) {
            $pdf->Ln(1);
            $pdf->Cell(0, 0, $mode['name'], 0, 1, 'L', 0, '', 0);
            $pdf->Ln(2);
            $pdf->writeHTMLCell('', '', '', '', $mode['description'], 0, 1, false, true, 'L', true);
        }
    }
}




$display_currency = '';
$data_items = hooks()->apply_filters('invoice_html_pdf_data', $invoice);

$settings['vat_payer'] = (int)get_option('settings_company_vat_payer');
$settings['vat_on_collection'] = (int)get_option('settings_company_vat_on_collection');
if($settings['vat_on_collection'] == 1){
  $display_vat_collection = '<p>'._l('invoice_notice_vat_on_collection').'</p>';
  $pdf->writeHTML($display_vat_collection, true, false, false, false, '');
}


$currencies = [];

foreach($data_items->items as $itemdata){
  if($itemdata['currency_name'] == $invoice->currency_name){ continue; }
$currencies[$itemdata['currency_name'].'_'.$itemdata['currency_rate']] = '1 '.$itemdata['currency_name'].' = '.$itemdata['currency_rate'].' '.$invoice->currency_name.'<br />';
}
if(!empty($currencies)){
$display_currency = implode(' ',$currencies);
}

$pdf->writeHTML($display_currency, true, false, false, false, '');

 */

/* if (!empty($invoice->clientnote)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('invoice_note'), 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $invoice->clientnote, 0, 1, false, true, 'L', true);
}

if (!empty($invoice->terms)) {
    $pdf->Ln(4);
    $pdf->SetFont($font_name, 'B', $font_size);
    $pdf->Cell(0, 0, _l('terms_and_conditions'), 0, 1, 'L', 0, '', 0);
    $pdf->SetFont($font_name, '', $font_size);
    $pdf->Ln(2);
    $pdf->writeHTMLCell('', '', '', '', $invoice->terms, 0, 1, false, true, 'L', true);
} */
