'use strict';

import ItemableService from './itemableService.js';
import TemplateService from '../templates/templateService.js';
import TestItems from './testItems.js';

document.addEventListener('DOMContentLoaded', async function () {
  const testItems = new TestItems();

  // Fetch invoice items
  testItems.getItems(invoiceID).subscribe(
    (data) => {
      console.log(data);
    },
    (error) => {
      console.error('Error fetching items:', error);
    }
  );

  const testItemsContainer = document.getElementById('invoice_itamable_items');

  testItems.items$.subscribe((items) => {
    const renderedItems = items.map((item, index) =>
      testItems.renderTemplate(testItems.getItemTemplate(), { item, index })
    );
    testItemsContainer.innerHTML = renderedItems.join('');

    // Handler to open the delete modal
    $('.deleteInvoiceItem').on('click', async function () {
      await TemplateService.checkAndRemoveModal('deleteInvoiceItem');
      const itemIndex = $(this).data('item-index');

      const modalTemplate = testItems.getItemDeleteModalTemplate(itemIndex, 'deleteInvoiceItem');
      $('#modals').append(modalTemplate);
      $('#deleteInvoiceItem').modal('show');

      $('#invoice_itamable_itemsModalEditDelete' + itemIndex).on('click', function () {
        // Call deleteItem function or perform any desired action
        testItems.deleteItem(itemIndex).pipe(
          rxjs.take(1)
        ).subscribe(
          (response) => {

          },
          (error) => {

          }
        );

        // Hide the modal
        TemplateService.hideAndRemoveAModal('#deleteInvoiceItem');
      });
    });

    // Handler to open the edit modal
    $('.editInvoiceItem').on('click', async function () {
      await TemplateService.checkAndRemoveModal('editInvoiceItem');
      const itemIndex = $(this).data('item-index');
      testItems.setItem(itemIndex).pipe(
        rxjs.switchMap(() => testItems.item$),
        rxjs.take(1)
      ).subscribe((selectedItem) => {
        // Handle the selected item
        const renderedTemplate = testItems.getItemFormModal(itemIndex, 'editInvoiceItem', selectedItem);

        // Append and show
        $('#modals').append(renderedTemplate);
        $('#editInvoiceItem').modal('show');

        // Add event listener to the submit button in the form modal
        const submitButton = document.getElementById(`invoice_itemable_itemsModalEditSubmit_${itemIndex}`);
        submitButton.addEventListener('click', (event) => {
          event.preventDefault();
        
          // Retrieve the updated form values
          const updatedItem = {
            description: document.getElementById(`item_description_${itemIndex}`).value,
            long_description: document.getElementById(`item_long_description_${itemIndex}`).value,
            sku: document.getElementById(`item_sku_${itemIndex}`).value,
            qty: document.getElementById(`item_qty_${itemIndex}`).value,
            taxname: document.getElementById(`item_cota_${itemIndex}`).value,
            currency: document.getElementById(`item_currency_${itemIndex}`).value,
            rate: document.getElementById(`item_price_converted_${itemIndex}`).value,
            unit: document.getElementById(`item_um_${itemIndex}`).value,
          };
        
          // Update the item in items$ BehaviorSubject with the updated item
          testItems.updateItem(itemIndex, updatedItem).subscribe((updatedItems) => {
            // Handle the updated items as needed
            console.log(updatedItems);
          });
        
          // Hide the modal
          TemplateService.hideAndRemoveAModal(`#editInvoiceItem`);
        });
      });
    });
  });

  // Get the element by its ID
  const itemAddButton = document.getElementById('itemable_item_add');

  // Add a click event listener to the element
  itemAddButton.addEventListener('click', function() {
    // Code to be executed when the element is clicked
    // You can add your custom logic or function call here
    console.log('clk');
});
});
