class Itemable {
  
    constructor(data = {}) {
      // Validate data
      if (typeof data !== 'object' || data === null) {
        throw new Error('Invalid data. Please provide an object.');
      }

  
      this.id = data.id || null;
      this.rel_id = data.rel_id || null;
      this.rel_type = data.rel_type || null;
      this.description = data.description || null;
      this.long_description = data.long_description || null;
      this.qty = data.qty || null;
      this.rate = data.rate || null;
      this.unit = data.unit || null;
      this.item_order = data.item_order || null;
      this.type = data.type || null;
      this.item_id = data.item_id || null;
      this.price_converted = data.price_converted || null;
      this.currency_rate = data.currency_rate || null;
      this.currency = data.currency || null;
      this.sku = data.sku || null;
      this.taxname = data.taxname || null;
      this.currency_name = data.currency_name || null;
      this.taxes = data.taxes || [];
      this.currencies = data.currencies || [];
    }
  
    // Add additional methods if needed to perform operations on the table data
  }
  
  export default Itemable;
  