class TemplateService {
    static loadTemplate(url) {
        return new rxjs.Observable((observer) => {
            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'html',
                success: (template) => {
                    observer.next(template);
                    observer.complete();
                },
                error: (xhr) => {
                    console.error('Error loading template:', xhr.statusText);
                    observer.error(xhr.statusText);
                },
            });
        });
    }

    static hideAndRemoveAModal(elem) {
        $(elem).modal('hide');
        return new Promise((resolve) => {
          setTimeout(() => {
            $(elem).modal('hide');
            $('#modals').empty();
            resolve();
          }, 500); // 500 seems to be fine as tested
        });
      }

    static async checkAndRemoveModal(id) {
        if (TemplateService.isModalInBody(id)) {
          await TemplateService.hideAndRemoveAModal(id);
        }
      }

    static isModalInBody(modalId) {
        return $(`#${modalId}`).length > 0;
    }
}

export default TemplateService;
