DROP TABLE `app_alertlog`, `app_checks`, `app_checks_alerts`, `app_checks_history`, `app_checks_incidents`, `app_contacts`, `app_dnsbls`, `app_groups`, `app_pages`, `app_servers`, `app_servers_alerts`, `app_servers_history`, `app_servers_incidents`, `app_websites`, `app_websites_alerts`, `app_websites_history`, `app_websites_incidents`, `tblactivity_log`, `tblannouncements`, `tblapplicable_staff`, `tblappointly_appointments`, `tblappointly_appointment_types`, `tblappointly_attendees`, `tblappointly_callbacks`, `tblappointly_callbacks_assignees`, `tblappointly_google`, `tblassets`, `tblassets_acction_1`, `tblassets_acction_2`, `tblassets_group`, `tblasset_location`, `tblasset_unit`, `tblbilling_bank`, `tblbilling_notifications`, `tblbilling_series`, `tblbilling_settings`, `tblbilling_template`, `tblcart`, `tblcart_detailt`, `tblcd_care`, `tblcd_family_infor`, `tblcd_interview`, `tblcd_literacy`, `tblcd_skill`, `tblcd_work_experience`, `tblchatclientmessages`, `tblchatgroupmembers`, `tblchatgroupmessages`, `tblchatgroups`, `tblchatgroupsharedfiles`, `tblchatmessages`, `tblchatsettings`, `tblchatsharedfiles`, `tblcities`, `tblclientchatsettings`, `tblclients`, `tblcommission`, `tblcommission_hierarchy`, `tblcommission_policy`, `tblcommission_receipt`, `tblcommission_receipt_detail`, `tblcommission_salesadmin_group`, `tblconsents`, `tblconsent_purposes`, `tblcontacts`, `tblcontact_permissions`, `tblcontracts`, `tblcontracts_types`, `tblcontract_comments`, `tblcontract_renewals`, `tblcountries`, `tblcreditnotes`, `tblcreditnote_refunds`, `tblcredits`, `tblcurrencies`, `tblcustomers_groups`, `tblcustomer_admins`, `tblcustomer_groups`, `tblcustomfields`, `tblcustomfieldsvalues`, `tblcustom_templates`, `tbldepartments`, `tbldesignations`, `tbldiagramy`, `tbldiagramy_groups`, `tbldismissed_announcements`, `tbledi_configurations`, `tbledi_invoice_sender`, `tblemaillists`, `tblemailtemplates`, `tblestimates`, `tblevents`, `tblexpenses`, `tblexpenses_categories`, `tblfiles`, `tblform_questions`, `tblform_question_box`, `tblform_question_box_description`, `tblform_results`, `tblgdpr_requests`, `tblgoals`, `tblgoods_delivery`, `tblgoods_delivery_detail`, `tblgoods_delivery_invoices_pr_orders`, `tblgoods_receipt`, `tblgoods_receipt_detail`, `tblgoods_transaction_detail`, `tblhpyevents`, `tblhpyevent_minutes`, `tblhpysubscriptions`, `tblhpysubscriptions_has_categ`, `tblhpysubscription_categ`, `tblhr_awards`, `tblhr_award_types`, `tblhr_checkins`, `tblhr_company_locations`, `tblhr_complaints`, `tblhr_complaints_status`, `tblhr_departments`, `tblhr_documents`, `tblhr_document_categories`, `tblhr_document_types`, `tblhr_employees`, `tblhr_end_contracts`, `tblhr_end_contract_types`, `tblhr_holidays`, `tblhr_locations`, `tblhr_promotions`, `tblhr_resignations`, `tblhr_shifts`, `tblhr_shift_days`, `tblhr_transfers`, `tblhr_travels`, `tblhr_travel_modes`, `tblhr_travel_types`, `tblhr_warnings`, `tblhr_workshops`, `tblhr_workshop_employees`, `tblhr_workshop_types`, `tblindustries`, `tblinternal_delivery_note`, `tblinternal_delivery_note_detail`, `tblinventory_commodity_min`, `tblinventory_history`, `tblinventory_manage`, `tblinvoicepaymentrecords`, `tblinvoices`, `tblinvoice_products`, `tblitemable`, `tblitems`, `tblitems_groups`, `tblitem_tax`, `tbljob_industry`, `tblknowedge_base_article_feedback`, `tblknowledgebasecategorys`, `tblknowledgebaseclients`, `tblknowledgebasegroups`, `tblknowledgebaseproducts`, `tblknowledgebaseservices`, `tblknowledgebase_has_categories`, `tblknowledgebase_has_groups`, `tblknowledgebase_has_products`, `tblknowledgebase_has_services`, `tblknowledge_base`, `tblknowledge_base_groups`, `tblleads`, `tblleads_assigment`, `tblleads_email_integration`, `tblleads_pipeline`, `tblleads_sources`, `tblleads_status`, `tbllead_activity_log`, `tbllead_integration_emails`, `tbllead_lost_reasons`, `tbllistemails`, `tbllist_widget`, `tbllog_ep`, `tblmaillistscustomfields`, `tblmaillistscustomfieldvalues`, `tblmail_attachment`, `tblmail_inbox`, `tblmail_outbox`, `tblmail_queue`, `tblmigrations`, `tblmilestones`, `tblminutes`, `tblminutes_files`, `tblminutes_members`, `tblminutes_tasks`, `tblmodules`, `tblnewsfeed_comment_likes`, `tblnewsfeed_posts`, `tblnewsfeed_post_comments`, `tblnewsfeed_post_likes`, `tblnir`, `tblnir_products`, `tblnotes`, `tblnotifications`, `tblnumber_employees`, `tblokrs`, `tblokrs_checkin`, `tblokrs_checkin_log`, `tblokrs_key_result`, `tblokrs_key_result_log`, `tblokrs_log`, `tblokr_approval_details`, `tblokr_approval_setting`, `tblokr_setting_category`, `tblokr_setting_circulation`, `tblokr_setting_evaluation_criteria`, `tblokr_setting_question`, `tblokr_setting_unit`, `tblomni_create_customer_report`, `tblomni_create_customer_report_detail`, `tblomni_customer_report`, `tblomni_log_discount`, `tblomni_log_sync_woo`, `tblomni_master_channel_woocommere`, `tblomni_setting_woo_store`, `tblomni_trade_discount`, `tblopportunities_status`, `tbloptions`, `tblpayment_modes`, `tblpermission`, `tblpinned_projects`, `tblproduct`, `tblproducts_groups`, `tblproduct_categ`, `tblproduct_purchase_log`, `tblproformapaymentrecords`, `tblproformas`, `tblprojectdiscussioncomments`, `tblprojectdiscussions`, `tblprojects`, `tblproject_activity`, `tblproject_files`, `tblproject_members`, `tblproject_notes`, `tblproject_settings`, `tblproposals`, `tblproposal_comments`, `tblpurchase_option`, `tblpur_approval_details`, `tblpur_approval_setting`, `tblpur_contacts`, `tblpur_contracts`, `tblpur_estimates`, `tblpur_estimate_detail`, `tblpur_invoices`, `tblpur_invoice_payment`;
DROP TABLE `tblpur_orders`, `tblpur_order_detail`, `tblpur_order_payment`, `tblpur_request`, `tblpur_request_detail`, `tblpur_unit`, `tblpur_vendor`, `tblpur_vendor_admin`, `tblpur_vendor_cate`, `tblpur_vendor_items`, `tblrec_campaign`, `tblrec_campaign_form_web`, `tblrec_candidate`, `tblrec_cd_evaluation`, `tblrec_company`, `tblrec_criteria`, `tblrec_evaluation_form`, `tblrec_interview`, `tblrec_job_position`, `tblrec_list_criteria`, `tblrec_proposal`, `tblrec_set_transfer_record`, `tblrec_skill`, `tblrelated_items`, `tblremarketing`, `tblreminders`, `tblroles`, `tblsales_activity`, `tblsales_channel`, `tblsales_channel_detailt`, `tblsales_kpi_category`, `tblscheduled_emails`, `tblservices`, `tblservicii`, `tblservicii_categ`, `tblservicii_zones`, `tblsessions`, `tblshared_customer_files`, `tblsi_export_customer_kyc_files`, `tblsi_export_customer_services`, `tblspam_filters`, `tblstaff`, `tblstaff_departments`, `tblstaff_permissions`, `tblstandard_workload`, `tblstates`, `tblstock_take`, `tblstock_take_detail`, `tblsubscriptions`, `tblsubscription_products`, `tblsuppliers`, `tblsuppliers_categ`, `tblsurveyresultsets`, `tblsurveys`, `tblsurveysemailsendcron`, `tblsurveysendlog`, `tbltaggables`, `tbltags`, `tbltasks`, `tbltaskstimers`, `tbltasks_checklist_templates`, `tbltask_assigned`, `tbltask_checklist_items`, `tbltask_comments`, `tbltask_followers`, `tbltaxes`, `tblteam_password_category`, `tbltemplates`, `tbltickets`, `tbltickets_pipe_log`, `tbltickets_predefined_replies`, `tbltickets_priorities`, `tbltickets_status`, `tblticket_attachments`, `tblticket_replies`, `tbltodos`, `tbltp_bank_account`, `tbltp_credit_card`, `tbltp_email`, `tbltp_logs`, `tbltp_normal`, `tbltp_server`, `tbltp_share`, `tbltp_software_license`, `tbltracked_mails`, `tblturnovers`, `tbltwocheckout_log`, `tbluser_api`, `tbluser_auto_login`, `tbluser_meta`, `tblvault`, `tblviews_tracking`, `tblwarehouse`, `tblware_body_type`, `tblware_color`, `tblware_commodity_type`, `tblware_size_type`, `tblware_style_type`, `tblware_unit_type`, `tblweb_to_lead`, `tblweb_to_recruitment`, `tblwh_activity_log`, `tblwh_approval_details`, `tblwh_approval_setting`, `tblwh_brand`, `tblwh_custom_fields`, `tblwh_loss_adjustment`, `tblwh_loss_adjustment_detail`, `tblwh_model`, `tblwh_series`, `tblwh_sub_group`, `tblwoocommere_store`, `tblwoocommere_store_detailt`, `tblworkload_dayoff`, `tblzones`, `tbl_crmcon_email_builder`;



CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL,
  `description` mediumtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tblmigrations`
--

CREATE TABLE `tblmigrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tblmodules`
--

CREATE TABLE `tblmodules` (
  `id` int(11) NOT NULL,
  `module_name` varchar(55) NOT NULL,
  `installed_version` varchar(11) NOT NULL,
  `active` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tbloptions`
--

CREATE TABLE `tbloptions` (
  `id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `value` longtext NOT NULL,
  `autoload` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tblsessions`
--

CREATE TABLE `tblsessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tblstaff`
--

CREATE TABLE `tblstaff` (
  `staffid` int(11) NOT NULL,
  `email` varchar(100) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `facebook` mediumtext DEFAULT NULL,
  `linkedin` mediumtext DEFAULT NULL,
  `phonenumber` varchar(30) DEFAULT NULL,
  `skype` varchar(50) DEFAULT NULL,
  `password` varchar(250) NOT NULL,
  `datecreated` datetime NOT NULL,
  `profile_image` varchar(191) DEFAULT NULL,
  `last_ip` varchar(40) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_activity` datetime DEFAULT NULL,
  `last_password_change` datetime DEFAULT NULL,
  `new_pass_key` varchar(32) DEFAULT NULL,
  `new_pass_key_requested` datetime DEFAULT NULL,
  `admin` int(11) NOT NULL DEFAULT 0,
  `role` int(11) DEFAULT NULL,
  `active` int(11) NOT NULL DEFAULT 1,
  `default_language` varchar(40) DEFAULT NULL,
  `direction` varchar(3) DEFAULT NULL,
  `media_path_slug` varchar(191) DEFAULT NULL,
  `is_not_staff` int(11) NOT NULL DEFAULT 0,
  `hourly_rate` decimal(15,2) NOT NULL DEFAULT 0.00,
  `two_factor_auth_enabled` tinyint(1) DEFAULT 0,
  `two_factor_auth_code` varchar(100) DEFAULT NULL,
  `two_factor_auth_code_requested` datetime DEFAULT NULL,
  `email_signature` text DEFAULT NULL,
  `google_auth_secret` text DEFAULT NULL,
  `mail_password` varchar(250) DEFAULT NULL,
  `mail_signature` varchar(250) DEFAULT NULL,
  `last_email_check` varchar(50) DEFAULT NULL,
  `is_super_admin` tinyint(1) DEFAULT 0,
  `address` varchar(255) DEFAULT NULL,
  `birthdate` datetime DEFAULT NULL,
  `gender` enum('male','female') DEFAULT NULL,
  `sales_kpi_category` int(11) DEFAULT NULL,
  `country` int(11) DEFAULT NULL,
  `state` varchar(75) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(150) DEFAULT NULL,
  `token` varchar(64) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tbluser_api`
--

CREATE TABLE `tbluser_api` (
  `id` int(11) NOT NULL,
  `user` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `token` varchar(255) NOT NULL,
  `expiration_date` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `tblactivity_log`
--
ALTER TABLE `tblactivity_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `staffid` (`staffid`);

--
-- Indexes for table `tblmodules`
--
ALTER TABLE `tblmodules`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tbloptions`
--
ALTER TABLE `tbloptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `name` (`name`);

--
-- Indexes for table `tblsessions`
--
ALTER TABLE `tblsessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ci_sessions_timestamp` (`timestamp`);

--
-- Indexes for table `tblstaff`
--
ALTER TABLE `tblstaff`
  ADD PRIMARY KEY (`staffid`),
  ADD KEY `firstname` (`firstname`),
  ADD KEY `lastname` (`lastname`);

--
-- Indexes for table `tbluser_api`
--
ALTER TABLE `tbluser_api`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `tblactivity_log`
--
ALTER TABLE `tblactivity_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tblmodules`
--
ALTER TABLE `tblmodules`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbloptions`
--
ALTER TABLE `tbloptions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tblstaff`
--
ALTER TABLE `tblstaff`
  MODIFY `staffid` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `tbluser_api`
--
ALTER TABLE `tbluser_api`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;



INSERT INTO `tblmigrations` (`version`) VALUES
(99);




CREATE TABLE `app_alertlog` (
  `id` int(11) NOT NULL,
  `contactid` int(11) NOT NULL,
  `contactname` varchar(255) NOT NULL,
  `date` datetime NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobilenumber` varchar(255) NOT NULL,
  `pushbullet` varchar(255) NOT NULL,
  `twitter` varchar(255) NOT NULL,
  `pushover` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_checks`
--

CREATE TABLE `app_checks` (
  `id` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `common` varchar(12) NOT NULL,
  `type` varchar(12) NOT NULL,
  `port` varchar(12) NOT NULL,
  `timeout` int(11) NOT NULL,
  `host` varchar(512) NOT NULL,
  `send` text NOT NULL,
  `expect` text NOT NULL,
  `status` int(1) NOT NULL,
  `geodata` text NOT NULL,
  `on_map` int(1) NOT NULL,
  `lat` varchar(32) NOT NULL,
  `lng` varchar(32) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_checks_alerts`
--

CREATE TABLE `app_checks_alerts` (
  `id` int(11) NOT NULL,
  `checkid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  `comparison` varchar(25) NOT NULL,
  `comparison_limit` varchar(100) NOT NULL,
  `occurrences` int(10) NOT NULL DEFAULT 1,
  `contacts` text NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_checks_history`
--

CREATE TABLE `app_checks_history` (
  `id` int(11) NOT NULL,
  `checkid` int(11) NOT NULL,
  `timestamp` datetime NOT NULL,
  `latency` varchar(10) NOT NULL,
  `statuscode` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_checks_incidents`
--

CREATE TABLE `app_checks_incidents` (
  `id` int(11) NOT NULL,
  `checkid` int(11) NOT NULL,
  `alertid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  `comparison` varchar(25) NOT NULL,
  `comparison_limit` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_contacts`
--

CREATE TABLE `app_contacts` (
  `id` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobilenumber` varchar(255) NOT NULL,
  `pushbullet` varchar(255) NOT NULL,
  `twitter` varchar(255) NOT NULL,
  `pushover` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_dnsbls`
--

CREATE TABLE `app_dnsbls` (
  `id` int(11) NOT NULL,
  `host` varchar(64) NOT NULL,
  `host_name` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_groups`
--

CREATE TABLE `app_groups` (
  `id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_pages`
--

CREATE TABLE `app_pages` (
  `id` int(11) NOT NULL,
  `pagekey` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `info` text NOT NULL,
  `servers` text NOT NULL,
  `websites` text NOT NULL,
  `checks` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_servers`
--

CREATE TABLE `app_servers` (
  `id` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  `type` varchar(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `serverkey` varchar(64) NOT NULL,
  `status` int(1) NOT NULL,
  `geodata` text NOT NULL,
  `on_map` int(1) NOT NULL,
  `lat` varchar(32) NOT NULL,
  `lng` varchar(32) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_servers_alerts`
--

CREATE TABLE `app_servers_alerts` (
  `id` int(11) NOT NULL,
  `serverid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  `comparison` varchar(25) NOT NULL,
  `comparison_limit` varchar(100) NOT NULL,
  `occurrences` int(10) NOT NULL,
  `contacts` text NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_servers_history`
--

CREATE TABLE `app_servers_history` (
  `id` int(11) NOT NULL,
  `serverid` int(11) NOT NULL,
  `timestamp` datetime NOT NULL,
  `data` blob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- --------------------------------------------------------

--
-- Table structure for table `app_servers_incidents`
--

CREATE TABLE `app_servers_incidents` (
  `id` int(11) NOT NULL,
  `serverid` int(11) NOT NULL,
  `alertid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  `comparison` varchar(25) NOT NULL,
  `comparison_limit` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_websites`
--

CREATE TABLE `app_websites` (
  `id` int(11) NOT NULL,
  `groupid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `expect` text NOT NULL,
  `timeout` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  `geodata` text NOT NULL,
  `on_map` int(1) NOT NULL,
  `lat` varchar(32) NOT NULL,
  `lng` varchar(32) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_websites_alerts`
--

CREATE TABLE `app_websites_alerts` (
  `id` int(11) NOT NULL,
  `websiteid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  `comparison` varchar(25) NOT NULL,
  `comparison_limit` varchar(100) NOT NULL,
  `occurrences` int(10) NOT NULL,
  `contacts` text NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_websites_history`
--

CREATE TABLE `app_websites_history` (
  `id` int(11) NOT NULL,
  `websiteid` int(11) NOT NULL,
  `timestamp` datetime NOT NULL,
  `latency` varchar(10) NOT NULL,
  `statuscode` varchar(10) NOT NULL,
  `has_expected` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `app_websites_incidents`
--

CREATE TABLE `app_websites_incidents` (
  `id` int(11) NOT NULL,
  `websiteid` int(11) NOT NULL,
  `alertid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  `comparison` varchar(25) NOT NULL,
  `comparison_limit` varchar(100) NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `status` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `app_alertlog`
--
ALTER TABLE `app_alertlog`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_checks`
--
ALTER TABLE `app_checks`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_checks_alerts`
--
ALTER TABLE `app_checks_alerts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `checkid` (`checkid`);

--
-- Indexes for table `app_checks_history`
--
ALTER TABLE `app_checks_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `checkid` (`checkid`),
  ADD KEY `timestamp` (`timestamp`);

--
-- Indexes for table `app_checks_incidents`
--
ALTER TABLE `app_checks_incidents`
  ADD PRIMARY KEY (`id`),
  ADD KEY `serverid` (`checkid`);

--
-- Indexes for table `app_contacts`
--
ALTER TABLE `app_contacts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_dnsbls`
--
ALTER TABLE `app_dnsbls`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `host` (`host`);

--
-- Indexes for table `app_groups`
--
ALTER TABLE `app_groups`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_pages`
--
ALTER TABLE `app_pages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_servers`
--
ALTER TABLE `app_servers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `serverkey` (`serverkey`);

--
-- Indexes for table `app_servers_alerts`
--
ALTER TABLE `app_servers_alerts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `serverid` (`serverid`);

--
-- Indexes for table `app_servers_history`
--
ALTER TABLE `app_servers_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `serverid` (`serverid`),
  ADD KEY `timestamp` (`timestamp`);

--
-- Indexes for table `app_servers_incidents`
--
ALTER TABLE `app_servers_incidents`
  ADD PRIMARY KEY (`id`),
  ADD KEY `serverid` (`serverid`);

--
-- Indexes for table `app_websites`
--
ALTER TABLE `app_websites`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `app_websites_alerts`
--
ALTER TABLE `app_websites_alerts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `websiteid` (`websiteid`);

--
-- Indexes for table `app_websites_history`
--
ALTER TABLE `app_websites_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `websiteid` (`websiteid`),
  ADD KEY `timestamp` (`timestamp`);

--
-- Indexes for table `app_websites_incidents`
--
ALTER TABLE `app_websites_incidents`
  ADD PRIMARY KEY (`id`),
  ADD KEY `serverid` (`websiteid`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `app_alertlog`
--
ALTER TABLE `app_alertlog`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_checks`
--
ALTER TABLE `app_checks`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_checks_alerts`
--
ALTER TABLE `app_checks_alerts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_checks_history`
--
ALTER TABLE `app_checks_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_checks_incidents`
--
ALTER TABLE `app_checks_incidents`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_contacts`
--
ALTER TABLE `app_contacts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_dnsbls`
--
ALTER TABLE `app_dnsbls`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_groups`
--
ALTER TABLE `app_groups`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_pages`
--
ALTER TABLE `app_pages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_servers`
--
ALTER TABLE `app_servers`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_servers_alerts`
--
ALTER TABLE `app_servers_alerts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_servers_history`
--
ALTER TABLE `app_servers_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_servers_incidents`
--
ALTER TABLE `app_servers_incidents`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_websites`
--
ALTER TABLE `app_websites`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_websites_alerts`
--
ALTER TABLE `app_websites_alerts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_websites_history`
--
ALTER TABLE `app_websites_history`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `app_websites_incidents`
--
ALTER TABLE `app_websites_incidents`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;



  CREATE TABLE `tblmodules` (
    `id` int(11) NOT NULL,
    `module_name` varchar(55) NOT NULL,
    `installed_version` varchar(11) NOT NULL,
    `active` tinyint(1) NOT NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  --
  -- Indexes for dumped tables
  --

  --
  -- Indexes for table `tblmodules`
  --
  ALTER TABLE `tblmodules`
    ADD PRIMARY KEY (`id`);

  --
  -- AUTO_INCREMENT for dumped tables
  --

  --
  -- AUTO_INCREMENT for table `tblmodules`
  --
  ALTER TABLE `tblmodules`
    MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

  INSERT INTO `tblmodules` (`module_name`, `installed_version`, `active`) VALUES
  ('appointly', '1.1.0', 0),
  ('api', '1.0.0', 1),
  ('commission', '1.0.6', 0),
  ('backup', '2.3.0', 0),
  ('custom_email_and_sms_notifications', '2.3.0', 0),
  ('diagramy', '1.0.2', 0),
  ('facebook_leads_integration', '1.0.0', 0),
  ('goals', '2.3.0', 0),
  ('mailbox', '1.0.0', 0),
  ('menu_setup', '2.3.0', 1),
  ('okr', '1.0.2', 0),
  ('omni_sales', '1.0.1', 0),
  ('crmcon_email_builder', '2.0.1', 0),
  ('prchat', '1.4.7', 0),
  ('project_roadmap', '1.0.0', 0),
  ('purchase', '1.0.9', 0),
  ('recruitment', '1.1.5', 0),
  ('resource_workload', '1.0.5', 0),
  ('services', '1.2.4', 0),
  ('si_export_customer', '1.0.1', 0),
  ('surveys', '2.3.0', 0),
  ('team_password', '1.0.8', 0),
  ('theme_style', '2.3.0', 1),
  ('warehouse', '1.3.1', 0),
  ('whatsapp_chat', '1.0', 1),
  ('assets', '1.1.0', 0),
  ('remarketing', '2.3.0', 1),
  ('scoring', '1.0.0', 0),
  ('menu_builder', '1.0.4', 1),
  ('billing', '2.3.0', 1),
  ('hr', '2.0.0',0),
  ('prchat_crmcon', '1.0.0', 0),
  ('dashboards', '1.0.0', 0),
  ('essential_package', '1.0.0', 0),
  ('startup_package', '1.0.0', 0),
  ('pro_package', '1.0.0', 0),
  ('minutes', '1.0.0', 0);

INSERT INTO `tbloptions` (`name`, `value`, `autoload`) VALUES
('default_timezone', 'Europe/Bucharest', 1),
('clients_default_theme', 'crmconnect', 1);

CREATE TABLE `tbluser_auto_login` ( `key_id` VARCHAR(75) DEFAULT NULL , `user_id` INT(11) NOT NULL ,`staff` INT(11) NOT NULL , `user_agent` VARCHAR(150) NULL DEFAULT NULL , `last_ip` VARCHAR(40) NULL DEFAULT NULL , `last_login` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ) ENGINE = InnoDB;
