<?php

defined('BASEPATH') or exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require __DIR__.'/REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Crm_active_package extends REST_Controller
{
    public function __construct()
    {
        // Construct the parent class
        parent::__construct();
    }


    public function data_get($id = '')
    {

        $data = $this->Api_model->get_table('active_package', $id);
        if ($data) {
            $this->response($data, REST_Controller::HTTP_OK);
        } else {
            $this->response(['status' => false,'message' => 'No data were found'], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function data_search_get()
    {
        
        
    }

    public function data_post()
    {
        // Retrieve the package number from the POST request and cast it to an integer startup_package
        $package_number = (int)$this->input->post('package_number');
    
        // Define a mapping of package numbers to package names
        $packageMapping = [
            1 => 'essential_package',
            2 => 'essential_package',
            3 => 'pro_package',
        ];
    
        // Validate the package number
        if ($package_number && array_key_exists($package_number, $packageMapping)) {
            // Get the corresponding package name
            $package_name = $packageMapping[$package_number];
            
            // load the app modules
            $this->load->library('app_modules');


            // Deactivate packages above the given one
            for ($i = $package_number + 1; $i <= count($packageMapping); $i++) {
                $this->app_modules->deactivate($packageMapping[$i]);
            }
        

            $this->app_modules->activate($package_name);
            $data['status'] = $this->module_model->is_active($package_name);
    
            // Optionally, you can return a response indicating success
            $response = [
                'message' => $data['status'],
                'package_name' => $package_name,
            ];
            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($response));
        } else {
            // Invalid package number, return an error response
            $error_response = [
                'error' => 'Invalid package number',
            ];
            $this->output
                ->set_status_header(400)
                ->set_content_type('application/json')
                ->set_output(json_encode($error_response));
        }
    }
    
    

}
