<?php

defined('BASEPATH') or exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require __DIR__.'/REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Initiate_enrollment extends REST_Controller
{
    public function __construct()
    {
        // Construct the parent class
        parent::__construct();
    }


    public function data_post()
    {

      $this->load->model('packages_manager/packages_client_model');
      $subdomain = $this->Api_model->value($this->input->post('child_domain', true));
      $domain = $this->Api_model->value($this->input->post('domain', true));
      $base_url = $subdomain.'.'.$domain;
      
      $instance = $this->packages_client_model->get_base_url($base_url);
      if($instance){
        $data['status'] = false;
        $data['message'] = 'Already exists: '.$base_url;
        $data['post_data'] = $this->input->post();
      }else{
        $insert_data = [
          'install_date' => date('Y-m-d H:i:s'),
          'last_migration' => date('Y-m-d H:i:s'),
          'api_token' => null,
          'admin_user' => null,
          'admin_pass' => null,
          'instance_url' => $base_url,
          'active_package' => $this->Api_model->value($this->input->post('package', true)),
        ];

        $this->db->insert('crm_instances',$insert_data);
        $insert_id = $this->db->insert_id();
        if ($insert_id > 0 && !empty($insert_id)) {
          $instance = $this->packages_client_model->get_base_url($base_url);
          $data['status'] = true;
          $data['instance'] = $instance;
        }else{

          $data['status'] = false;
          $data['message'] = 'Not inserted';
        }

      }

      $this->response($data, REST_Controller::HTTP_OK);

    }

}
