<?php

defined('BASEPATH') or exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require __DIR__.'/REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Modulesapi extends REST_Controller
{
    public function __construct()
    {
        // Construct the parent class
        parent::__construct();
    }

    /**
     * @api {get} api/modules/:slug Request module information
     * @apiVersion 0.1.0
     * @apiName GetInvoice
     * @apiGroup Invoice
     *
     * @apiHeader {String} Authorization Basic Access Authentication token.
     *
     * @apiError {Boolean} status Request status.
     * @apiError {String} message No data were found.
     *
     * @apiParam {Number} id Contact unique ID
     *
     * @apiSuccess {Object} Invoice Invoice information.
     *
     * @apiSuccessExample Success-Response:
     *   HTTP/1.1 200 OK
     *   {
     *       "id": "2",
     *       "sent": "0",
     *       "datesend": null,
     *       "clientid": "1",
     *       "deleted_customer_name": null,
     *       "number": "2",
     *       "prefix": "INV-",
     *       "number_format": "1",
     *       "datecreated": "2020-05-26 19:53:11",
     *       "date": "2020-05-26",
     *       "duedate": "2020-06-25",
     *       "currency": "1",
     *       "subtotal": "5.00",
     *       "total_tax": "0.00",
     *       "total": "5.00",
     *       "adjustment": "0.00",
     *       "addedfrom": "0",
     *       "hash": "7bfac86da004df5364407574d4d1dbf2",
     *       "status": "1",
     *       "clientnote": null,
     *       "adminnote": null,
     *       "last_overdue_reminder": null,
     *       "cancel_overdue_reminders": "0",
     *       "allowed_payment_modes": "['1']",
     *       "token": null,
     *       "discount_percent": "0.00",
     *       "discount_total": "0.00",
     *       "discount_type": "",
     *       "recurring": "0",
     *       "recurring_type": null,
     *       "custom_recurring": "0",
     *       "cycles": "0",
     *       "total_cycles": "0",
     *       "is_recurring_from": null,
     *       "last_recurring_date": null,
     *       "terms": null,
     *       "sale_agent": "0",
     *       "billing_street": "",
     *       "billing_city": "",
     *       "billing_state": "",
     *       "billing_zip": "",
     *       "billing_country": null,
     *       "shipping_street": null,
     *       "shipping_city": null,
     *       "shipping_state": null,
     *       "shipping_zip": null,
     *       "shipping_country": null,
     *       "include_shipping": "0",
     *       "show_shipping_on_invoice": "1",
     *       "show_quantity_as": "1",
     *       "project_id": "0",
     *       "subscription_id": "0",
     *       "symbol": "$",
     *       "name": "USD",
     *       "decimal_separator": ".",
     *       "thousand_separator": ",",
     *       "placement": "before",
     *       "isdefault": "1",
     *       "currencyid": "1",
     *       "currency_name": "USD",
     *       "total_left_to_pay": "5.00",
     *       "items": [
     *        {
     *           "id": "2",
     *           "rel_id": "2",
     *           "rel_type": "invoice",
     *           "description": "12MP Dual Camera with cover",
     *           "long_description": "The JBL Cinema SB110 is a hassle-free soundbar",
     *           "qty": "1.00",
     *           "rate": "5.00",
     *           "unit": "",
     *           "item_order": "1"
     *           }
     *       ],
     *       "attachments": [],
     *       "visible_attachments_to_customer_found": false,
     *       "client": {
     *       "userid": "1",
     *       "company": "trueline",
     *       "vat": "",
     *       "phonenumber": "",
     *       "country": "0",
     *       "city": "",
     *       "zip": "",
     *       "state": "",
     *       "address": "",
     *       "website": "",
     *       "datecreated": "2020-05-19 20:07:49",
     *       "active": "1",
     *       "leadid": null,
     *       "billing_street": "",
     *       "billing_city": "",
     *       "billing_state": "",
     *       "billing_zip": "",
     *       "billing_country": "0",
     *       "shipping_street": "",
     *       "shipping_city": "",
     *       "shipping_state": "",
     *       "shipping_zip": "",
     *       "shipping_country": "0",
     *       "longitude": null,
     *       "latitude": null,
     *       "default_language": "english",
     *       "default_currency": "0",
     *       "show_primary_contact": "0",
     *       "stripe_id": null,
     *       "registration_confirmed": "1",
     *       "addedfrom": "1"
     *   },
     *   "payments": [],
     *   "scheduled_email": null
     * }
     *
     * @apiErrorExample Error-Response:
     *     HTTP/1.1 404 Not Found
     *     {
     *       "status": false,
     *       "message": "No data were found"
     *     }
     */

    public function data_get($id = '')
    {
        // If the id parameter doesn't exist return all the
        $data = $this->Api_model->get_table('modules', $id);

        // Check if the data store contains
        if ($data) {
            // Set the response and exit
            $this->response($data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
            // Set the response and exit
            $this->response([
                'status' => false,
                'message' => 'No data were found'
            ], REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }

    public function data_search_get($key = '')
    {
        $data = $this->Api_model->search('invoices', $key);
        // Check if the data store contains
        if ($data) {
            // Set the response and exit
              $this->response($data, REST_Controller::HTTP_OK); // OK (200) being the HTTP response code
        } else {
            // Set the response and exit
            $this->response([
                'status' => false,
                'message' => 'No data were found'
            ], REST_Controller::HTTP_NOT_FOUND); // NOT_FOUND (404) being the HTTP response code
        }
    }


    public function data_post()
    {
        $data = $this->input->post();

        $this->form_validation->set_rules('clientid', 'Customer', 'trim|required|max_length[255]');
        $this->form_validation->set_rules('number', 'Invoice number', 'trim|required|max_length[255]|callback_validate_invoice_number[0]');
        $this->form_validation->set_rules('date', 'Invoice date', 'trim|required|max_length[255]');
        $this->form_validation->set_rules('currency', 'Currency', 'trim|required|max_length[255]');
        $this->form_validation->set_rules('newitems[]', 'Items', 'required');
        $this->form_validation->set_rules('allowed_payment_modes[]', 'Allow Payment Mode', 'trim|required|max_length[255]');
        $this->form_validation->set_rules('billing_street', 'Billing Street', 'trim|required|max_length[255]');
        $this->form_validation->set_rules('subtotal', 'Sub Total', 'trim|required|decimal|greater_than[0]');
        $this->form_validation->set_rules('total', 'Total', 'trim|required|decimal|greater_than[0]');

        if ($this->form_validation->run() == false) {
            $message = array(
                'status' => false,
                'error' => $this->form_validation->error_array(),
                'message' => validation_errors()
            );
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
        } else {
            $this->load->model('invoices_model');

            $id = $this->invoices_model->add($data);
            if ($id > 0 && !empty($id)) {
                // success
                $message = array(
                    'status' => true,
                    'message' => 'Invoice Added Successfully'
                );
                $this->response($message, REST_Controller::HTTP_OK);
            } else {
                // error
                $message = array(
                    'status' => false,
                    'message' => 'Invoice Add Fail'
                );
                $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }

    public function data_delete($id = '')
    {
        $id = $this->security->xss_clean($id);
        if (empty($id) && !is_numeric($id)) {
            $message = array(
                'status' => false,
                'message' => 'Invalid Invoice ID'
            );
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
        } else {
            $this->load->model('invoices_model');
            $is_exist = $this->invoices_model->get($id);
            if (is_object($is_exist)) {
                $output = $this->invoices_model->delete($id);
                if ($output === true) {
                    // success
                    $message = array(
                        'status' => true,
                        'message' => 'Invoice Deleted Successfully'
                    );
                    $this->response($message, REST_Controller::HTTP_OK);
                } else {
                    // error
                    $message = array(
                        'status' => false,
                        'message' => 'Invoice Delete Fail'
                    );
                    $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                }
            } else {
                $message = array(
                    'status' => false,
                    'message' => 'Invalid Invoice ID'
                );
                $this->response($message, REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }


    public function data_put($id = '')
    {
        $_POST = json_decode($this->security->xss_clean(file_get_contents("php://input")), true);
        if (empty($_POST) || !isset($_POST)) {
            $message = array(
                'status' => false,
                'message' => 'Data Not Acceptable OR Not Provided'
            );
            $this->response($message, REST_Controller::HTTP_NOT_ACCEPTABLE);
        }
        $this->form_validation->set_data($_POST);

        if (empty($id) && !is_numeric($id)) {
            $message = array(
                'status' => false,
                'message' => 'Invalid Invoice ID'
            );
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
        } else {
            $this->form_validation->set_rules('number', 'Invoice number', 'trim|required|max_length[255]|callback_validate_invoice_number['.$id.']');
            $this->form_validation->set_rules('date', 'Invoice date', 'trim|required|max_length[255]');
            $this->form_validation->set_rules('currency', 'Currency', 'trim|required|max_length[255]');
            $this->form_validation->set_rules('newitems[]', 'Items', 'required');
            $this->form_validation->set_rules('allowed_payment_modes[]', 'Allow Payment Mode', 'trim|required|max_length[255]');
            $this->form_validation->set_rules('billing_street', 'Billing Street', 'trim|required|max_length[255]');
            $this->form_validation->set_rules('subtotal', 'Sub Total', 'trim|required|decimal|greater_than[0]');
            $this->form_validation->set_rules('total', 'Total', 'trim|required|decimal|greater_than[0]');
            if ($this->form_validation->run() == false) {
                $message = array(
                    'status' => false,
                    'error' => $this->form_validation->error_array(),
                    'message' => validation_errors()
                );
                $this->response($message, REST_Controller::HTTP_CONFLICT);
            } else {
                $this->load->model('invoices_model');
                $is_exist = $this->invoices_model->get($id);
                if (!is_object($is_exist)) {
                    $message = array(
                        'status' => false,
                        'message' => 'Invoice ID Doesn\'t Not Exist.'
                    );
                    $this->response($message, REST_Controller::HTTP_CONFLICT);
                }
                if (is_object($is_exist)) {
                    $data = $this->input->post();
                    $data['isedit'] = "";
                    $success = $this->invoices_model->update($data, $id);
                    if ($success == true) {
                        $message = array(
                            'status' => true,
                            'message' => "Invoice Updated Successfully",
                        );
                        $this->response($message, REST_Controller::HTTP_OK);
                    } else {
                        // error
                        $message = array(
                            'status' => false,
                            'message' => 'Invoice Update Fail'
                        );
                        $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                    }
                } else {
                    $message = array(
                        'status' => false,
                        'message' => 'Invalid Invoice ID'
                    );
                    $this->response($message, REST_Controller::HTTP_NOT_FOUND);
                }
            }
        }
    }



    public function is_active($slug)
    {
      return $this->module_model->is_active($slug);
    }
}
