<?php

defined('BASEPATH') or exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require __DIR__.'/REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Options extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
    }


    public function data_post()
    {

      $options = $this->input->post('options');
      if(!$options){
        $json = file_get_contents('php://input');
        // Converts it into a PHP object
        $data = json_decode($json,true);
        $options = $data['options'];
        $update_users = $data['update_users'];

      }

      if(!empty($options)){
      foreach($options as $key=>$value){
        update_option($key,$value);
      }}

      if(!empty($update_users)){
      foreach($update_users as $key=>$user){
       
        $update_user = [];
        if(isset($user['email'])){ $update_user['email'] = $user['email']; }
        if(isset($user['password'])){  $password = app_hash_password($user['password']); $update_user['password'] = $password; }

        if(isset($user['firstname'])){ $update_user['firstname'] = $user['firstname']; }
        if(isset($user['lastname'])){ $update_user['lastname'] = $user['lastname']; }
        
        // We will keep on update here
        // to do insert and keep initial user from deploy
        $this->db->where('staffid', $user['id']);
        $this->db->update('staff', $update_user);
        $data['updated_users'][] = $user;
      }}

      $data['status'] = true;
      $data['v'] = '1.0.2';      
      $this->response($data, REST_Controller::HTTP_OK);

    }


    public function data_get()
    {
      $key = $this->Api_model->value($this->input->get('key', true));
      $data['value'] = get_option($key);
      $data['key'] = $key;
      $data['status'] = true;
      $this->response($data, REST_Controller::HTTP_OK);
    }

}
