<?php

defined('BASEPATH') or exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
require __DIR__.'/REST_Controller.php';

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @package         CodeIgniter
 * @subpackage      Rest Server
 * @category        Controller
 * @author          Phil Sturgeon, Chris Kacerguis
 * @license         MIT
 * @link            https://github.com/chriskacerguis/codeigniter-restserver
 */
class Register_crm extends REST_Controller
{
    public function __construct()
    {
        // Construct the parent class
        parent::__construct();
    }

    public function data_post()
    {

      $this->load->model('packages_manager/packages_client_model');
      $instance = $this->packages_client_model->get_base_url($this->Api_model->value($this->input->post('base_url', true)));
      if($instance){

        $this->db->where('id',$instance->id)->update('crm_instances',[
          'install_date' => $this->Api_model->value($this->input->post('install_date', true)),
          'last_migration' => $this->Api_model->value($this->input->post('last_migration', true)),
          'api_token' => $this->Api_model->value($this->input->post('api_token', true)),
          'active_package' => $this->Api_model->value($this->input->post('active_package', true)),
        ]);

            $message = array(
                'status' => true,
                'message' => 'CRM update successful.'
            );
            $this->response($message, REST_Controller::HTTP_OK);

      }else{
        $url = $this->Api_model->value($this->input->post('base_url', true));
        $url = str_replace('https://','',$url);
        $url = str_replace('http://','',$url);
        $url = str_replace('www.','',$url);

        $insert_data = [
          'install_date' => $this->Api_model->value($this->input->post('install_date', true)),
          'last_migration' => $this->Api_model->value($this->input->post('last_migration', true)),
          'api_token' => $this->Api_model->value($this->input->post('api_token', true)),
          'admin_user' => $this->Api_model->value($this->input->post('admin_user', true)),
          'admin_pass' => $this->Api_model->value($this->input->post('admin_pass', true)),
          'instance_url' => $url,
          'active_package' => $this->Api_model->value($this->input->post('active_package', true)),
        ];

        $this->db->insert('crm_instances',$insert_data);
        $insert_id = $this->db->insert_id();
        if ($insert_id > 0 && !empty($insert_id)) {
            $message = array(
                'status' => true,
                'message' => 'CRM add successful.'
            );
            $this->response($message, REST_Controller::HTTP_OK);
        } else {
            $message = array(
                'status' => false,
                'message' => 'CRM add failed.'
            );
            $this->response($message, REST_Controller::HTTP_NOT_FOUND);
        }
      }




    }



}
