$(function () {
  $(document).on('click', '.template_div .list-inline-item', function (event) {
    event.preventDefault();
    var $parent = $(this).closest('ul');
    $parent.find('.check').removeClass('check');
    $(this).addClass('check');
    $(this).find('.select-checkbox-hidden').prop('checked', true).trigger('change');
  });

  $(document).on('click', '.color_div .list-inline-item', function (event) {
    event.preventDefault();
    var $parent = $(this).closest('ul');
    $parent.find('.check').removeClass('check');
    $(this).addClass('check');
    $(this).find('.select-color').prop('checked', true).trigger('change');
  });

  var $color_pic = $('#color-picker');
  if ($color_pic.length) {
    var my_color = $color_pic.data('color');
    $color_pic.colorpicker({color: my_color}).on('changeColor', function (e) {
      var color   = e.color.toString('hex'),
          $parent = $(this).closest('ul'),
          $li     = $(this).closest('li');

      $parent.find('.check').removeClass('check');
      $li.addClass('check');
      $(this).css('background', color);
      $li.find('.select-color').val(color).prop('checked', true).trigger('change');
    });
  }

  var $preview_div = $('.preview-div');
  if ($preview_div.length) {

    $preview_div.each(function (index, value) {
      var id   = $(this).attr('id'),
          name = $(this).data('name');

      $("div#" + id).addClass('dropzone');
      new Dropzone("div#" + id, {
        paramName:             name,
        maxFilesize:           2,
        createImageThumbnails: true,
        acceptedFiles:         'image/*',
        previewTemplate: '<div class="dz-preview dz-file-preview">' +
                             '  <div class="dz-details">' +
                             '    <div class="dz-filename" style="display:none;"><span data-dz-name></span></div>' +
                             '    <div class="dz-size" style="display:none;" data-dz-size></div>' +
                             '  </div>' +
                              '<img data-dz-thumbnail />'+
                             '  <div class="dz-progress" style="display:none;"><span class="dz-upload" data-dz-uploadprogress></span></div>' +
                             '  <div class="dz-success-mark" style="display:none;"><span>✔</span></div>' +
                             '  <div class="dz-error-mark" style="display:none;"><span>✘</span></div>' +
                             '  <div class="dz-error-message" style="display:none;"><span data-dz-errormessage></span></div>' +
                             '</div>',
        params:                {
          template_id:     template_id,
          csrf_token_name: $('input[name="csrf_token_name"]').val()
        },
        url:                   url_upload,
        error:                 function (file, response) {
          console.log(response);
          this.removeFile(file);
          // Do what you want to do with your response
          // This return statement is necessary to remove progress bar after uploading.
          // return file.previewElement.classList.add("dz-error");
        },
        success:               function (file, response) {
          console.log(response);
          // this.removeFile(file);
          // Do what you want to do with your response
          // This return statement is necessary to remove progress bar after uploading.
          // return file.previewElement.classList.add("dz-success");
        },
        complete: function(file){

        }
      });
    });
  }

  $(document).on('change', '#is_stamp_text', function (event) {
    event.preventDefault();
    var $stamp_text = $('#stamp_text');
    $stamp_text.prop('disabled', true).addClass('disabled');
    if($(this)[0].checked){
      $stamp_text.prop('disabled', false).removeClass('disabled');
    }
  });



});
