<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Billing Cloud
Description: DBilling Cloud
Version: 2.3.0
Requires at least: 1.0.*
*/

define('BILLING_MODULE_NAME', 'billing');


$CI = &get_instance();

hooks()->add_action('admin_init', 'billing_init_menu_items');

/**
 * Register activation module hook
 */
register_activation_hook(BILLING_MODULE_NAME, 'billing_activation_hook');

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(BILLING_MODULE_NAME, [BILLING_MODULE_NAME]);

function billing_activation_hook()
{
    $CI = &get_instance();
    //require_once(__DIR__ . '/install.php');
}

/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function billing_init_menu_items()
{

    /**
     * If the logged in user is administrator, add custom menu in Setup
     */
    if (is_admin()) {
        $CI = &get_instance();

        $CI->app_menu->add_setup_children_item('finance', ['slug' => 'billing_config',
            'name' => _l('setup_menu_finance__billing_config'),
            'href' => admin_url('billing/config'),
            'position' => 6,
        ]);

        $CI->app_menu->add_setup_children_item('finance', ['slug' => 'billing_config',
            'name' => _l('setup_menu_finance__billing_config_efactura'),
            'href' => admin_url('billing/efactura'),
            'position' => 7,
        ]);


        $CI->app_menu->add_sidebar_menu_item('billing_collection', [
            'collapse' => true,
            'name' => _l('menu_financial'),
            'position' => 90,
            'icon' => 'fal fal fa-piggy-bank',
        ]);

        $CI->app_menu->add_sidebar_children_item('billing_collection', [
            'slug' => 'billing',
            'name' => _l('menu_billing__invoices'),
            'href' => admin_url('invoices'),
            'position' => 5,
        ]);
        $CI->app_menu->add_sidebar_children_item('billing_collection', [
            'slug' => 'recurring_invoice',
            'name' => _l('menu_billing__reccuring_invoices'),
            'href' => admin_url('invoices/recurring'),
            'position' => 6,
        ]);


        if (has_permission('expenses', '', 'view') || has_permission('expenses', '', 'view_own')) {
            $CI->app_menu->add_sidebar_children_item('billing_collection', ['slug' => 'fiannce_expenses',
                'name' => _l('menu_finance__expenses'),
                'href' => admin_url('expenses'),
                'position' => 7,
            ]);
        }


        $CI->app_menu->add_sidebar_children_item('billing_collection', [
            'slug' => 'credit_notes_invoice',
            'name' => _l('menu_billing__credit_notes'),
            'href' => admin_url('credit_notes'),
            'position' => 5,
        ]);

        $CI->app_menu->add_sidebar_children_item('billing_collection', [
            'slug' => 'payments_invoice',
            'name' => _l('menu_billing__receipts'),
            'href' => admin_url('payments'),
            'position' => 5,
        ]);

        $CI->app_menu->add_sidebar_children_item('billing_collection', [
            'slug' => 'proforma_invoice',
            'name' => _l('menu_billing__proforma_invoices'),
            'href' => admin_url('proformas'),
            'position' => 5,
        ]);

        $CI->app_menu->add_sidebar_children_item('billing_collection', [
            'slug' => 'recurring_proforma_invoice',
            'name' => _l('menu_billing__proformas_recurring'),
            'href' => admin_url('proformas/recurring'),
            'position' => 5,
        ]);


//		if (has_permission('items', '', 'view')) {
//				$CI->app_menu->add_sidebar_children_item('billing_collection', ['slug'=> 'products',
//						'name'     => _l('menu_sales_products'),
//						'href'     => admin_url('invoice_items/index'),
//						'position' => 6,
//				]);
//				$CI->app_menu->add_sidebar_children_item('billing_collection', ['slug'=> 'services',
//						'name'     => _l('menu_sales_services'),
//						'href'     => admin_url('invoice_items/services'),
//						'position' => 7,
//				]);
//		}


        $capabilities = [];

        $capabilities['capabilities'] = [
            'bank' => _l('permission_financial_banks'),
            'series' => _l('permission_financial_series'),
            'template' => _l('permission_financial_template'),
        ];

        register_staff_capabilities('financial', $capabilities, _l('financial'), _l('finance_permissions'));

    }
}
