<?php
require_once(APPPATH . 'third_party/iban/oophp-iban.php');


class Config extends AdminController
{

    public $mediaPath = '';
    public $mediaUrl = '';
    public $media_folder = '';
    public $defaultMediaFolder = '';

    public function __construct()
    {
        parent::__construct();

        $this->load->model('payment_modes_model');
        $this->load->model('settings_model');

        $this->media_folder = $this->app->get_media_folder();
        $this->defaultMediaFolder = '/' . get_option(BILLING_MODULE_NAME . '_default_media_folder');
        $this->mediaPath = FCPATH . $this->media_folder . $this->defaultMediaFolder;
        $this->mediaUrl = APP_BASE_URL . $this->media_folder . $this->defaultMediaFolder;

    }

    /* List all announcements */
    public function index()
    {

        $data['title'] = _l('Billing Config');
        $data['active'] = 'company';

        if ($this->input->post()) {
            if (!has_permission('settings', '', 'edit')) {
                access_denied('settings');
            }

            $post_data = $this->input->post();

            $post_data['settings']['settings_company_vat_payer'] = (int)(isset($post_data['settings']['settings_company_vat_payer']) ? $post_data['settings']['settings_company_vat_payer'] : 0);
            $post_data['settings']['settings_company_vat_on_collection'] = (int)(isset($post_data['settings']['settings_company_vat_on_collection']) ? $post_data['settings']['settings_company_vat_on_collection'] : 0);
            $post_data['settings']['show_tax_per_item'] = (int)(isset($post_data['settings']['show_tax_per_item']) ? $post_data['settings']['show_tax_per_item'] : 0);


            if ($post_data['settings']['settings_company_vat_payer'] == 0) {
                $post_data['settings']['settings_company_vat_on_collection'] = 0;
                $post_data['settings']['show_tax_per_item'] = 0;
            }

            //pre($post_data);
            $success = $this->settings_model->update($post_data);

            if ($success > 0) {
                set_alert('success', _l('settings_updated'));
            }
        }
        $this->load->view('config/index', $data);
    }

    public function bank()
    {
        if (!has_permission('financial', '', 'bank')) {
            access_denied('financial');
        }
        $this->load->model('currencies_model');
        $this->load->model('billing_bank_model');

        if ($this->input->post()) {
            if ($this->input->is_ajax_request()) {
                $update = [];
                if ($this->input->post('status') != '') {
                    $update['status'] = (int)$this->input->post('status');
                }
                if ($this->input->post('iban')) {
                    $update['iban'] = (int)$this->input->post('iban');
                }

                //pre($update);


                if ($update) {
                    $this->billing_bank_model->update($this->input->post('id'), $update);
                }


                echo json_encode([
                    'success' => true,
                    'message' => _l('updated_successfully'),
                ]);
                die;

            } else {

                $post = $this->input->post();

                $iban = new IBAN($post['iban']);
                $validator = $iban->Verify();

                if (!$validator) {
                    set_alert('danger', _l('iban_incorrect'));
                } else {
                    if ($this->billing_bank_model->add($this->input->post())) {
                        set_alert('success', _l('added_successfully', _l('billing_bank')));
                    }
                }


            }
        }

        $data['billing_banks'] = $this->billing_bank_model->get();
        $data['currencies'] = $this->currencies_model->get();
        $data['active'] = 'bank';
        $data['title'] = _l('Bank Config');
        $this->load->view('config/bank', $data);
    }

    public function bank_delete()
    {
        $id = $this->input->post('id');
        $this->db->where('id', $id)->delete('billing_bank');
        echo json_encode([
            'success' => true,
            'message' => _l('deleted_successfully'),
        ]);
        die;

    }

    public function bank_edit($id)
    {
        $this->load->model('billing_bank_model');
        $this->load->model('currencies_model');

        $data['currencies'] = $this->currencies_model->get();
        $data['bank'] = $this->billing_bank_model->get($id);
        echo json_encode([
            'success' => true,
            'html_output' => $this->load->view('config/bank_form', $data, true),
            'message' => _l('deleted_successfully'),
        ]);
        die;
    }


    public function series()
    {
        if (!has_permission('financial', '', 'series')) {
            access_denied('financial');
        }
        $this->load->model('billing_series_model');

        if ($this->input->post()) {
            if ($this->input->is_ajax_request()) {
                $seria_data = $this->billing_series_model->get($this->input->post('id'));
                if (empty($seria_data)) {
                    echo json_encode([
                        'success' => false,
                        'message' => _l('billing_seria_not_found'),
                    ]);
                    die;
                }
                $this->db->where('type', $seria_data->type);
                $this->db->update(db_prefix() . 'billing_series', ['default' => 0]);
                $this->billing_series_model->update($this->input->post('id'), ['default' => (int)$this->input->post('status')]);

                echo json_encode([
                    'success' => true,
                    'message' => _l('updated_successfully'),
                ]);
                die;
            } else {

                if (!$this->input->post('name')) {
                    set_alert('danger', _l('billing_series_validation_set_name'));
                }


                if ($this->input->post('current_number')) {
                    if ((int)$this->input->post('start_number') > ((int)$this->input->post('current_number') + 1)) {
                        set_alert('danger', _l('billing_series_validation_start_num_invalid'));
                    }
                }


                if (!$this->billing_series_model->check($this->input->post())) {
                    if ($this->billing_series_model->add($this->input->post())) {

                        set_alert('success', _l('added_successfully', _l('billing_series')));
                    }
                } else {
                    set_alert('danger', _l('billing_series_already_exists'));
                }
            }


        }

        $data['billing_series'] = $this->billing_series_model->get();
        $data['series_type'] = $this->billing_series_model->get_series_type();

        $data['title'] = _l('billing_series');
        $data['active'] = 'series';
        $this->load->view('config/series', $data);
    }

  

  /**
   * Delete serie action
   * return json
   */
  public function deleteseries()
  {
      $isDeleted = false;

      // Check permissions
      if (!has_permission('financial', '', 'series')) {
          access_denied('financial');
      }

      // Load model
      $this->load->model('billing_series_model');

      if ($this->input->post()) {
          if ($this->input->is_ajax_request()) {

              /**
               * From seria data we will need the
               * name -> being the serie name
               * type -> type serie
               * we will build case for each type
               * for now just invoice
               */

               // Get serie data
              $seria_data = $this->billing_series_model->get($this->input->post('id'));


              // Case serie type
              switch ($seria_data->type) {
                // INVOICE
                case 'invoice':
                  // Load item model
                  $this->load->model('invoices_model');

                  // Check for serie
                  $item_with_series = $this->invoices_model->checkSerie($seria_data->name);

                  if ($item_with_series) {

                      //  There are items with this series
                      echo json_encode([
                          'error' => true,
                          'message' => _l('there_are_invoices_with_this_serie'),
                      ]);
                      die;
                  }
                  break;

                // PROFORMA
                case 'proforma':
                  // Load item model
                  $this->load->model('proformas_model');

                  // Check for serie
                  $item_with_series = $this->proformas_model->checkSerie($seria_data->name);

                  if ($item_with_series) {

                      // There are items with this series
                      echo json_encode([
                          'error' => true,
                          'message' => _l('there_are_proformas_with_this_serie'),
                      ]);
                      die;
                  }
                  break;

                // CASH RECEIPT
                case 'cash_receipt':
                  // Load item model
                  $this->load->model('cash_receipts_model');

                  // Check for serie
                  $item_with_series = $this->cash_receipts_model->checkSerie($seria_data->name);

                  if ($item_with_series) {

                      //  There are items with this series
                      echo json_encode([
                          'error' => true,
                          'message' => _l('there_are_cashreceipts_with_this_serie'),
                      ]);
                      die;
                  }
                  break;

                // ESTIMATE
                case 'estimate':
                  // Load item model
                  $this->load->model('estimates_model');

                  // Check for serie
                  $item_with_series = $this->estimates_model->checkSerie($seria_data->name);

                  if ($item_with_series) {

                      //  There are items with this series
                      echo json_encode([
                          'error' => true,
                          'message' => _l('there_are_estimates_with_this_serie'),
                      ]);
                      die;
                  }
                  break;

                // PROPOSAL
                case 'proposal':
                  // Load item model
                  $this->load->model('proposals_model');

                  // Check for serie
                  $item_with_series = $this->proposals_model->checkSerie($seria_data->name);

                  if ($item_with_series) {

                      //  There are items with this series
                      echo json_encode([
                          'error' => true,
                          'message' => _l('there_are_proposals_with_this_serie'),
                      ]);
                      die;
                  }
                  break;

                default:
                  break;
              }

              if (empty($seria_data)) {
                  echo json_encode([
                      'success' => false,
                      'message' => _l('billing_seria_not_found'),
                  ]);
                  die;
              }

              // No invoices found with this series, proceed with deletion
              $isDeleted = $this->billing_series_model->delete($this->input->post('id'));

              if ($isDeleted) {
                  echo json_encode([
                      'success' => true,
                      'message' => _l('deleted_successfully'),
                  ]);
              }
          }
      }
  }

  public function template()
  {
    if (!has_permission('financial', '', 'template')) {
      access_denied('financial');
    }
    $this->load->model('billing_series_model');
    $this->load->model('billing_template_model');

    $billing_series_id = $data['billing_series_id'] = (int)$this->input->post('billing_series_id', true);
    $billing_series    = $this->billing_series_model->get_customizable_doc();

    $selected = $this->billing_series_model->get($billing_series_id);

    if (!$selected && $billing_series) {
      $selected = json_decode(json_encode($billing_series[0]));
    }
    $data['selected_seria'] = $selected;

    if ($this->input->post('series')) {
      $this->billing_series_model->update($billing_series_id, $this->input->post('series'));
      $data['selected_seria'] = $this->billing_series_model->get($billing_series_id);
    }

    $billing_series_dd = [];
    foreach ($billing_series as $bs) {
      $billing_series_dd[$bs['id']] = $bs['name'] . ' - <small>' . $bs['type'] . '</small>';
    }

    $data['billing_series_dd'] = $billing_series_dd;
    $data['template_data'] = $this->billing_template_model->get_template_default_data();
    $data['format_data']   = $this->billing_template_model->get_format_default_data();
    $data['color_data']    = $this->billing_template_model->get_color_default_data();


    $data['title']  = _l('billing_template');
    $data['active'] = 'template';

    $data['options']['invoice_logo'] = get_option('invoice_logo');
    $data['options']['invoice_bg'] = get_option('invoice_bg');
    $data['options']['invoice_stamp'] = get_option('invoice_stamp');

    $this->load->view('config/template', $data);
  }
  public function template_old()
  {

    $this->load->model('billing_series_model');
    $this->load->model('billing_template_model');

    $billing_series_id = (int)$this->input->post('billing_series_id', true);
    $billing_series    = $this->billing_series_model->get_customizable_doc();

    $selected = $this->billing_series_model->get($billing_series_id);

    if (!$selected && $billing_series) {
      $selected = json_decode(json_encode($billing_series[0]));
    }

    $template = $this->billing_template_model->getBySeries($selected->id);

    if (!$template) {
      $template                      = $this->billing_template_model->get_default_data();
      $template['billing_series_id'] = $selected->id;
      $template['id']                = $this->billing_template_model->add($template);
      $template                      = json_decode(json_encode($template));
    }
    if ($this->input->post('invoice')) {
      $template = $this->billing_template_model->update($template->id, $this->input->post('invoice'));
    }

    $billing_series_dd = [];
    foreach ($billing_series as $bs) {
      $billing_series_dd[$bs['id']] = $bs['name'] . ' - <small>' . $bs['type'] . '</small>';
    }

    $data['billing_series_dd'] = $billing_series_dd;
    $data['template']      = $template;
    $data['template_data'] = $this->billing_template_model->get_template_default_data();
    $data['format_data']   = $this->billing_template_model->get_format_default_data();
    $data['color_data']    = $this->billing_template_model->get_color_default_data();


    $data['title']  = _l('billing_template');
    $data['active'] = 'template';

    $data['options']['invoice_logo'] = get_option('invoice_logo');

    $this->load->view('config/template', $data);
  }

  public function view_template()
  {
    $this->load->model('billing_series_model');
    $this->load->model('billing_template_model');
    $this->load->model('clients_model');

    $data = $this->input->post('invoice');

    $client_id = (int)$this->input->post('client_id', true);

    if ($client_id) {
      $data['client_info'] = $this->clients_model->get($this->input->post('client_id', true));
    } else {
      $data['client_info'] = $this->clients_model->get_default_data_client();
    }

    $template_info = $this->billing_template_model->getBySeries((int)$this->input->post('billing_series_id', true));
    $serie = $this->billing_series_model->get((int)$this->input->post('billing_series_id', true));

    $data['logo']     = file_exists($this->mediaPath . $template_info->logo) ? $this->mediaUrl . $template_info->logo : '';
    $data['series']   = $serie->name;
    $data['number']   = 1;
    $data['date']     = date('d/m/Y');
    $data['due_date'] = date('d/m/Y');

    $html = $this->load->view('templates/content/template_' . $data['template'], $data, true);

    die($html);
  }

  public function setting()
  {

    $this->load->model('billing_setting_model');

    if ($data = $this->input->post()) {
      if(empty($data['view_due_date'])) $data['due_date'] = 0;
      unset($data['view_due_date']);
      $setting = $this->billing_setting_model->update($data);
      set_alert('success', _l('added_successfully', _l('billing_setting')));
    } else {
      $setting = $this->billing_setting_model->get();
    }
    
    $data['setting'] = $setting;

    $data['title']  = _l('billing_setting');
    $data['active'] = 'setting';
    $this->load->view('config/setting', $data);
  }

  public function notification()
  {

    $this->load->model('billing_notification_model');

    $data['notifications'] = $this->billing_notification_model->get();

    $data['title']  = _l('billing_notification');
    $data['active'] = 'notification';
    $this->load->view('config/notification', $data);
  }

  public function saveNotification()
  {
    $this->load->model('billing_notification_model');

    $data = $this->input->post();

    $id = isset($data['id']) ? (int)$data['id'] : 0;

    unset($data['id']);

    $notification = $this->billing_notification_model->get($id);

    if(!$notification){
      show_404();
    }

    $success = $this->billing_notification_model->update($id, $data);

    if ($success == true) {
      set_alert('success', _l('updated_successfully', ''));
    } else {
      set_alert('danger', _l('updated_successfully', ''));
    }

    redirect(admin_url('billing/config/notification'));
  }

  public function toggleNotification($id = 0, $active = 0)
  {
    $this->load->model('billing_notification_model');

    $notification = $this->billing_notification_model->get($id);

    if(!$notification){
      show_404();
    }

    $success = $this->billing_notification_model->update($id, ['active' => (int)$active]);

    if ($success == true) {
      set_alert('success', _l('updated_successfully', ''));
    } else {
      set_alert('danger', _l('updated_successfully', ''));
    }

    redirect(admin_url('billing/config/notification'));
  }

  public function email()
  {
    $this->load->model('payment_modes_model');
    $this->load->model('settings_model');

    $data = $this->input->post();

    if ($data) {
      $success = $this->settings_model->update($data);

      if ($success > 0) {
        set_alert('success', _l('settings_updated'));
      }
    }

    $data['title']  = _l('billing_email');
    $data['active'] = 'email';
    $this->load->view('config/email', $data);
  }

  public function upload_file_template()
  {
    $this->load->model('billing_template_model');
    $template = $this->billing_template_model->get((int)$this->input->post('template_id', true));
    if (!$template) return $this->json_output(['error' => 'Template not found', 'success' => false]);

    $this->load->helper('path');
    $media_folder       = $this->app->get_media_folder();
    $defaultMediaFolder = '/' . get_option(BILLING_MODULE_NAME . '_default_media_folder');
    $mediaPath          = FCPATH . $media_folder . $defaultMediaFolder;

    if (!is_dir($this->mediaPath)) {
      mkdir($mediaPath, 0755);
    }

    $config['upload_path']   = set_realpath($media_folder . $defaultMediaFolder, true);
    $config['allowed_types'] = 'jpg|jpeg|png|gif';
    $config['encrypt_name']  = true;
    $config['max_size']      = (int)get_option('media_max_file_size_upload') * 1000;

    $this->load->library('upload', $config);

    if (!$this->upload->do_upload('logo')) {
      $error = ['error' => $this->upload->display_errors('', ''), 'success' => false];

      return $this->json_output($error);
    } else {
      if (file_exists($mediaPath . $template->logo)) {
        unlink($mediaPath . $template->logo);
      }

      $template->logo = $this->upload->data('file_name');
      $this->billing_template_model->update($template->id, (array)$template);

      return $this->json_output(['success' => true, 'path' => site_url($media_folder) . $defaultMediaFolder . $this->upload->data('file_name')]);
    }
  }

  protected function json_output($data)
  {
    if (isset($data['success']) && !$data['success']) http_response_code(404);

    return $this->output->set_content_type('application/json')->set_output(json_encode($data));
  }

    public function upload_bg(){
        if(!empty($_FILES['file']['name'])){
            $path = FCPATH."uploads/company/";
            $config['upload_path'] = $path;
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $config['max_size'] = '4000';
            $config['max_width']  = '800';
            $config['max_height']  = '800';
            $new_name = $_FILES["file"]['name'];
            $config['file_name'] = $new_name;
            $this->load->library('upload',$config);

            if(is_dir($path)){

            }else{
                $error = array('status'=>'error','message' => 'The upload folder does not exist');
                echo json_encode($error); exit;
            }

            if($this->upload->do_upload('file')){
                $uploadData = $this->upload->data();
                $fname = $uploadData['file_name'];

                $response['status'] = 'success';
                $response['src'] = APP_BASE_URL.'/uploads/company/'.$fname;
                $response['width'] = $uploadData['image_width'];
                $response['height'] = $uploadData['image_height'];
                update_option('invoice_bg',$fname);
                echo json_encode($response); exit;

            }else{
                $error = array('status'=>'error','message' => $this->upload->display_errors());
                echo json_encode($error); exit;
            }
        }else{
            $error = array('status'=>'error','message' => 'File not uploaded');
            echo json_encode($error); exit;
        }





    }

    public function upload_logo()
    {
        //pre($_FILES['file']);

        if (!empty($_FILES['file']['name'])) {
            $path = FCPATH . "uploads/company/";
            $config['upload_path'] = $path;
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $config['max_size'] = '4000';
            $config['max_width'] = '800';
            $config['max_height'] = '800';
            $new_name = $_FILES["file"]['name'];
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);

            if (is_dir($path)) {

            } else {
                $error = array('status' => 'error', 'message' => 'The upload folder does not exist');
                echo json_encode($error);
                exit;
            }

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $fname = $uploadData['file_name'];

                $response['status'] = 'success';
                $response['src'] = APP_BASE_URL . 'uploads/company/' . $fname;
                $response['width'] = $uploadData['image_width'];
                $response['height'] = $uploadData['image_height'];
                update_option('invoice_logo', $fname);
                echo json_encode($response);
                exit;

                /*$this->db->where('registration_id',$registration_id)->update('course_registration',[
                  'admin_ct_date'=>date('Y-m-d H:i:s'),
                  'admin_ct_file'=>$uploadData['file_path'].$fname,
                  'enroll_status'=>3,
                ]);*/


            } else {
                $error = array('status' => 'error', 'message' => $this->upload->display_errors());
                echo json_encode($error);
                exit;
            }
        } else {
            $error = array('status' => 'error', 'message' => 'File not uploaded');
            echo json_encode($error);
            exit;
        }


    }

    public function upload_stamp()
    {
        if (!empty($_FILES['file']['name'])) {
            $path = FCPATH . "uploads/company/";
            $config['upload_path'] = $path;
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $config['max_size'] = '4000';
            $config['max_width'] = '800';
            $config['max_height'] = '800';
            $new_name = $_FILES["file"]['name'];
            $config['file_name'] = $new_name;
            $this->load->library('upload', $config);

            if (is_dir($path)) {

            } else {
                $error = array('status' => 'error', 'message' => 'The upload folder does not exist');
                echo json_encode($error);
                exit;
            }

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $fname = $uploadData['file_name'];

                $response['status'] = 'success';
                $response['src'] = APP_BASE_URL . '/uploads/company/' . $fname;
                $response['width'] = $uploadData['image_width'];
                $response['height'] = $uploadData['image_height'];
                update_option('invoice_stamp', $fname);
                echo json_encode($response);
                exit;
            } else {
                $error = array('status' => 'error', 'message' => $this->upload->display_errors());
                echo json_encode($error);
                exit;
            }
        } else {
            $error = array('status' => 'error', 'message' => 'File not uploaded');
            echo json_encode($error);
            exit;
        }


    }


    public function remove_invoice_bg()
    {
        if (!has_permission('settings', '', 'delete')) {
            access_denied('settings');
        }
        if (file_exists(get_upload_path_by_type('company') . '/' . get_option('invoice_bg'))) {
            unlink(get_upload_path_by_type('company') . '/' . get_option('invoice_bg'));
        }
        update_option('invoice_bg', '');
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function remove_invoice_logo()
    {
        if (!has_permission('settings', '', 'delete')) {
            access_denied('settings');
        }
        if (file_exists(get_upload_path_by_type('company') . '/' . get_option('invoice_logo'))) {
            unlink(get_upload_path_by_type('company') . '/' . get_option('invoice_logo'));
        }
        update_option('invoice_logo', '');
        redirect($_SERVER['HTTP_REFERER']);
    }

    public function remove_invoice_stamp()
    {
        if (!has_permission('settings', '', 'delete')) {
            access_denied('settings');
        }
        if (file_exists(get_upload_path_by_type('company') . '/' . get_option('invoice_stamp'))) {
            unlink(get_upload_path_by_type('company') . '/' . get_option('invoice_stamp'));
        }
        update_option('invoice_stamp', '');
        redirect($_SERVER['HTTP_REFERER']);
    }

}
